/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebean.config.dbplatform;

import com.avaje.ebean.BackgroundExecutor;
import com.avaje.ebean.Transaction;
import com.avaje.ebean.config.dbplatform.IdGenerator;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.persistence.PersistenceException;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SequenceIdGenerator
implements IdGenerator {
    private static final Logger logger = LoggerFactory.getLogger(SequenceIdGenerator.class);
    protected final Object monitor = new Object();
    protected final Object backgroundLoadMonitor = new Object();
    protected final String seqName;
    protected final DataSource dataSource;
    protected final BackgroundExecutor backgroundExecutor;
    protected final ArrayList<Long> idList = new ArrayList(50);
    protected final int batchSize;
    protected int currentlyBackgroundLoading;

    public SequenceIdGenerator(BackgroundExecutor be, DataSource ds, String seqName, int batchSize) {
        this.backgroundExecutor = be;
        this.dataSource = ds;
        this.seqName = seqName;
        this.batchSize = batchSize;
    }

    public abstract String getSql(int var1);

    @Override
    public String getName() {
        return this.seqName;
    }

    @Override
    public boolean isDbSequence() {
        return true;
    }

    @Override
    public void preAllocateIds(int allocateSize) {
        if (this.batchSize > 1 && allocateSize > this.batchSize) {
            if (allocateSize > 100) {
                allocateSize = 100;
            }
            this.loadLargeAllocation(allocateSize);
        }
    }

    protected void loadLargeAllocation(final int allocateSize) {
        this.backgroundExecutor.execute(new Runnable(){

            @Override
            public void run() {
                SequenceIdGenerator.this.loadMoreIds(allocateSize, null);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object nextId(Transaction t) {
        Object object = this.monitor;
        synchronized (object) {
            if (this.idList.size() == 0) {
                this.loadMoreIds(this.batchSize, t);
            }
            Long nextId = this.idList.remove(0);
            if (this.batchSize > 1 && this.idList.size() <= this.batchSize / 2) {
                this.loadBatchInBackground();
            }
            return nextId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadBatchInBackground() {
        Object object = this.backgroundLoadMonitor;
        synchronized (object) {
            if (this.currentlyBackgroundLoading > 0) {
                logger.debug("... skip background sequence load (another load in progress)");
                return;
            }
            this.currentlyBackgroundLoading = this.batchSize;
            this.backgroundExecutor.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    SequenceIdGenerator.this.loadMoreIds(SequenceIdGenerator.this.batchSize, null);
                    Object object = SequenceIdGenerator.this.backgroundLoadMonitor;
                    synchronized (object) {
                        SequenceIdGenerator.this.currentlyBackgroundLoading = 0;
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadMoreIds(int numberToLoad, Transaction t) {
        ArrayList<Long> newIds = this.getMoreIds(numberToLoad, t);
        if (logger.isDebugEnabled()) {
            logger.debug("... seq:" + this.seqName + " loaded:" + numberToLoad + " ids:" + newIds);
        }
        Object object = this.monitor;
        synchronized (object) {
            for (int i = 0; i < newIds.size(); ++i) {
                this.idList.add(newIds.get(i));
            }
        }
    }

    protected ArrayList<Long> getMoreIds(int loadSize, Transaction t) {
        String sql = this.getSql(loadSize);
        ArrayList<Long> newIds = new ArrayList<Long>(loadSize);
        boolean useTxnConnection = t != null;
        Connection c = null;
        PreparedStatement pstmt = null;
        ResultSet rset = null;
        try {
            c = useTxnConnection ? t.getConnection() : this.dataSource.getConnection();
            pstmt = c.prepareStatement(sql);
            rset = pstmt.executeQuery();
            while (rset.next()) {
                newIds.add(rset.getLong(1));
            }
            if (newIds.size() == 0) {
                throw new PersistenceException("Always expecting more than 1 row from " + sql);
            }
            ArrayList<Long> arrayList = newIds;
            if (useTxnConnection) {
                this.closeResources(null, pstmt, rset);
            } else {
                this.closeResources(c, pstmt, rset);
            }
            return arrayList;
        }
        catch (SQLException e) {
            block13: {
                try {
                    if (!e.getMessage().contains("Database is already closed")) break block13;
                    String msg = "Error getting SEQ when DB shutting down " + e.getMessage();
                    logger.info(msg);
                    System.out.println(msg);
                    ArrayList<Long> arrayList = newIds;
                    if (useTxnConnection) {
                        this.closeResources(null, pstmt, rset);
                    } else {
                        this.closeResources(c, pstmt, rset);
                    }
                    return arrayList;
                }
                catch (Throwable throwable) {
                    if (useTxnConnection) {
                        this.closeResources(null, pstmt, rset);
                    } else {
                        this.closeResources(c, pstmt, rset);
                    }
                    throw throwable;
                }
            }
            throw new PersistenceException("Error getting sequence nextval", (Throwable)e);
        }
    }

    protected void closeResources(Connection c, PreparedStatement pstmt, ResultSet rset) {
        try {
            if (rset != null) {
                rset.close();
            }
        }
        catch (SQLException e) {
            logger.error("Error closing ResultSet", (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
        }
        catch (SQLException e) {
            logger.error("Error closing PreparedStatement", (Throwable)e);
        }
        try {
            if (c != null) {
                c.close();
            }
        }
        catch (SQLException e) {
            logger.error("Error closing Connection", (Throwable)e);
        }
    }
}

