/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebean;

import com.avaje.ebean.Ebean;
import com.avaje.ebean.EbeanServer;
import com.avaje.ebean.PrimaryServer;
import com.avaje.ebean.common.SpiContainer;
import com.avaje.ebean.config.ContainerConfig;
import com.avaje.ebean.config.ServerConfig;
import com.avaje.ebeaninternal.server.lib.ShutdownManager;
import java.lang.reflect.Constructor;
import java.util.Properties;
import javax.persistence.PersistenceException;

public class EbeanServerFactory {
    private static final String DEFAULT_CONTAINER = "com.avaje.ebeaninternal.server.core.DefaultContainer";
    private static SpiContainer container;

    public static synchronized void initialiseContainer(ContainerConfig containerConfig) {
        EbeanServerFactory.getContainer(containerConfig);
    }

    public static synchronized EbeanServer create(String name) {
        SpiContainer serverFactory = EbeanServerFactory.getContainer(null);
        return serverFactory.createServer(name);
    }

    public static synchronized EbeanServer create(ServerConfig config) {
        if (config.getName() == null) {
            throw new PersistenceException("The name is null (it is required)");
        }
        EbeanServer server = EbeanServerFactory.createInternal(config);
        if (config.isDefaultServer()) {
            PrimaryServer.setSkip(true);
        }
        if (config.isRegister()) {
            Ebean.register(server, config.isDefaultServer());
        }
        return server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized EbeanServer createWithContextClassLoader(ServerConfig config, ClassLoader classLoader) {
        ClassLoader currentContextLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(classLoader);
        try {
            EbeanServer ebeanServer = EbeanServerFactory.create(config);
            return ebeanServer;
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentContextLoader);
        }
    }

    public static synchronized void shutdown() {
        ShutdownManager.shutdown();
    }

    private static EbeanServer createInternal(ServerConfig config) {
        return EbeanServerFactory.getContainer(config.getContainerConfig()).createServer(config);
    }

    private static SpiContainer getContainer(ContainerConfig containerConfig) {
        if (container != null) {
            return container;
        }
        if (containerConfig == null) {
            Properties properties = PrimaryServer.getProperties();
            containerConfig = new ContainerConfig();
            containerConfig.loadFromProperties(properties);
        }
        container = EbeanServerFactory.createContainer(containerConfig);
        return container;
    }

    protected static SpiContainer createContainer(ContainerConfig containerConfig) {
        String implClassName = System.getProperty("ebean.container", DEFAULT_CONTAINER);
        try {
            Class<?> cls = Class.forName(implClassName);
            Constructor<?> constructor = cls.getConstructor(ContainerConfig.class);
            return (SpiContainer)constructor.newInstance(containerConfig);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

