/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.wasync.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.atmosphere.wasync.Decoder;
import org.atmosphere.wasync.Event;
import org.atmosphere.wasync.Request;
import org.atmosphere.wasync.RequestBuilder;
import org.atmosphere.wasync.decoder.PaddingAndHeartbeatDecoder;
import org.atmosphere.wasync.decoder.TrackMessageSizeDecoder;
import org.atmosphere.wasync.impl.DefaultRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtmosphereRequest
extends DefaultRequest<AtmosphereRequestBuilder> {
    private static final Logger logger = LoggerFactory.getLogger(AtmosphereRequest.class);

    protected AtmosphereRequest(AtmosphereRequestBuilder builder) {
        super(builder);
    }

    public CACHE getCacheType() {
        return ((AtmosphereRequestBuilder)this.builder).getCacheType();
    }

    public boolean isTrackMessageLength() {
        return ((AtmosphereRequestBuilder)this.builder).trackMessageLength;
    }

    public boolean enableProtocol() {
        return ((AtmosphereRequestBuilder)this.builder).enableProtocol;
    }

    public String getTrackMessageLengthDelimiter() {
        return ((AtmosphereRequestBuilder)this.builder).trackMessageLengthDelimiter;
    }

    public int getPaddingSize() {
        return ((AtmosphereRequestBuilder)this.builder).paddingSize;
    }

    public static class AtmosphereRequestBuilder
    extends RequestBuilder<AtmosphereRequestBuilder> {
        private CACHE cacheType = CACHE.NO_BROADCAST_CACHE;
        private boolean trackMessageLength = false;
        private String trackMessageLengthDelimiter = "|";
        private int paddingSize = 4098;
        private boolean enableProtocol = true;
        private final BDecoder bDecoder = new BDecoder();
        private final SDecoder sDecoder = new SDecoder();

        public AtmosphereRequestBuilder() {
            super(AtmosphereRequestBuilder.class);
        }

        private CACHE getCacheType() {
            return this.cacheType;
        }

        @Override
        public AtmosphereRequestBuilder transport(Request.TRANSPORT t) {
            if (this.queryString.get("X-Atmosphere-Transport") == null) {
                ArrayList<String> l = new ArrayList<String>();
                if (t.equals((Object)Request.TRANSPORT.LONG_POLLING)) {
                    l.add("long-polling");
                } else {
                    l.add(t.name().toLowerCase());
                }
                this.queryString.put("X-Atmosphere-Transport", l);
            }
            this.transports.add(t);
            return (AtmosphereRequestBuilder)this.derived.cast(this);
        }

        public AtmosphereRequestBuilder cache(CACHE c) {
            this.cacheType = c;
            return this;
        }

        public AtmosphereRequestBuilder trackMessageLength(boolean trackMessageLength) {
            this.trackMessageLength = trackMessageLength;
            return this;
        }

        public AtmosphereRequestBuilder trackMessageLengthDelimiter(String trackMessageLengthDelimiter) {
            this.trackMessageLengthDelimiter = trackMessageLengthDelimiter;
            return this;
        }

        public AtmosphereRequestBuilder enableProtocol(boolean enableProtocol) {
            this.enableProtocol = enableProtocol;
            return this;
        }

        public AtmosphereRequestBuilder paddingSize(int paddingSize) {
            this.paddingSize = paddingSize;
            return this;
        }

        @Override
        public AtmosphereRequest build() {
            ArrayList<String> l;
            if (this.enableProtocol) {
                l = new ArrayList<String>();
                l.add("2.3.0");
                this.queryString.put("X-Atmosphere-Framework", l);
                l = new ArrayList();
                l.add("0");
                this.queryString.put("X-Atmosphere-tracking-id", l);
                l = new ArrayList();
                l.add("true");
                this.queryString.put("X-atmo-protocol", l);
                List ct = this.headers().getAll("Content-Type");
                if (ct != null && ct.size() > 0) {
                    l = new ArrayList();
                    l.addAll(ct);
                    this.queryString.put("Content-Type", l);
                }
                this._addDecoder(0, this.sDecoder);
                this._addDecoder(0, this.bDecoder);
            }
            if (this.trackMessageLength) {
                l = new ArrayList();
                l.add("true");
                this.queryString.put("X-Atmosphere-TrackMessageSize", l);
                TrackMessageSizeDecoder trackMessageSizeDecoder = this.trackMessageLengthDelimiter.length() > 0 ? new TrackMessageSizeDecoder(this.trackMessageLengthDelimiter, this.enableProtocol) : new TrackMessageSizeDecoder(this.enableProtocol);
                this._addDecoder(0, trackMessageSizeDecoder);
            }
            return new AtmosphereRequest(this);
        }

        private void _addDecoder(int pos, Decoder decoder) {
            if (!this.decoders.contains(decoder)) {
                this.decoders.add(pos, decoder);
            }
        }

        private void _addDecoder(Decoder decoder) {
            if (!this.decoders.contains(decoder)) {
                this.decoders.add(decoder);
            }
        }

        private final void handleProtocol(String s) {
            String[] proto = s.trim().split("\\|");
            int pos = this.trackMessageLength ? 1 : 0;
            ArrayList<String> l = new ArrayList<String>();
            l.add(proto[pos]);
            this.queryString.put("X-Atmosphere-tracking-id", l);
            String heartbeatChar = "X";
            if (proto.length == 3) {
                heartbeatChar = proto[2];
            }
            this._addDecoder(2, new PaddingAndHeartbeatDecoder(this.paddingSize, heartbeatChar));
        }

        private final class BDecoder
        implements Decoder<byte[], Decoder.Decoded<byte[]>> {
            private AtomicBoolean protocolReceived = new AtomicBoolean();

            private BDecoder() {
            }

            @Override
            public Decoder.Decoded<byte[]> decode(Event e, byte[] b) {
                if (e.equals((Object)Event.MESSAGE) && !this.protocolReceived.getAndSet(true)) {
                    try {
                        AtmosphereRequestBuilder.this.handleProtocol(new String(b, "UTF-8"));
                        AtmosphereRequestBuilder.this.decoders.remove(this);
                        AtmosphereRequestBuilder.this.decoders.remove(AtmosphereRequestBuilder.this.sDecoder);
                        return Decoder.Decoded.ABORT;
                    }
                    catch (Exception ex) {
                        logger.warn("Unable to decode the protocol {}", (Object)new String(b));
                        logger.warn("", (Object)e);
                    }
                }
                return new Decoder.Decoded<byte[]>(b);
            }
        }

        private final class SDecoder
        implements Decoder<String, Decoder.Decoded<String>> {
            private AtomicBoolean protocolReceived = new AtomicBoolean();

            private SDecoder() {
            }

            @Override
            public Decoder.Decoded<String> decode(Event e, String s) {
                if (e.equals((Object)Event.MESSAGE) && !this.protocolReceived.getAndSet(true)) {
                    try {
                        AtmosphereRequestBuilder.this.handleProtocol(s);
                        AtmosphereRequestBuilder.this.decoders.remove(this);
                        AtmosphereRequestBuilder.this.decoders.remove(AtmosphereRequestBuilder.this.bDecoder);
                        return Decoder.Decoded.ABORT;
                    }
                    catch (Exception ex) {
                        logger.warn("Unable to decode the protocol {}", (Object)s);
                        logger.warn("", (Object)e);
                    }
                }
                return new Decoder.Decoded<String>(s);
            }
        }
    }

    public static enum CACHE {
        HEADER_BROADCAST_CACHE,
        UUID_BROADCASTER_CACHE,
        SESSION_BROADCAST_CACHE,
        NO_BROADCAST_CACHE;

    }
}

