/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.wasync.decoder;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Predicate;
import org.atmosphere.wasync.Decoder;
import org.atmosphere.wasync.Event;
import org.atmosphere.wasync.ReplayDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrackMessageSizeDecoder
implements ReplayDecoder<String, String> {
    private final Logger logger = LoggerFactory.getLogger(TrackMessageSizeDecoder.class);
    private final String delimiter;
    private final StringBuffer messagesBuffer = new StringBuffer();
    private final AtomicBoolean skipFirstMessage = new AtomicBoolean();
    private final Decoder.Decoded<List<String>> empty = new Decoder.Decoded(Collections.emptyList());

    public TrackMessageSizeDecoder() {
        this.delimiter = String.format("\\%s", "|");
    }

    public TrackMessageSizeDecoder(boolean protocolEnabled) {
        this.delimiter = "|";
        this.skipFirstMessage.set(protocolEnabled);
    }

    public TrackMessageSizeDecoder(String delimiter, boolean protocolEnabled) {
        this.delimiter = delimiter;
        this.skipFirstMessage.set(protocolEnabled);
    }

    @Override
    public Decoder.Decoded<List<String>> decode(Event eventType, String message) {
        return this.decodeMessageIfEventIsTypeMessage(eventType, message);
    }

    private Decoder.Decoded<List<String>> decodeMessageIfEventIsTypeMessage(Event eventType, String message) {
        if (this.isEventTypeNotMessageOrFirstMessageSkipped(eventType)) {
            return this.empty;
        }
        return this.decodeMessage().apply(message);
    }

    private boolean isEventTypeNotMessageOrFirstMessageSkipped(Event eventType) {
        return !this.isMessageEvent(eventType) || this.skipFirstMessage.getAndSet(false);
    }

    private Function<String, Decoder.Decoded<List<String>>> decodeMessage() {
        return this.constructDecodedListFromMessageList().compose(this.constructListOfMessages()).compose(this.separateSizeAndPayload()).compose(this.assembleIncompleteMessage());
    }

    private boolean isMessageEvent(Event event) {
        return event.equals((Object)Event.MESSAGE);
    }

    private Function<String, String> assembleIncompleteMessage() {
        return message -> {
            message = this.messagesBuffer.append((String)message).toString();
            this.messagesBuffer.setLength(0);
            return message;
        };
    }

    private Function<String, String[]> separateSizeAndPayload() {
        return message -> message.split(String.format("\\%s", this.delimiter), 2);
    }

    private Function<String[], List<String>> constructListOfMessages() {
        return message -> {
            if (this.doesMessageContainMessageLength().and(this.messageContainDelimiter()).test((String[])message)) {
                return this.addCompleteMessageToListRecursive().compose(this.readMessageContentIntoMap()).apply((String[])message);
            }
            this.messagesBuffer.append(message[0]);
            return new LinkedList();
        };
    }

    private Predicate<String[]> doesMessageContainMessageLength() {
        return messageList -> this.convertPayloadSizeFromStringToInt(messageList[0]).isPresent();
    }

    private Predicate<String[]> messageContainDelimiter() {
        return messageList -> ((String[])messageList).length > 1;
    }

    private Function<List<String>, Decoder.Decoded<List<String>>> constructDecodedListFromMessageList() {
        return Decoder.Decoded::new;
    }

    private Function<Map<String, String>, List<String>> addCompleteMessageToListRecursive() {
        return extractedAndRemainingMessage -> {
            Optional<Integer> payloadSize = this.convertPayloadSizeFromStringToInt((String)extractedAndRemainingMessage.get("payloadSize"));
            return payloadSize.map(messageLength -> this.convertMappedMessagesToMessageList((Map<String, String>)extractedAndRemainingMessage, (Integer)messageLength)).orElseGet(LinkedList::new);
        };
    }

    private List<String> convertMappedMessagesToMessageList(Map<String, String> extractedAndRemainingMessage, Integer messageLength) {
        LinkedList<String> messageList = new LinkedList<String>();
        if (extractedAndRemainingMessage.get("extractedMessage").length() == messageLength.intValue()) {
            messageList.add(extractedAndRemainingMessage.get("extractedMessage"));
        }
        if (!extractedAndRemainingMessage.get("remainingMessage").isEmpty()) {
            messageList.addAll((Collection<String>)this.constructListOfMessages().compose(this.separateSizeAndPayload()).apply(extractedAndRemainingMessage.get("remainingMessage")));
        }
        return messageList;
    }

    private Optional<Integer> convertPayloadSizeFromStringToInt(String message) {
        try {
            return Optional.of(Integer.valueOf(message));
        }
        catch (NumberFormatException e) {
            return Optional.empty();
        }
    }

    private Function<String[], Map<String, String>> readMessageContentIntoMap() {
        return message -> {
            HashMap messageMap = new HashMap();
            Optional<Integer> payloadSize = this.convertPayloadSizeFromStringToInt(message[0]);
            payloadSize.ifPresent(messageLength -> {
                messageMap.put("payloadSize", message[0]);
                if (message[1].length() >= messageLength) {
                    messageMap.put("extractedMessage", message[1].substring(0, (int)messageLength));
                    messageMap.put("remainingMessage", message[1].substring((int)messageLength));
                } else {
                    this.messagesBuffer.append((String)messageMap.get("payloadSize")).append(this.delimiter).append(message[1]);
                    messageMap.put("extractedMessage", message[1]);
                    messageMap.put("remainingMessage", "");
                }
            });
            return messageMap;
        };
    }
}

