/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.wasync.transport;

import com.ning.http.client.AsyncHandler;
import com.ning.http.client.HttpResponseBodyPart;
import com.ning.http.client.HttpResponseHeaders;
import com.ning.http.client.HttpResponseStatus;
import com.ning.http.client.RequestBuilder;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.atmosphere.wasync.Event;
import org.atmosphere.wasync.FunctionWrapper;
import org.atmosphere.wasync.Options;
import org.atmosphere.wasync.Request;
import org.atmosphere.wasync.Socket;
import org.atmosphere.wasync.transport.StreamTransport;
import org.atmosphere.wasync.transport.TransportsUtil;
import org.atmosphere.wasync.util.Utils;

public class LongPollingTransport
extends StreamTransport {
    private final AtomicBoolean handshakeOccured = new AtomicBoolean(true);
    protected boolean protocolReceived = false;
    private int count = 0;

    public LongPollingTransport(RequestBuilder requestBuilder, Options options, Request request, List<FunctionWrapper> functions) {
        super(requestBuilder, options, request, functions);
        List<String> protocol = request.queryString().get("X-atmo-protocol");
        List<String> transport = request.queryString().get("X-Atmosphere-Transport");
        if (protocol != null && transport != null && protocol.get(0).equals("true") && transport.get(0).equals("long-polling")) {
            this.handshakeOccured.set(false);
        }
    }

    @Override
    public AsyncHandler.STATE onHeadersReceived(HttpResponseHeaders headers) throws Exception {
        if (this.handshakeOccured.get()) {
            return super.onHeadersReceived(headers);
        }
        return AsyncHandler.STATE.CONTINUE;
    }

    @Override
    public AsyncHandler.STATE onStatusReceived(HttpResponseStatus responseStatus) throws Exception {
        if (this.handshakeOccured.get()) {
            if (this.protocolEnabled && ++this.count == 1) {
                this.status = Socket.STATUS.INIT;
            }
            return super.onStatusReceived(responseStatus);
        }
        return AsyncHandler.STATE.CONTINUE;
    }

    @Override
    public AsyncHandler.STATE onBodyPartReceived(HttpResponseBodyPart bodyPart) throws Exception {
        this.handshakeOccured.set(true);
        if (this.isBinary) {
            byte[] payload = bodyPart.getBodyPartBytes();
            if (this.protocolEnabled && !this.protocolReceived) {
                if (!Utils.whiteSpace(payload)) {
                    TransportsUtil.invokeFunction(this.decoders, this.functions, payload.getClass(), payload, Event.MESSAGE.name(), this.resolver);
                    this.protocolReceived = true;
                }
                return AsyncHandler.STATE.CONTINUE;
            }
            if (!Utils.whiteSpace(payload)) {
                TransportsUtil.invokeFunction(this.decoders, this.functions, payload.getClass(), payload, Event.MESSAGE.name(), this.resolver);
            }
            this.unlockFuture();
        } else {
            String m = new String(bodyPart.getBodyPartBytes(), this.charSet).trim();
            if (this.protocolEnabled && !this.protocolReceived) {
                if (m.length() > 0) {
                    TransportsUtil.invokeFunction(this.decoders, this.functions, m.getClass(), m, Event.MESSAGE.name(), this.resolver);
                    this.protocolReceived = true;
                }
                return AsyncHandler.STATE.CONTINUE;
            }
            if (m.length() > 0) {
                TransportsUtil.invokeFunction(this.decoders, this.functions, m.getClass(), m, Event.MESSAGE.name(), this.resolver);
            }
            this.unlockFuture();
        }
        return AsyncHandler.STATE.CONTINUE;
    }

    @Override
    public Request.TRANSPORT name() {
        return Request.TRANSPORT.LONG_POLLING;
    }

    @Override
    public void close() {
        if (!this.protocolEnabled) {
            super.close();
        }
    }
}

