/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.wasync.transport;

import com.ning.http.client.AsyncHandler;
import com.ning.http.client.HttpResponseBodyPart;
import com.ning.http.client.HttpResponseHeaders;
import com.ning.http.client.HttpResponseStatus;
import com.ning.http.client.RequestBuilder;
import com.ning.http.client.websocket.WebSocket;
import com.ning.http.client.websocket.WebSocketListener;
import com.ning.http.client.websocket.WebSocketTextListener;
import com.ning.http.client.websocket.WebSocketUpgradeHandler;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.atmosphere.wasync.Decoder;
import org.atmosphere.wasync.Function;
import org.atmosphere.wasync.FunctionResolver;
import org.atmosphere.wasync.FunctionWrapper;
import org.atmosphere.wasync.Future;
import org.atmosphere.wasync.Options;
import org.atmosphere.wasync.Request;
import org.atmosphere.wasync.Transport;
import org.atmosphere.wasync.transport.TransportsUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketTransport
extends WebSocketUpgradeHandler
implements Transport {
    private final Logger logger = LoggerFactory.getLogger(WebSocketTransport.class);
    private WebSocket webSocket;
    private final AtomicBoolean ok = new AtomicBoolean(false);
    private Future f;
    private final List<FunctionWrapper> functions;
    private final List<Decoder<?, ?>> decoders;
    private final FunctionResolver resolver;
    private final Options options;
    private final RequestBuilder requestBuilder;

    public WebSocketTransport(RequestBuilder requestBuilder, Options options, Request request, List<FunctionWrapper> functions) {
        super(new WebSocketUpgradeHandler.Builder());
        this.decoders = request.decoders();
        if (this.decoders.size() == 0) {
            this.decoders.add(new Decoder<String, Object>(){

                @Override
                public Object decode(Transport.EVENT_TYPE e, String s) {
                    return s;
                }
            });
        }
        this.functions = functions;
        this.resolver = request.functionResolver();
        this.options = options;
        this.requestBuilder = requestBuilder;
    }

    @Override
    public void onThrowable(Throwable t) {
        TransportsUtil.invokeFunction(this.decoders, this.functions, t.getClass(), t, Function.MESSAGE.error.name(), this.resolver);
    }

    @Override
    public void close() {
    }

    public AsyncHandler.STATE onBodyPartReceived(HttpResponseBodyPart bodyPart) throws Exception {
        return AsyncHandler.STATE.CONTINUE;
    }

    public AsyncHandler.STATE onStatusReceived(HttpResponseStatus responseStatus) throws Exception {
        TransportsUtil.invokeFunction(this.decoders, this.functions, Integer.class, new Integer(responseStatus.getStatusCode()), Function.MESSAGE.status.name(), this.resolver);
        if (responseStatus.getStatusCode() == 101) {
            return AsyncHandler.STATE.UPGRADE;
        }
        return AsyncHandler.STATE.ABORT;
    }

    public AsyncHandler.STATE onHeadersReceived(HttpResponseHeaders headers) throws Exception {
        TransportsUtil.invokeFunction(this.decoders, this.functions, Map.class, headers.getHeaders(), Function.MESSAGE.headers.name(), this.resolver);
        return AsyncHandler.STATE.CONTINUE;
    }

    public WebSocket onCompleted() throws Exception {
        if (this.webSocket == null) {
            throw new IllegalStateException("WebSocket is null");
        }
        return this.webSocket;
    }

    public void onSuccess(WebSocket webSocket) {
        this.webSocket = webSocket;
        this.ok.set(true);
        WebSocketTextListener l = new WebSocketTextListener(){

            public void onMessage(String message) {
                if ((message = message.trim()).length() > 0) {
                    TransportsUtil.invokeFunction(Transport.EVENT_TYPE.MESSAGE, WebSocketTransport.this.decoders, WebSocketTransport.this.functions, message.getClass(), message, Function.MESSAGE.message.name(), WebSocketTransport.this.resolver);
                }
            }

            public void onFragment(String fragment, boolean last) {
            }

            public void onOpen(WebSocket websocket) {
                TransportsUtil.invokeFunction(Transport.EVENT_TYPE.OPEN, WebSocketTransport.this.decoders, WebSocketTransport.this.functions, String.class, Function.MESSAGE.open.name(), Function.MESSAGE.open.name(), WebSocketTransport.this.resolver);
            }

            public void onClose(WebSocket websocket) {
                TransportsUtil.invokeFunction(Transport.EVENT_TYPE.CLOSE, WebSocketTransport.this.decoders, WebSocketTransport.this.functions, String.class, Function.MESSAGE.close.name(), Function.MESSAGE.close.name(), WebSocketTransport.this.resolver);
                if (WebSocketTransport.this.options.reconnect()) {
                    ScheduledExecutorService e = WebSocketTransport.this.options.runtime().getConfig().reaper();
                    e.schedule(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                WebSocketTransport.this.options.runtime().executeRequest(WebSocketTransport.this.requestBuilder.build(), (AsyncHandler)WebSocketTransport.this);
                            }
                            catch (IOException e) {
                                WebSocketTransport.this.logger.error("", (Throwable)e);
                            }
                        }
                    }, (long)WebSocketTransport.this.options.reconnectInSeconds(), TimeUnit.SECONDS);
                }
            }

            public void onError(Throwable t) {
                TransportsUtil.invokeFunction(WebSocketTransport.this.decoders, WebSocketTransport.this.functions, t.getClass(), t, Function.MESSAGE.error.name(), WebSocketTransport.this.resolver);
            }
        };
        webSocket.addWebSocketListener((WebSocketListener)l);
        l.onOpen(webSocket);
    }

    @Override
    public Request.TRANSPORT name() {
        return Request.TRANSPORT.WEBSOCKET;
    }

    @Override
    public Transport future(Future f) {
        this.f = f;
        return this;
    }

    @Override
    public Transport registerF(FunctionWrapper function) {
        this.functions.add(function);
        return this;
    }

    public final void onFailure(Throwable t) {
        TransportsUtil.invokeFunction(this.decoders, this.functions, t.getClass(), t, Function.MESSAGE.error.name(), this.resolver);
    }
}

