/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.wasync.impl;

import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.FluentStringsMap;
import com.ning.http.client.ListenableFuture;
import com.ning.http.client.RequestBuilder;
import com.ning.http.client.websocket.WebSocket;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.atmosphere.wasync.Encoder;
import org.atmosphere.wasync.Function;
import org.atmosphere.wasync.FunctionWrapper;
import org.atmosphere.wasync.Future;
import org.atmosphere.wasync.Options;
import org.atmosphere.wasync.Request;
import org.atmosphere.wasync.Socket;
import org.atmosphere.wasync.Transport;
import org.atmosphere.wasync.impl.DefaultFuture;
import org.atmosphere.wasync.transport.LongPollingTransport;
import org.atmosphere.wasync.transport.SSETransport;
import org.atmosphere.wasync.transport.StreamTransport;
import org.atmosphere.wasync.transport.WebSocketTransport;
import org.atmosphere.wasync.util.ReaderInputStream;
import org.atmosphere.wasync.util.TypeResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSocket
implements Socket {
    private final Logger logger = LoggerFactory.getLogger(DefaultSocket.class);
    private Request request;
    private InternalSocket socket;
    private final List<FunctionWrapper> functions = new ArrayList<FunctionWrapper>();
    private final AsyncHttpClient asyncHttpClient;
    protected Transport transportInUse;
    private final Options options;

    public DefaultSocket(Options options) {
        this.asyncHttpClient = options.runtime();
        this.options = options;
    }

    @Override
    public Future fire(Object data) throws IOException {
        this.socket.write(this.request, data);
        return new DefaultFuture(this);
    }

    @Override
    public Socket on(Function<? extends Object> function) {
        this.functions.add(new FunctionWrapper("", function));
        return this;
    }

    @Override
    public Socket on(String functionName, Function<? extends Object> function) {
        this.functions.add(new FunctionWrapper(functionName, function));
        return this;
    }

    @Override
    public Socket open(Request request) throws IOException {
        return this.open(request, -1L, TimeUnit.MILLISECONDS);
    }

    @Override
    public Socket open(Request request, long timeout, TimeUnit tu) throws IOException {
        this.request = request;
        RequestBuilder r = new RequestBuilder();
        r.setUrl(request.uri()).setMethod(request.method().name()).setHeaders(request.headers()).setQueryParameters(DefaultSocket.decodeQueryString(request));
        List<Transport> transports = this.getTransport(r, request);
        return this.connect(r, transports, timeout, tu);
    }

    static FluentStringsMap decodeQueryString(Request request) {
        Map<String, List<String>> c = request.queryString();
        FluentStringsMap f = new FluentStringsMap();
        f.putAll(c);
        return f;
    }

    protected Socket connect(RequestBuilder r, List<Transport> transports) throws IOException {
        return this.connect(r, transports, -1L, TimeUnit.MILLISECONDS);
    }

    protected Socket connect(RequestBuilder r, List<Transport> transports, long timeout, TimeUnit tu) throws IOException {
        if (transports.size() <= 0) {
            throw new IOException("No suitable transport supported");
        }
        this.transportInUse = transports.get(0);
        this.socket = new InternalSocket(this.asyncHttpClient);
        DefaultFuture f = new DefaultFuture(this);
        this.transportInUse.future(f);
        if (this.transportInUse.name().equals((Object)Request.TRANSPORT.WEBSOCKET)) {
            r.setUrl(this.request.uri().replace("http", "ws"));
            try {
                ListenableFuture fw = this.asyncHttpClient.prepareRequest(r.build()).execute((AsyncHandler)this.transportInUse);
                WebSocket w = (WebSocket)fw.get(timeout, tu);
                this.socket = new InternalSocket(w);
            }
            catch (ExecutionException t) {
                Throwable e = t.getCause();
                if (e != null && e.getMessage() != null && e.getMessage().equalsIgnoreCase("Invalid handshake response")) {
                    this.logger.info("WebSocket not supported, downgrading to an HTTP based transport.");
                    transports.remove(0);
                    return this.connect(r, transports, timeout, tu);
                }
                this.transportInUse.onThrowable(t);
                return new VoidSocket();
            }
            catch (Throwable t) {
                this.transportInUse.onThrowable(t);
                return new VoidSocket();
            }
        }
        r.setUrl(this.request.uri().replace("ws", "http"));
        this.asyncHttpClient.prepareRequest(r.build()).execute((AsyncHandler)this.transportInUse);
        try {
            f.get(this.options.waitBeforeUnlocking(), TimeUnit.MILLISECONDS);
        }
        catch (Throwable t) {
            // empty catch block
        }
        this.socket = new InternalSocket(this.asyncHttpClient);
        return this;
    }

    @Override
    public void close() {
        if (this.socket != null) {
            this.socket.close();
            this.transportInUse.close();
        }
    }

    protected InternalSocket internalSocket() {
        return this.socket;
    }

    protected List<Transport> getTransport(RequestBuilder r, Request request) throws IOException {
        ArrayList<Transport> transports = new ArrayList<Transport>();
        if (request.transport().size() == 0) {
            transports.add(new WebSocketTransport(r, this.options, request, this.functions));
            transports.add(new LongPollingTransport(r, this.options, request, this.functions));
        }
        for (Request.TRANSPORT t : request.transport()) {
            if (t.equals((Object)Request.TRANSPORT.WEBSOCKET)) {
                transports.add(new WebSocketTransport(r, this.options, request, this.functions));
                continue;
            }
            if (t.equals((Object)Request.TRANSPORT.SSE)) {
                transports.add(new SSETransport(r, this.options, request, this.functions));
                continue;
            }
            if (t.equals((Object)Request.TRANSPORT.LONG_POLLING)) {
                transports.add(new LongPollingTransport(r, this.options, request, this.functions));
                continue;
            }
            if (!t.equals((Object)Request.TRANSPORT.STREAMING)) continue;
            transports.add(new StreamTransport(r, this.options, request, this.functions));
        }
        return transports;
    }

    protected Request request() {
        return this.request;
    }

    private static final class VoidSocket
    implements Socket {
        private VoidSocket() {
        }

        @Override
        public Future fire(Object data) throws IOException {
            throw new IllegalStateException("An error occured during connection. Please add a Function(Throwable) to debug.");
        }

        @Override
        public Socket on(Function<? extends Object> function) {
            throw new IllegalStateException("An error occured during connection. Please add a Function(Throwable) to debug.");
        }

        @Override
        public Socket on(String functionMessage, Function<? extends Object> function) {
            throw new IllegalStateException("An error occured during connection. Please add a Function(Throwable) to debug.");
        }

        @Override
        public Socket open(Request request) throws IOException {
            throw new IllegalStateException("An error occured during connection. Please add a Function(Throwable) to debug.");
        }

        @Override
        public void close() {
            throw new IllegalStateException("An error occured during connection. Please add a Function(Throwable) to debug.");
        }

        @Override
        public Socket open(Request request, long timeout, TimeUnit tu) throws IOException {
            throw new IllegalStateException("An error occured during connection. Please add a Function(Throwable) to debug.");
        }
    }

    protected static final class InternalSocket {
        private final WebSocket webSocket;
        private final AsyncHttpClient asyncHttpClient;

        public InternalSocket(WebSocket webSocket) {
            this.webSocket = webSocket;
            this.asyncHttpClient = null;
        }

        public InternalSocket(AsyncHttpClient asyncHttpClient) {
            this.webSocket = null;
            this.asyncHttpClient = asyncHttpClient;
        }

        public void close() {
            if (this.webSocket != null) {
                this.webSocket.close();
            } else {
                this.asyncHttpClient.close();
            }
        }

        Object invokeEncoder(List<Encoder<? extends Object, ?>> encoders, Object instanceType) {
            for (Encoder<Object, ?> e : encoders) {
                Class<?>[] typeArguments = TypeResolver.resolveArguments(e.getClass(), Encoder.class);
                if (typeArguments.length <= 0 || !typeArguments[0].isAssignableFrom(instanceType.getClass())) continue;
                instanceType = e.encode(instanceType);
            }
            return instanceType;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public InternalSocket write(Request request, Object data) throws IOException {
            Object object = this.invokeEncoder(request.encoders(), data);
            if (this.webSocket != null) {
                if (InputStream.class.isAssignableFrom(object.getClass())) {
                    InputStream is = (InputStream)object;
                    ByteArrayOutputStream bs = new ByteArrayOutputStream();
                    byte[] buffer = new byte[8192];
                    int n = 0;
                    while (-1 != (n = is.read(buffer))) {
                        bs.write(buffer, 0, n);
                    }
                    this.webSocket.sendMessage(bs.toByteArray());
                    return this;
                } else if (Reader.class.isAssignableFrom(object.getClass())) {
                    Reader is = (Reader)object;
                    StringWriter bs = new StringWriter();
                    char[] chars = new char[8192];
                    int n = 0;
                    while (-1 != (n = is.read(chars))) {
                        bs.write(chars, 0, n);
                    }
                    this.webSocket.sendTextMessage(bs.getBuffer().toString());
                    return this;
                } else if (String.class.isAssignableFrom(object.getClass())) {
                    this.webSocket.sendTextMessage(object.toString());
                    return this;
                } else {
                    if (!byte[].class.isAssignableFrom(object.getClass())) throw new IllegalStateException("No Encoder for " + data);
                    this.webSocket.sendMessage((byte[])object);
                }
                return this;
            } else {
                AsyncHttpClient.BoundRequestBuilder b = (AsyncHttpClient.BoundRequestBuilder)((AsyncHttpClient.BoundRequestBuilder)this.asyncHttpClient.preparePost(request.uri()).setHeaders(request.headers()).setQueryParameters(DefaultSocket.decodeQueryString(request))).setMethod(Request.METHOD.POST.name());
                if (InputStream.class.isAssignableFrom(object.getClass())) {
                    b.setBody((InputStream)object).execute();
                    return this;
                } else {
                    if (Reader.class.isAssignableFrom(object.getClass())) {
                        b.setBody((InputStream)new ReaderInputStream((Reader)object)).execute();
                        return this;
                    }
                    if (String.class.isAssignableFrom(object.getClass())) {
                        b.setBody((String)object).execute();
                        return this;
                    } else {
                        if (!byte[].class.isAssignableFrom(object.getClass())) throw new IllegalStateException("No Encoder for " + data);
                        b.setBody((byte[])object).execute();
                    }
                }
            }
            return this;
        }
    }
}

