/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.spring.boot;

import java.time.Duration;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereInterceptor;
import org.atmosphere.session.DurableSessionInterceptor;
import org.atmosphere.session.InMemorySessionStore;
import org.atmosphere.session.SessionStore;
import org.atmosphere.spring.boot.AtmosphereAutoConfiguration;
import org.atmosphere.spring.boot.AtmosphereProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;

@AutoConfiguration(after={AtmosphereAutoConfiguration.class})
@ConditionalOnClass(value={SessionStore.class})
@ConditionalOnProperty(prefix="atmosphere.durable-sessions", name={"enabled"}, havingValue="true")
public class DurableSessionAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(DurableSessionAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean
    public SessionStore sessionStore() {
        logger.info("No SessionStore bean found \u2014 using InMemorySessionStore (sessions will not survive restart)");
        return new InMemorySessionStore();
    }

    @Bean
    @ConditionalOnMissingBean
    public DurableSessionInterceptor durableSessionInterceptor(SessionStore store, AtmosphereFramework framework, AtmosphereProperties properties) {
        AtmosphereProperties.DurableSessionsProperties dsProps = properties.getDurableSessions();
        Duration ttl = Duration.ofMinutes(dsProps.getSessionTtlMinutes());
        Duration cleanup = Duration.ofSeconds(dsProps.getCleanupIntervalSeconds());
        DurableSessionInterceptor interceptor = new DurableSessionInterceptor(store, ttl, cleanup);
        framework.interceptor((AtmosphereInterceptor)interceptor);
        logger.info("Durable sessions enabled (ttl={}, cleanup={})", (Object)ttl, (Object)cleanup);
        return interceptor;
    }
}

