/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.spring.boot;

import org.atmosphere.config.managed.AtmosphereHandlerServiceInterceptor;
import org.atmosphere.config.managed.ManagedAtmosphereHandler;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereRequestImpl;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.AtmosphereResponseImpl;
import org.atmosphere.cpr.DefaultAtmosphereResourceFactory;
import org.atmosphere.cpr.DefaultAtmosphereResourceSessionFactory;
import org.atmosphere.cpr.DefaultBroadcaster;
import org.atmosphere.cpr.DefaultBroadcasterFactory;
import org.atmosphere.cpr.DefaultMetaBroadcaster;
import org.atmosphere.inject.AtmosphereConfigInjectable;
import org.atmosphere.inject.AtmosphereFrameworkInjectable;
import org.atmosphere.inject.AtmosphereProducers;
import org.atmosphere.inject.AtmosphereRequestIntrospector;
import org.atmosphere.inject.AtmosphereResourceEventIntrospector;
import org.atmosphere.inject.AtmosphereResourceFactoryInjectable;
import org.atmosphere.inject.AtmosphereResourceIntrospector;
import org.atmosphere.inject.AtmosphereResourceSessionFactoryInjectable;
import org.atmosphere.inject.AtmosphereResponseIntrospector;
import org.atmosphere.inject.BroadcasterFactoryInjectable;
import org.atmosphere.inject.BroadcasterIntrospector;
import org.atmosphere.inject.InjectableObjectFactory;
import org.atmosphere.inject.MetaBroadcasterInjectable;
import org.atmosphere.inject.PathParamIntrospector;
import org.atmosphere.inject.PostConstructIntrospector;
import org.atmosphere.inject.WebSocketFactoryInjectable;
import org.atmosphere.interceptor.AndroidAtmosphereInterceptor;
import org.atmosphere.interceptor.CacheHeadersInterceptor;
import org.atmosphere.interceptor.CorsInterceptor;
import org.atmosphere.interceptor.HeartbeatInterceptor;
import org.atmosphere.interceptor.IdleResourceInterceptor;
import org.atmosphere.interceptor.JavaScriptProtocol;
import org.atmosphere.interceptor.OnDisconnectInterceptor;
import org.atmosphere.interceptor.PaddingAtmosphereInterceptor;
import org.atmosphere.interceptor.SSEAtmosphereInterceptor;
import org.atmosphere.interceptor.SuspendTrackerInterceptor;
import org.atmosphere.interceptor.WebSocketMessageSuspendInterceptor;
import org.atmosphere.pool.BoundedApachePoolableProvider;
import org.atmosphere.pool.UnboundedApachePoolableProvider;
import org.atmosphere.spring.boot.SpringAtmosphereObjectFactory;
import org.atmosphere.websocket.DefaultWebSocketFactory;
import org.atmosphere.websocket.DefaultWebSocketProcessor;
import org.atmosphere.websocket.protocol.SimpleHttpProtocol;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.ReflectionHints;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.aot.hint.TypeReference;

public class AtmosphereRuntimeHints
implements RuntimeHintsRegistrar {
    private static final MemberCategory[] HINT_CATEGORIES = new MemberCategory[]{MemberCategory.INVOKE_DECLARED_CONSTRUCTORS, MemberCategory.INVOKE_DECLARED_METHODS, MemberCategory.ACCESS_DECLARED_FIELDS};
    private static final String ANNOTATION_PKG = "org.atmosphere.annotation.";
    private static final String[] ANNOTATION_PROCESSORS = new String[]{"AsyncSupportListenerServiceProcessor", "AsyncSupportServiceProcessor", "AtmosphereFrameworkServiceProcessor", "AtmosphereHandlerServiceProcessor", "AtmosphereInterceptorServiceProcessor", "AtmosphereResourceFactoryServiceProcessor", "AtmosphereResourceListenerServiceProcessor", "AtmosphereServiceProcessor", "BroadcastFilterServiceProcessor", "BroadcasterCacheInspectorServiceProcessor", "BroadcasterCacheListenererviceProcessor", "BroadcasterCacheServiceProcessor", "BroadcasterFactoryServiceProcessor", "BroadcasterListenerServiceProcessor", "BroadcasterServiceProcessor", "EndpointMapperServiceProcessor", "ManagedServiceProcessor", "UUIDProviderServiceProcessor", "WebSocketFactoryServiceProcessor", "WebSocketHandlerServiceProcessor", "WebSocketProcessorServiceProcessor", "WebSocketProtocolServiceProcessor"};

    public void registerHints(RuntimeHints hints, ClassLoader classLoader) {
        ReflectionHints reflection = hints.reflection();
        this.registerType(reflection, SpringAtmosphereObjectFactory.class);
        this.registerType(reflection, AtmosphereConfigInjectable.class);
        this.registerType(reflection, AtmosphereFrameworkInjectable.class);
        this.registerType(reflection, AtmosphereResourceFactoryInjectable.class);
        this.registerType(reflection, AtmosphereResourceSessionFactoryInjectable.class);
        this.registerType(reflection, BroadcasterFactoryInjectable.class);
        this.registerType(reflection, MetaBroadcasterInjectable.class);
        this.registerType(reflection, WebSocketFactoryInjectable.class);
        this.registerType(reflection, PostConstructIntrospector.class);
        this.registerType(reflection, BroadcasterIntrospector.class);
        this.registerType(reflection, AtmosphereResourceIntrospector.class);
        this.registerType(reflection, AtmosphereRequestIntrospector.class);
        this.registerType(reflection, AtmosphereResponseIntrospector.class);
        this.registerType(reflection, AtmosphereResourceEventIntrospector.class);
        this.registerType(reflection, PathParamIntrospector.class);
        this.registerType(reflection, AtmosphereResourceImpl.class);
        this.registerType(reflection, AtmosphereRequestImpl.class);
        this.registerType(reflection, AtmosphereResponseImpl.class);
        this.registerType(reflection, ManagedAtmosphereHandler.class);
        this.registerType(reflection, AtmosphereHandlerServiceInterceptor.class);
        this.registerTypeByName(reflection, "org.atmosphere.cpr.DefaultAtmosphereObjectFactory");
        this.registerType(reflection, InjectableObjectFactory.class);
        this.registerType(reflection, AtmosphereProducers.class);
        this.registerType(reflection, AtmosphereFramework.class);
        this.registerType(reflection, DefaultBroadcaster.class);
        this.registerType(reflection, DefaultBroadcasterFactory.class);
        this.registerType(reflection, DefaultAtmosphereResourceFactory.class);
        this.registerType(reflection, DefaultMetaBroadcaster.class);
        this.registerType(reflection, DefaultAtmosphereResourceSessionFactory.class);
        this.registerType(reflection, SimpleHttpProtocol.class);
        this.registerTypeByName(reflection, "org.atmosphere.container.JSR356AsyncSupport");
        this.registerTypeByName(reflection, "org.atmosphere.container.Servlet30CometSupport");
        if (classLoader != null) {
            try {
                classLoader.loadClass("org.apache.commons.pool2.PooledObjectFactory");
                this.registerType(reflection, UnboundedApachePoolableProvider.class);
                this.registerType(reflection, BoundedApachePoolableProvider.class);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        this.registerType(reflection, CorsInterceptor.class);
        this.registerType(reflection, CacheHeadersInterceptor.class);
        this.registerType(reflection, PaddingAtmosphereInterceptor.class);
        this.registerType(reflection, AndroidAtmosphereInterceptor.class);
        this.registerType(reflection, HeartbeatInterceptor.class);
        this.registerType(reflection, SSEAtmosphereInterceptor.class);
        this.registerType(reflection, JavaScriptProtocol.class);
        this.registerType(reflection, WebSocketMessageSuspendInterceptor.class);
        this.registerType(reflection, OnDisconnectInterceptor.class);
        this.registerType(reflection, IdleResourceInterceptor.class);
        this.registerType(reflection, SuspendTrackerInterceptor.class);
        this.registerTypeByName(reflection, "org.atmosphere.cpr.DefaultAnnotationProcessor");
        this.registerType(reflection, DefaultWebSocketProcessor.class);
        this.registerType(reflection, DefaultWebSocketFactory.class);
        this.registerTypeByName(reflection, "org.atmosphere.container.JSR356Endpoint");
        for (String processor : ANNOTATION_PROCESSORS) {
            this.registerTypeByName(reflection, ANNOTATION_PKG + processor);
        }
        hints.resources().registerPattern("META-INF/services/org.atmosphere.inject.Injectable");
        hints.resources().registerPattern("META-INF/services/org.atmosphere.inject.CDIProducer");
    }

    private void registerType(ReflectionHints reflection, Class<?> type) {
        reflection.registerType(type, HINT_CATEGORIES);
    }

    private void registerTypeByName(ReflectionHints reflection, String typeName) {
        reflection.registerType(TypeReference.of((String)typeName), HINT_CATEGORIES);
    }
}

