/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.spring.boot;

import org.atmosphere.cpr.AtmosphereFramework;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.availability.AvailabilityChangeEvent;
import org.springframework.boot.availability.AvailabilityState;
import org.springframework.boot.availability.ReadinessState;
import org.springframework.context.ApplicationContext;
import org.springframework.context.SmartLifecycle;

public class AtmosphereLifecycle
implements SmartLifecycle {
    private static final Logger logger = LoggerFactory.getLogger(AtmosphereLifecycle.class);
    private final AtmosphereFramework framework;
    private final ApplicationContext applicationContext;
    private volatile boolean running = true;

    public AtmosphereLifecycle(AtmosphereFramework framework, ApplicationContext applicationContext) {
        this.framework = framework;
        this.applicationContext = applicationContext;
    }

    public void start() {
        this.running = true;
    }

    public void stop() {
        if (this.running && !this.framework.isDestroyed()) {
            logger.info("Graceful shutdown: signaling readiness probe and destroying Atmosphere framework");
            AvailabilityChangeEvent.publish((ApplicationContext)this.applicationContext, (AvailabilityState)ReadinessState.REFUSING_TRAFFIC);
            this.framework.destroy();
            this.running = false;
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public int getPhase() {
        return 0x7FFFFFFE;
    }
}

