/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.spring.boot;

import org.atmosphere.cpr.AsyncSupport;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.BroadcasterFactory;
import org.atmosphere.util.Version;
import org.springframework.boot.health.contributor.Health;
import org.springframework.boot.health.contributor.HealthIndicator;

public class AtmosphereHealthIndicator
implements HealthIndicator {
    private final AtmosphereFramework framework;

    public AtmosphereHealthIndicator(AtmosphereFramework framework) {
        this.framework = framework;
    }

    public Health health() {
        BroadcasterFactory broadcasterFactory;
        if (this.framework.isDestroyed()) {
            return Health.down().withDetail("version", (Object)Version.getRawVersion()).withDetail("reason", (Object)"destroyed").build();
        }
        int handlers = this.framework.getAtmosphereHandlers().size();
        Health.Builder builder = Health.up().withDetail("version", (Object)Version.getRawVersion()).withDetail("handlers", (Object)handlers);
        if (handlers == 0) {
            builder.withDetail("warning", (Object)"no handlers registered");
        }
        if ((broadcasterFactory = this.framework.getBroadcasterFactory()) != null) {
            builder.withDetail("broadcasters", (Object)broadcasterFactory.lookupAll().size());
        }
        builder.withDetail("connections", (Object)this.framework.atmosphereFactory().findAll().size());
        AsyncSupport asyncSupport = this.framework.getAsyncSupport();
        if (asyncSupport != null) {
            builder.withDetail("asyncSupport", (Object)asyncSupport.getClass().getSimpleName());
        }
        return builder.build();
    }
}

