/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.spring.boot;

import jakarta.servlet.Servlet;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.atmosphere.config.AtmosphereAnnotation;
import org.atmosphere.config.service.AsyncSupportListenerService;
import org.atmosphere.config.service.AsyncSupportService;
import org.atmosphere.config.service.AtmosphereFrameworkListenerService;
import org.atmosphere.config.service.AtmosphereHandlerService;
import org.atmosphere.config.service.AtmosphereInterceptorService;
import org.atmosphere.config.service.AtmosphereResourceFactoryService;
import org.atmosphere.config.service.AtmosphereResourceListenerService;
import org.atmosphere.config.service.AtmosphereService;
import org.atmosphere.config.service.BroadcasterCacheInspectorService;
import org.atmosphere.config.service.BroadcasterCacheListenerService;
import org.atmosphere.config.service.BroadcasterCacheService;
import org.atmosphere.config.service.BroadcasterFactoryService;
import org.atmosphere.config.service.BroadcasterFilterService;
import org.atmosphere.config.service.BroadcasterListenerService;
import org.atmosphere.config.service.BroadcasterService;
import org.atmosphere.config.service.EndpointMapperService;
import org.atmosphere.config.service.ManagedService;
import org.atmosphere.config.service.RoomService;
import org.atmosphere.config.service.UUIDProviderService;
import org.atmosphere.config.service.WebSocketFactoryService;
import org.atmosphere.config.service.WebSocketHandlerService;
import org.atmosphere.config.service.WebSocketProcessorService;
import org.atmosphere.config.service.WebSocketProtocolService;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereObjectFactory;
import org.atmosphere.cpr.AtmosphereServlet;
import org.atmosphere.room.RoomManager;
import org.atmosphere.spring.boot.AtmosphereLifecycle;
import org.atmosphere.spring.boot.AtmosphereProperties;
import org.atmosphere.spring.boot.AtmosphereRuntimeHints;
import org.atmosphere.spring.boot.SpringAtmosphereObjectFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.context.annotation.ImportRuntimeHints;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;

@AutoConfiguration
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@ConditionalOnClass(value={AtmosphereServlet.class})
@ConditionalOnProperty(name={"atmosphere.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={AtmosphereProperties.class})
@ImportRuntimeHints(value={AtmosphereRuntimeHints.class})
public class AtmosphereAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(AtmosphereAutoConfiguration.class);
    private static final Class<? extends Annotation>[] ATMOSPHERE_ANNOTATIONS = new Class[]{AtmosphereHandlerService.class, BroadcasterCacheService.class, BroadcasterFilterService.class, BroadcasterFactoryService.class, BroadcasterService.class, WebSocketFactoryService.class, WebSocketHandlerService.class, WebSocketProtocolService.class, AtmosphereInterceptorService.class, BroadcasterListenerService.class, AsyncSupportService.class, AsyncSupportListenerService.class, WebSocketProcessorService.class, BroadcasterCacheInspectorService.class, ManagedService.class, AtmosphereService.class, EndpointMapperService.class, BroadcasterCacheListenerService.class, AtmosphereAnnotation.class, AtmosphereResourceFactoryService.class, AtmosphereFrameworkListenerService.class, AtmosphereResourceListenerService.class, UUIDProviderService.class, RoomService.class};

    @Bean
    @ConditionalOnMissingBean
    public SpringAtmosphereObjectFactory springAtmosphereObjectFactory(ApplicationContext applicationContext) {
        return new SpringAtmosphereObjectFactory(applicationContext);
    }

    @Bean
    @ConditionalOnMissingBean
    public AtmosphereServlet atmosphereServlet(SpringAtmosphereObjectFactory objectFactory, AtmosphereProperties properties) {
        Map<Class<? extends Annotation>, Set<Class<?>>> annotationMap = this.scanAnnotations(properties);
        AnnotationAwareAtmosphereServlet servlet = new AnnotationAwareAtmosphereServlet(annotationMap);
        servlet.framework().objectFactory((AtmosphereObjectFactory)objectFactory);
        return servlet;
    }

    @Bean
    @ConditionalOnMissingBean
    public AtmosphereFramework atmosphereFramework(AtmosphereServlet servlet) {
        return servlet.framework();
    }

    @Bean
    @ConditionalOnMissingBean
    public RoomManager roomManager(AtmosphereFramework framework) {
        return RoomManager.getOrCreate((AtmosphereFramework)framework);
    }

    @Bean
    @ConditionalOnMissingBean
    public AtmosphereLifecycle atmosphereLifecycle(AtmosphereFramework framework, ApplicationContext applicationContext) {
        return new AtmosphereLifecycle(framework, applicationContext);
    }

    /*
     * WARNING - void declaration
     */
    private Map<Class<? extends Annotation>, Set<Class<?>>> scanAnnotations(AtmosphereProperties properties) {
        ClassPathScanningCandidateComponentProvider scanner = new ClassPathScanningCandidateComponentProvider(false);
        for (Class<? extends Annotation> annotation : ATMOSPHERE_ANNOTATIONS) {
            scanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(annotation));
        }
        HashSet classes = new HashSet();
        this.scanPackage(scanner, "org.atmosphere.annotation", classes);
        ArrayList<String> userPackages = new ArrayList<String>();
        if (properties.getPackages() != null) {
            void var7_13;
            String[] stringArray = properties.getPackages().split(",");
            int annotation = stringArray.length;
            boolean bl = false;
            while (var7_13 < annotation) {
                String string = stringArray[var7_13];
                String trimmed = string.trim();
                if (!trimmed.isEmpty()) {
                    userPackages.add(trimmed);
                    this.scanPackage(scanner, trimmed, classes);
                }
                ++var7_13;
            }
        }
        HashSet<Class> customAnnotationTypes = new HashSet<Class>();
        for (Class clazz : classes) {
            AtmosphereAnnotation atmosphereAnnotation = clazz.getAnnotation(AtmosphereAnnotation.class);
            if (atmosphereAnnotation == null) continue;
            Class target = atmosphereAnnotation.value();
            boolean isCore = false;
            for (Class<? extends Annotation> core : ATMOSPHERE_ANNOTATIONS) {
                if (!core.equals(target)) continue;
                isCore = true;
                break;
            }
            if (isCore) continue;
            customAnnotationTypes.add(target);
        }
        if (!customAnnotationTypes.isEmpty()) {
            ClassPathScanningCandidateComponentProvider customScanner = new ClassPathScanningCandidateComponentProvider(false);
            for (Class clazz : customAnnotationTypes) {
                customScanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(clazz));
            }
            for (String string : userPackages) {
                this.scanPackage(customScanner, string, classes);
            }
            logger.debug("Discovered {} custom Atmosphere annotation types: {}", (Object)customAnnotationTypes.size(), customAnnotationTypes);
        }
        if (!classes.isEmpty()) {
            logger.info("Atmosphere Spring Boot scanner found {} annotated classes", (Object)classes.size());
        }
        HashMap classesByAnnotation = new HashMap();
        for (Class clazz : classes) {
            for (Annotation annotation : clazz.getAnnotations()) {
                classesByAnnotation.computeIfAbsent(annotation.annotationType(), k -> new HashSet()).add(clazz);
            }
        }
        return classesByAnnotation;
    }

    private void scanPackage(ClassPathScanningCandidateComponentProvider scanner, String packageName, Set<Class<?>> classes) {
        for (BeanDefinition bd : scanner.findCandidateComponents(packageName)) {
            try {
                classes.add(Class.forName(bd.getBeanClassName()));
            }
            catch (ClassNotFoundException e) {
                logger.warn("Could not load Atmosphere annotated class: {}", (Object)bd.getBeanClassName());
            }
        }
    }

    @Bean
    @ConditionalOnMissingBean(name={"atmosphereServletRegistration"})
    public ServletRegistrationBean<AtmosphereServlet> atmosphereServletRegistration(AtmosphereServlet servlet, AtmosphereProperties properties) {
        ServletRegistrationBean registration = new ServletRegistrationBean((Servlet)servlet, new String[]{properties.getServletPath()});
        registration.setName("atmosphereServlet");
        registration.setLoadOnStartup(properties.getOrder());
        registration.setAsyncSupported(true);
        Map initParams = registration.getInitParameters();
        initParams.put("org.atmosphere.cpr.AtmosphereInitializer.disabled", "true");
        if (properties.getPackages() != null) {
            initParams.put("org.atmosphere.cpr.packages", properties.getPackages());
        }
        initParams.put("org.atmosphere.cpr.sessionSupport", String.valueOf(properties.isSessionSupport()));
        if (properties.getBroadcasterClass() != null) {
            initParams.put("org.atmosphere.cpr.broadcasterClass", properties.getBroadcasterClass());
        }
        if (properties.getBroadcasterCacheClass() != null) {
            initParams.put("org.atmosphere.cpr.broadcasterCacheClass", properties.getBroadcasterCacheClass());
        }
        if (properties.getWebsocketSupport() != null) {
            initParams.put("org.atmosphere.useWebSocket", String.valueOf(properties.getWebsocketSupport()));
        }
        if (properties.getHeartbeatIntervalInSeconds() != null) {
            initParams.put("org.atmosphere.interceptor.HeartbeatInterceptor.heartbeatFrequencyInSeconds", String.valueOf(properties.getHeartbeatIntervalInSeconds()));
        }
        initParams.putAll(properties.getInitParams());
        return registration;
    }

    static class AnnotationAwareAtmosphereServlet
    extends AtmosphereServlet {
        private final Map<Class<? extends Annotation>, Set<Class<?>>> annotationMap;

        AnnotationAwareAtmosphereServlet(Map<Class<? extends Annotation>, Set<Class<?>>> annotationMap) {
            this.annotationMap = annotationMap;
        }

        public void init(ServletConfig sc) throws ServletException {
            sc.getServletContext().setAttribute("org.atmosphere.cpr.ANNOTATION_MAP", this.annotationMap);
            super.init(sc);
        }
    }
}

