/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.spring.boot;

import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.BroadcasterFactory;
import org.atmosphere.util.Version;
import org.springframework.boot.health.contributor.Health;
import org.springframework.boot.health.contributor.HealthIndicator;

public class AtmosphereHealthIndicator
implements HealthIndicator {
    private final AtmosphereFramework framework;

    public AtmosphereHealthIndicator(AtmosphereFramework framework) {
        this.framework = framework;
    }

    public Health health() {
        if (this.framework.isDestroyed()) {
            return Health.down().withDetail("version", (Object)Version.getRawVersion()).build();
        }
        Health.Builder builder = Health.up().withDetail("version", (Object)Version.getRawVersion());
        BroadcasterFactory broadcasterFactory = this.framework.getBroadcasterFactory();
        if (broadcasterFactory != null) {
            builder.withDetail("broadcasters", (Object)broadcasterFactory.lookupAll().size());
        }
        builder.withDetail("connections", (Object)this.framework.atmosphereFactory().findAll().size());
        return builder.build();
    }
}

