/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.util;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.atmosphere.cpr.AtmosphereConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutorsFactory {
    private static final Logger logger = LoggerFactory.getLogger(ExecutorsFactory.class);
    public static final int DEFAULT_ASYNC_THREAD = 200;
    public static final int DEFAULT_MESSAGE_THREAD = -1;
    public static final int DEFAULT_KEEP_ALIVE = 30;
    public static final String ASYNC_WRITE_THREAD_POOL = "asyncWriteService";
    public static final String SCHEDULER_THREAD_POOL = "scheduler";
    public static final String BROADCASTER_THREAD_POOL = "executorService";

    public static ExecutorService getMessageDispatcher(AtmosphereConfig config, String name) {
        boolean shared = config.framework().isShareExecutorServices();
        if (!shared || config.properties().get(BROADCASTER_THREAD_POOL) == null) {
            ExecutorService service;
            boolean useVirtualThreads = config.getInitParameter("org.atmosphere.useVirtualThreads", true);
            if (useVirtualThreads) {
                logger.info("Using Virtual Threads for message dispatching (unlimited scalability)");
                service = Executors.newVirtualThreadPerTaskExecutor();
            } else {
                int threads = config.getInitParameter("org.atmosphere.cpr.broadcaster.maxProcessingThreads", -1);
                if (threads == -1) {
                    logger.info("Using cached thread pool for message dispatching");
                    service = Executors.newCachedThreadPool(new AtmosphereThreadFactory(shared, name + "-DispatchOp-"));
                } else {
                    logger.info("Using fixed thread pool ({} threads) for message dispatching", (Object)threads);
                    service = Executors.newFixedThreadPool(threads, new AtmosphereThreadFactory(shared, name + "-DispatchOp-"));
                }
                ExecutorsFactory.configureThreadPool(service, config);
            }
            if (shared) {
                config.properties().put(BROADCASTER_THREAD_POOL, service);
            }
            return service;
        }
        return (ExecutorService)config.properties().get(BROADCASTER_THREAD_POOL);
    }

    public static ExecutorService getAsyncOperationExecutor(AtmosphereConfig config, String name) {
        boolean shared = config.framework().isShareExecutorServices();
        if (!shared || config.properties().get(ASYNC_WRITE_THREAD_POOL) == null) {
            ExecutorService service;
            boolean useVirtualThreads = config.getInitParameter("org.atmosphere.useVirtualThreads", true);
            if (useVirtualThreads) {
                logger.info("Using Virtual Threads for async I/O (unlimited scalability)");
                service = Executors.newVirtualThreadPerTaskExecutor();
            } else {
                int threads = config.getInitParameter("org.atmosphere.cpr.broadcaster.maxAsyncWriteThreads", 200);
                if (threads == -1) {
                    logger.info("Using cached thread pool for async I/O");
                    service = Executors.newCachedThreadPool(new AtmosphereThreadFactory(shared, name + "-AsyncOp-"));
                } else {
                    logger.info("Using fixed thread pool ({} threads) for async I/O", (Object)threads);
                    service = Executors.newFixedThreadPool(threads, new AtmosphereThreadFactory(shared, name + "-AsyncOp-"));
                }
                ExecutorsFactory.configureThreadPool(service, config);
            }
            if (shared) {
                config.properties().put(ASYNC_WRITE_THREAD_POOL, service);
            }
            return service;
        }
        return (ExecutorService)config.properties().get(ASYNC_WRITE_THREAD_POOL);
    }

    public static ScheduledExecutorService getScheduler(AtmosphereConfig config) {
        boolean shared = config.framework().isShareExecutorServices();
        if (!shared || config.properties().get(SCHEDULER_THREAD_POOL) == null) {
            int threads = config.getInitParameter("org.atmosphere.cpr.maxSchedulerThread", Runtime.getRuntime().availableProcessors());
            logger.info("Creating scheduler with {} threads", (Object)threads);
            ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(threads, new ThreadFactory(){
                private final AtomicInteger count = new AtomicInteger();

                @Override
                public Thread newThread(Runnable runnable) {
                    Thread t = new Thread(runnable, "Atmosphere-Scheduler-" + this.count.getAndIncrement());
                    t.setDaemon(true);
                    return t;
                }
            });
            if (shared) {
                config.properties().put(SCHEDULER_THREAD_POOL, scheduler);
            }
            ExecutorsFactory.configureThreadPool(scheduler, config);
            return scheduler;
        }
        return (ScheduledExecutorService)config.properties().get(SCHEDULER_THREAD_POOL);
    }

    private static void configureThreadPool(ExecutorService service, AtmosphereConfig config) {
        if (service instanceof ThreadPoolExecutor) {
            ThreadPoolExecutor executor = (ThreadPoolExecutor)service;
            int keepAlive = config.getInitParameter("org.atmosphere.cpr.threadPool.maxKeepAliveThreads", 30);
            executor.setKeepAliveTime(keepAlive, TimeUnit.SECONDS);
            executor.allowCoreThreadTimeOut(config.getInitParameter("org.atmosphere.cpr.allowCoreThreadTimeOut", true));
        }
    }

    public static void reset(AtmosphereConfig config) {
        ExecutorsFactory.shutdown(config, ASYNC_WRITE_THREAD_POOL);
        ExecutorsFactory.shutdown(config, SCHEDULER_THREAD_POOL);
        ExecutorsFactory.shutdown(config, BROADCASTER_THREAD_POOL);
    }

    private static void shutdown(AtmosphereConfig config, String poolName) {
        ExecutorService service = (ExecutorService)config.properties().get(poolName);
        if (service != null) {
            service.shutdown();
        }
        config.properties().remove(poolName);
    }

    public static final class AtmosphereThreadFactory
    implements ThreadFactory {
        private final AtomicInteger count = new AtomicInteger();
        private final boolean shared;
        private final String name;

        public AtmosphereThreadFactory(boolean shared, String name) {
            this.shared = shared;
            this.name = name;
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread t = new Thread(runnable, (this.shared ? "Atmosphere-Shared-" : this.name) + this.count.getAndIncrement());
            t.setDaemon(true);
            return t;
        }
    }
}

