/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.util;

import java.io.IOException;
import java.io.Reader;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class ChunkConcatReaderPool {
    private final Map<String, ChunkConcatReader> readersPool = new ConcurrentHashMap<String, ChunkConcatReader>();
    private static final long DEFAULT_TIMEOUT = 300000L;
    private long timeout = 300000L;

    public void addChunk(String key, Reader chunk, boolean continued) throws IllegalArgumentException {
        ChunkConcatReader reader = this.readersPool.get(key);
        if (reader == null) {
            throw new IllegalArgumentException("No reader with key: " + key);
        }
        reader.addChunk(chunk, continued);
    }

    public Reader getReader(String key, boolean create) {
        ChunkConcatReader reader = this.readersPool.get(key);
        if (create && reader == null) {
            reader = new ChunkConcatReader(key);
            this.readersPool.put(key, reader);
        }
        return reader;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    void releaseReader(String key) {
        this.readersPool.remove(key);
    }

    Map<String, ChunkConcatReader> getReadersPool() {
        return this.readersPool;
    }

    class ChunkConcatReader
    extends Reader {
        private final String key;
        private final Deque<Reader> readers = new LinkedList<Reader>();
        private final ReentrantLock readersLock = new ReentrantLock();
        private final Condition readersAvailable = this.readersLock.newCondition();
        private boolean continued;
        private boolean closed;

        public ChunkConcatReader(String key) {
            this.key = key;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(char[] cbuf, int off, int len) throws IOException {
            int count = 0;
            while (!this.closed && count < len) {
                if (this.readers.isEmpty()) {
                    if (!this.continued || count > 0) break;
                    this.readersLock.lock();
                    try {
                        if (!this.readers.isEmpty()) continue;
                        try {
                            this.readersAvailable.await(ChunkConcatReaderPool.this.timeout, TimeUnit.MILLISECONDS);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (!this.readers.isEmpty()) continue;
                        throw new IOException("Read timeout");
                    }
                    finally {
                        this.readersLock.unlock();
                        continue;
                    }
                }
                Reader reader = this.readers.getFirst();
                int c = reader.read(cbuf, off + count, len - count);
                if (c == -1) {
                    this.readersLock.lock();
                    try {
                        this.readers.removeFirst();
                    }
                    finally {
                        this.readersLock.unlock();
                    }
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                    continue;
                }
                count += c;
            }
            return count == 0 ? -1 : count;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            for (Reader r : this.readers) {
                try {
                    r.close();
                }
                catch (IOException iOException) {}
            }
            ChunkConcatReaderPool.this.releaseReader(this.key);
            this.closed = true;
            this.readersLock.lock();
            try {
                this.readersAvailable.signalAll();
            }
            finally {
                this.readersLock.unlock();
            }
        }

        @Override
        public boolean ready() throws IOException {
            if (this.readers.isEmpty()) {
                return false;
            }
            return this.readers.getFirst().ready();
        }

        void addChunk(Reader chunk, boolean continued) {
            this.readersLock.lock();
            try {
                this.readers.addLast(chunk);
                this.readersAvailable.signalAll();
                this.continued = continued;
            }
            finally {
                this.readersLock.unlock();
            }
        }
    }
}

