/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.room;

import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereHandlerWrapper;
import org.atmosphere.cpr.AtmosphereInterceptorAdapter;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereRequestImpl;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.BroadcasterCache;
import org.atmosphere.interceptor.InvokationOrder;
import org.atmosphere.room.DefaultRoom;
import org.atmosphere.room.Room;
import org.atmosphere.room.RoomAction;
import org.atmosphere.room.RoomManager;
import org.atmosphere.room.RoomMember;
import org.atmosphere.room.auth.RoomAuth;
import org.atmosphere.room.auth.RoomAuthorizer;
import org.atmosphere.room.protocol.RoomProtocolCodec;
import org.atmosphere.room.protocol.RoomProtocolMessage;
import org.atmosphere.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoomProtocolInterceptor
extends AtmosphereInterceptorAdapter {
    private static final Logger logger = LoggerFactory.getLogger(RoomProtocolInterceptor.class);
    private RoomManager roomManager;
    private RoomAuthorizer authorizer;

    @Override
    public void configure(AtmosphereConfig config) {
        this.roomManager = RoomManager.getOrCreate(config.framework());
        this.scanAuthorizer(config);
        logger.info("RoomProtocolInterceptor configured");
    }

    @Override
    public Action inspect(AtmosphereResource r) {
        RoomProtocolMessage message;
        AtmosphereRequest request = r.getRequest();
        String body = this.readBody(r, request);
        if (body == null || body.isBlank()) {
            return Action.CONTINUE;
        }
        String trimmed = body.trim();
        if (!trimmed.startsWith("{")) {
            return Action.CONTINUE;
        }
        try {
            message = RoomProtocolCodec.decode(trimmed);
        }
        catch (Exception e) {
            logger.debug("Not a room protocol message: {}", (Object)e.getMessage());
            return Action.CONTINUE;
        }
        RoomProtocolMessage roomProtocolMessage = message;
        Objects.requireNonNull(roomProtocolMessage);
        RoomProtocolMessage roomProtocolMessage2 = roomProtocolMessage;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{RoomProtocolMessage.Join.class, RoomProtocolMessage.Leave.class, RoomProtocolMessage.Broadcast.class, RoomProtocolMessage.Direct.class}, (Object)roomProtocolMessage2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                RoomProtocolMessage.Join join = (RoomProtocolMessage.Join)roomProtocolMessage2;
                this.handleJoin(r, join);
                break;
            }
            case 1: {
                RoomProtocolMessage.Leave leave = (RoomProtocolMessage.Leave)roomProtocolMessage2;
                this.handleLeave(r, leave);
                break;
            }
            case 2: {
                RoomProtocolMessage.Broadcast broadcast = (RoomProtocolMessage.Broadcast)roomProtocolMessage2;
                this.handleBroadcast(r, broadcast);
                break;
            }
            case 3: {
                RoomProtocolMessage.Direct direct = (RoomProtocolMessage.Direct)roomProtocolMessage2;
                this.handleDirect(r, direct);
            }
        }
        return Action.CANCELLED;
    }

    @Override
    public InvokationOrder.PRIORITY priority() {
        return InvokationOrder.BEFORE_DEFAULT;
    }

    private void handleJoin(AtmosphereResource r, RoomProtocolMessage.Join join) {
        RoomMember member;
        Room room = this.roomManager.room(join.room());
        if (!this.authorize(r, join.room(), RoomAction.JOIN)) {
            this.sendError(r, join.room(), "Unauthorized");
            return;
        }
        RoomMember roomMember = member = join.memberId() != null ? new RoomMember(join.memberId(), join.metadata()) : null;
        if (member != null) {
            room.join(r, member);
        } else {
            room.join(r);
        }
        ArrayList<RoomMember> members = new ArrayList<RoomMember>(room.memberInfo().values());
        String ack = RoomProtocolCodec.encodeJoinAck(join.room(), members);
        this.sendToResource(r, ack);
        String presence = RoomProtocolCodec.encodePresence(join.room(), "join", member);
        room.broadcast(presence, r);
        this.replayCachedMessages(r, room);
        logger.debug("Handled JOIN for {} in room '{}'", (Object)r.uuid(), (Object)join.room());
    }

    private void handleLeave(AtmosphereResource r, RoomProtocolMessage.Leave leave) {
        Room room = this.roomManager.room(leave.room());
        RoomMember member = room.memberOf(r).orElse(null);
        room.leave(r);
        String presence = RoomProtocolCodec.encodePresence(leave.room(), "leave", member);
        room.broadcast(presence);
        logger.debug("Handled LEAVE for {} in room '{}'", (Object)r.uuid(), (Object)leave.room());
    }

    private void handleBroadcast(AtmosphereResource r, RoomProtocolMessage.Broadcast broadcast) {
        Room room = this.roomManager.room(broadcast.room());
        if (!this.authorize(r, broadcast.room(), RoomAction.BROADCAST)) {
            this.sendError(r, broadcast.room(), "Unauthorized");
            return;
        }
        String fromId = room.memberOf(r).map(RoomMember::id).orElse(null);
        String encoded = RoomProtocolCodec.encodeMessage(broadcast.room(), fromId, broadcast.data());
        room.broadcast(encoded, r);
        logger.debug("Handled BROADCAST from {} in room '{}'", (Object)r.uuid(), (Object)broadcast.room());
    }

    private void handleDirect(AtmosphereResource r, RoomProtocolMessage.Direct direct) {
        Room room = this.roomManager.room(direct.room());
        if (!this.authorize(r, direct.room(), RoomAction.SEND_TO)) {
            this.sendError(r, direct.room(), "Unauthorized");
            return;
        }
        Optional<String> targetUuid = this.resolveTargetUuid(room, direct.targetId());
        if (targetUuid.isEmpty()) {
            this.sendError(r, direct.room(), "Member not found: " + direct.targetId());
            return;
        }
        String fromId = room.memberOf(r).map(RoomMember::id).orElse(null);
        String encoded = RoomProtocolCodec.encodeMessage(direct.room(), fromId, direct.data());
        room.sendTo(encoded, targetUuid.get());
        logger.debug("Handled DIRECT from {} to {} in room '{}'", new Object[]{r.uuid(), direct.targetId(), direct.room()});
    }

    private boolean authorize(AtmosphereResource r, String roomName, RoomAction action) {
        if (this.authorizer == null) {
            return true;
        }
        try {
            return this.authorizer.authorize(r, roomName, action);
        }
        catch (Exception e) {
            logger.warn("Authorization error for {} in room '{}': {}", new Object[]{r.uuid(), roomName, e.getMessage()});
            return false;
        }
    }

    private Optional<String> resolveTargetUuid(Room room, String memberId) {
        for (Map.Entry<String, RoomMember> entry : room.memberInfo().entrySet()) {
            if (!entry.getValue().id().equals(memberId)) continue;
            return Optional.of(entry.getKey());
        }
        return Optional.empty();
    }

    private void replayCachedMessages(AtmosphereResource r, Room room) {
        DefaultRoom defaultRoom;
        if (!(room instanceof DefaultRoom) || (defaultRoom = (DefaultRoom)room).historySize() <= 0) {
            return;
        }
        BroadcasterCache cache = defaultRoom.broadcaster().getBroadcasterConfig().getBroadcasterCache();
        if (cache == null) {
            return;
        }
        List<Object> cached = cache.retrieveFromCache(defaultRoom.broadcaster().getID(), r.uuid());
        if (cached != null) {
            for (Object msg : cached) {
                this.sendToResource(r, msg.toString());
            }
        }
    }

    private void sendToResource(AtmosphereResource r, String message) {
        try {
            r.getResponse().write(message);
            r.getResponse().flushBuffer();
        }
        catch (IOException e) {
            logger.warn("Failed to send message to {}: {}", (Object)r.uuid(), (Object)e.getMessage());
        }
    }

    private void sendError(AtmosphereResource r, String room, String message) {
        this.sendToResource(r, RoomProtocolCodec.encodeError(room, message));
    }

    private String readBody(AtmosphereResource r, AtmosphereRequest request) {
        AtmosphereRequestImpl.Body body = request.body();
        if (body != null && body.hasString()) {
            return body.asString();
        }
        try {
            StringBuilder sb = IOUtils.readEntirelyAsString(r);
            return sb.length() > 0 ? sb.toString() : null;
        }
        catch (IOException e) {
            logger.debug("Failed to read request body: {}", (Object)e.getMessage());
            return null;
        }
    }

    private void scanAuthorizer(AtmosphereConfig config) {
        for (Map.Entry<String, AtmosphereHandlerWrapper> entry : config.handlers().entrySet()) {
            Class<?> handlerClass = entry.getValue().atmosphereHandler().getClass();
            RoomAuth auth = handlerClass.getAnnotation(RoomAuth.class);
            if (auth == null) continue;
            try {
                this.authorizer = config.framework().newClassInstance(RoomAuthorizer.class, auth.authorizer());
                logger.info("Using RoomAuthorizer: {}", (Object)auth.authorizer().getName());
            }
            catch (Exception e) {
                logger.error("Failed to instantiate RoomAuthorizer: {}", (Object)auth.authorizer().getName(), (Object)e);
            }
            break;
        }
    }

    @Override
    public String toString() {
        return "RoomProtocolInterceptor";
    }
}

