/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.room;

import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.AtmosphereInterceptorAdapter;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.room.Room;
import org.atmosphere.room.RoomManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoomInterceptor
extends AtmosphereInterceptorAdapter {
    private static final Logger logger = LoggerFactory.getLogger(RoomInterceptor.class);
    private static final String DEFAULT_BASE_PATH = "/room/";
    private final RoomManager roomManager;
    private final String basePath;

    public RoomInterceptor(RoomManager roomManager) {
        this(roomManager, DEFAULT_BASE_PATH);
    }

    public RoomInterceptor(RoomManager roomManager, String basePath) {
        this.roomManager = roomManager;
        this.basePath = basePath.endsWith("/") ? basePath : basePath + "/";
    }

    @Override
    public Action inspect(AtmosphereResource r) {
        super.inspect(r);
        String pathInfo = r.getRequest().getPathInfo();
        if (pathInfo == null) {
            pathInfo = r.getRequest().getRequestURI();
        }
        if (pathInfo != null && pathInfo.startsWith(this.basePath)) {
            String roomName = pathInfo.substring(this.basePath.length());
            if (roomName.endsWith("/")) {
                roomName = roomName.substring(0, roomName.length() - 1);
            }
            if (!roomName.isEmpty() && !roomName.contains("/")) {
                Room room = this.roomManager.room(roomName);
                room.join(r);
                logger.debug("Auto-joined {} to room '{}' via path {}", new Object[]{r.uuid(), roomName, pathInfo});
            }
        }
        return Action.CONTINUE;
    }

    @Override
    public String toString() {
        return "RoomInterceptor{basePath='" + this.basePath + "'}";
    }
}

