/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.room;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import org.atmosphere.cache.UUIDBroadcasterCache;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.atmosphere.cpr.AtmosphereResourceEventListenerAdapter;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.BroadcasterListenerAdapter;
import org.atmosphere.room.PresenceEvent;
import org.atmosphere.room.Room;
import org.atmosphere.room.RoomMember;
import org.atmosphere.room.VirtualRoomMember;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRoom
implements Room {
    private static final Logger logger = LoggerFactory.getLogger(DefaultRoom.class);
    private final String name;
    private final Broadcaster broadcaster;
    private final List<Consumer<PresenceEvent>> presenceListeners = new CopyOnWriteArrayList<Consumer<PresenceEvent>>();
    private final ConcurrentHashMap<String, RoomMember> memberRegistry = new ConcurrentHashMap();
    private final Set<VirtualRoomMember> virtualMembers = ConcurrentHashMap.newKeySet();
    private volatile boolean destroyed;
    private volatile int historySize;

    public DefaultRoom(String name, Broadcaster broadcaster) {
        this.name = name;
        this.broadcaster = broadcaster;
        broadcaster.addBroadcasterListener(new BroadcasterListenerAdapter(){

            @Override
            public void onRemoveAtmosphereResource(Broadcaster b, AtmosphereResource r) {
                DefaultRoom.this.firePresence(PresenceEvent.Type.LEAVE, r);
            }
        });
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Room join(AtmosphereResource resource) {
        return this.join(resource, null);
    }

    @Override
    public Room join(AtmosphereResource resource, RoomMember member) {
        if (this.destroyed) {
            throw new IllegalStateException("Room '" + this.name + "' is destroyed");
        }
        this.broadcaster.addAtmosphereResource(resource);
        if (member != null) {
            this.memberRegistry.put(resource.uuid(), member);
        }
        resource.addEventListener(new AtmosphereResourceEventListenerAdapter(){

            @Override
            public void onDisconnect(AtmosphereResourceEvent event) {
                DefaultRoom.this.leave(event.getResource());
            }

            @Override
            public void onClose(AtmosphereResourceEvent event) {
                DefaultRoom.this.leave(event.getResource());
            }
        });
        this.firePresence(PresenceEvent.Type.JOIN, resource);
        logger.debug("Resource {} joined room '{}'", (Object)resource.uuid(), (Object)this.name);
        return this;
    }

    @Override
    public Room leave(AtmosphereResource resource) {
        this.memberRegistry.remove(resource.uuid());
        this.broadcaster.removeAtmosphereResource(resource);
        logger.debug("Resource {} left room '{}'", (Object)resource.uuid(), (Object)this.name);
        return this;
    }

    @Override
    public Future<Object> broadcast(Object message) {
        this.dispatchToVirtualMembers(message, null);
        return this.broadcaster.broadcast(message);
    }

    @Override
    public Future<Object> broadcast(Object message, AtmosphereResource sender) {
        this.dispatchToVirtualMembers(message, sender.uuid());
        HashSet<AtmosphereResource> targets = new HashSet<AtmosphereResource>(this.broadcaster.getAtmosphereResources());
        targets.remove(sender);
        if (targets.isEmpty()) {
            return CompletableFuture.completedFuture(message);
        }
        return this.broadcaster.broadcast(message, targets);
    }

    @Override
    public Future<Object> sendTo(Object message, String uuid) {
        for (AtmosphereResource r : this.broadcaster.getAtmosphereResources()) {
            if (!r.uuid().equals(uuid)) continue;
            return this.broadcaster.broadcast(message, r);
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public Set<AtmosphereResource> members() {
        return Collections.unmodifiableSet(new LinkedHashSet<AtmosphereResource>(this.broadcaster.getAtmosphereResources()));
    }

    @Override
    public int size() {
        return this.broadcaster.getAtmosphereResources().size();
    }

    @Override
    public boolean isEmpty() {
        return this.broadcaster.getAtmosphereResources().isEmpty();
    }

    @Override
    public boolean contains(AtmosphereResource resource) {
        return this.broadcaster.getAtmosphereResources().contains(resource);
    }

    @Override
    public Room onPresence(Consumer<PresenceEvent> listener) {
        this.presenceListeners.add(listener);
        return this;
    }

    @Override
    public Map<String, RoomMember> memberInfo() {
        return Collections.unmodifiableMap(this.memberRegistry);
    }

    @Override
    public Optional<RoomMember> memberOf(AtmosphereResource resource) {
        return Optional.ofNullable(this.memberRegistry.get(resource.uuid()));
    }

    @Override
    public Room enableHistory(int maxMessages) {
        this.historySize = maxMessages;
        UUIDBroadcasterCache cache = new UUIDBroadcasterCache();
        cache.setMaxPerClient(maxMessages);
        this.broadcaster.getBroadcasterConfig().setBroadcasterCache(cache);
        logger.debug("Enabled history ({} max) for room '{}'", (Object)maxMessages, (Object)this.name);
        return this;
    }

    public int historySize() {
        return this.historySize;
    }

    @Override
    public Room joinVirtual(VirtualRoomMember member) {
        if (this.destroyed) {
            throw new IllegalStateException("Room '" + this.name + "' is destroyed");
        }
        this.virtualMembers.add(member);
        this.fireVirtualPresence(PresenceEvent.Type.JOIN, member);
        logger.debug("Virtual member '{}' joined room '{}'", (Object)member.id(), (Object)this.name);
        return this;
    }

    @Override
    public Room leaveVirtual(VirtualRoomMember member) {
        this.virtualMembers.remove(member);
        this.fireVirtualPresence(PresenceEvent.Type.LEAVE, member);
        logger.debug("Virtual member '{}' left room '{}'", (Object)member.id(), (Object)this.name);
        return this;
    }

    @Override
    public Set<VirtualRoomMember> virtualMembers() {
        return Collections.unmodifiableSet(this.virtualMembers);
    }

    @Override
    public void destroy() {
        this.destroyed = true;
        this.virtualMembers.clear();
        this.memberRegistry.clear();
        this.broadcaster.destroy();
        this.presenceListeners.clear();
        logger.info("Room '{}' destroyed", (Object)this.name);
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }

    public Broadcaster broadcaster() {
        return this.broadcaster;
    }

    private void firePresence(PresenceEvent.Type type, AtmosphereResource resource) {
        RoomMember member = this.memberRegistry.get(resource.uuid());
        PresenceEvent event = new PresenceEvent(type, this, resource, member);
        for (Consumer<PresenceEvent> listener : this.presenceListeners) {
            try {
                listener.accept(event);
            }
            catch (Exception e) {
                logger.warn("Presence listener error in room '{}'", (Object)this.name, (Object)e);
            }
        }
    }

    private void fireVirtualPresence(PresenceEvent.Type type, VirtualRoomMember member) {
        RoomMember roomMember = new RoomMember(member.id(), member.metadata());
        PresenceEvent event = new PresenceEvent(type, (Room)this, roomMember);
        for (Consumer<PresenceEvent> listener : this.presenceListeners) {
            try {
                listener.accept(event);
            }
            catch (Exception e) {
                logger.warn("Presence listener error in room '{}'", (Object)this.name, (Object)e);
            }
        }
    }

    private void dispatchToVirtualMembers(Object message, String excludeId) {
        for (VirtualRoomMember vm : this.virtualMembers) {
            if (vm.id().equals(excludeId)) continue;
            try {
                vm.onMessage(this, excludeId != null ? excludeId : "room", message);
            }
            catch (Exception e) {
                logger.warn("Virtual member '{}' error in room '{}'", new Object[]{vm.id(), this.name, e});
            }
        }
    }
}

