/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.metrics;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.atmosphere.cache.UUIDBroadcasterCache;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereFrameworkListener;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.atmosphere.cpr.AtmosphereResourceEventListenerAdapter;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.BroadcasterListenerAdapter;
import org.atmosphere.cpr.Deliver;
import org.atmosphere.interceptor.BackpressureInterceptor;
import org.atmosphere.room.Room;
import org.atmosphere.room.RoomManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AtmosphereMetrics {
    private static final Logger logger = LoggerFactory.getLogger(AtmosphereMetrics.class);
    private final MeterRegistry registry;
    private final AtomicInteger activeConnections = new AtomicInteger();
    private final AtomicInteger activeBroadcasters = new AtomicInteger();
    private final Counter totalConnections;
    private final Counter disconnects;
    private final Counter messagesBroadcast;
    private final Counter messagesDelivered;
    private final Timer broadcastTimer;

    private AtmosphereMetrics(MeterRegistry registry) {
        this.registry = registry;
        Gauge.builder((String)"atmosphere.connections.active", (Object)this.activeConnections, AtomicInteger::get).description("Active Atmosphere connections").register(registry);
        Gauge.builder((String)"atmosphere.broadcasters.active", (Object)this.activeBroadcasters, AtomicInteger::get).description("Active Atmosphere broadcasters").register(registry);
        this.totalConnections = Counter.builder((String)"atmosphere.connections.total").description("Total connections opened").register(registry);
        this.disconnects = Counter.builder((String)"atmosphere.connections.disconnects").description("Total disconnects").register(registry);
        this.messagesBroadcast = Counter.builder((String)"atmosphere.messages.broadcast").description("Total messages broadcast").register(registry);
        this.messagesDelivered = Counter.builder((String)"atmosphere.messages.delivered").description("Total messages delivered to resources").register(registry);
        this.broadcastTimer = Timer.builder((String)"atmosphere.broadcast.timer").description("Broadcast completion latency").register(registry);
    }

    public static AtmosphereMetrics install(AtmosphereFramework framework, MeterRegistry registry) {
        AtmosphereMetrics metrics = new AtmosphereMetrics(registry);
        framework.addBroadcasterListener(metrics.new MetricsBroadcasterListener());
        framework.frameworkListener(metrics.new MetricsFrameworkListener());
        logger.info("Atmosphere metrics installed on {}", (Object)registry.getClass().getSimpleName());
        return metrics;
    }

    public void instrumentRoom(Room room) {
        String roomName = room.name();
        Tags roomTags = Tags.of((String)"room", (String)roomName);
        Gauge.builder((String)"atmosphere.rooms.members", (Object)room, Room::size).tags((Iterable)roomTags).description("Current members in room").register(this.registry);
        Counter.builder((String)"atmosphere.rooms.messages").tags((Iterable)roomTags).description("Messages broadcast in room").register(this.registry);
        room.onPresence(event -> {});
        logger.debug("Room metrics installed for '{}'", (Object)roomName);
    }

    public void instrumentRoomManager(RoomManager roomManager) {
        Gauge.builder((String)"atmosphere.rooms.active", (Object)roomManager, RoomManager::count).description("Active Atmosphere rooms").register(this.registry);
        logger.info("Room manager metrics installed");
    }

    public void instrumentCache(UUIDBroadcasterCache cache) {
        Gauge.builder((String)"atmosphere.cache.size", (Object)cache, UUIDBroadcasterCache::totalSize).description("Total cached messages").register(this.registry);
        FunctionCounter.builder((String)"atmosphere.cache.evictions", (Object)cache, c -> c.evictionCount()).description("Total cache evictions").register(this.registry);
        FunctionCounter.builder((String)"atmosphere.cache.hits", (Object)cache, c -> c.hitCount()).description("Cache retrieval hits").register(this.registry);
        FunctionCounter.builder((String)"atmosphere.cache.misses", (Object)cache, c -> c.missCount()).description("Cache retrieval misses").register(this.registry);
        logger.info("Cache metrics installed for {}", (Object)cache);
    }

    public void instrumentBackpressure(BackpressureInterceptor interceptor) {
        FunctionCounter.builder((String)"atmosphere.backpressure.drops", (Object)interceptor, i -> i.totalDrops()).description("Total messages dropped by backpressure").register(this.registry);
        FunctionCounter.builder((String)"atmosphere.backpressure.disconnects", (Object)interceptor, i -> i.totalDisconnects()).description("Total clients disconnected by backpressure").register(this.registry);
        logger.info("Backpressure metrics installed (policy={})", (Object)interceptor.policy());
    }

    private class MetricsBroadcasterListener
    extends BroadcasterListenerAdapter {
        private final Map<Broadcaster, Long> broadcastStartTimes = new ConcurrentHashMap<Broadcaster, Long>();

        private MetricsBroadcasterListener() {
        }

        @Override
        public void onPostCreate(Broadcaster b) {
            AtmosphereMetrics.this.activeBroadcasters.incrementAndGet();
        }

        @Override
        public void onPreDestroy(Broadcaster b) {
            AtmosphereMetrics.this.activeBroadcasters.decrementAndGet();
            this.broadcastStartTimes.remove(b);
        }

        @Override
        public void onAddAtmosphereResource(Broadcaster b, AtmosphereResource r) {
            AtmosphereMetrics.this.activeConnections.incrementAndGet();
            AtmosphereMetrics.this.totalConnections.increment();
            r.addEventListener(new MetricsResourceEventListener());
        }

        @Override
        public void onRemoveAtmosphereResource(Broadcaster b, AtmosphereResource r) {
            AtmosphereMetrics.this.activeConnections.decrementAndGet();
        }

        @Override
        public void onMessage(Broadcaster b, Deliver deliver) {
            AtmosphereMetrics.this.messagesBroadcast.increment();
            this.broadcastStartTimes.put(b, System.nanoTime());
        }

        @Override
        public void onComplete(Broadcaster b) {
            Long startNanos = this.broadcastStartTimes.remove(b);
            if (startNanos != null) {
                AtmosphereMetrics.this.broadcastTimer.record(Duration.ofNanos(System.nanoTime() - startNanos));
            }
        }
    }

    private class MetricsFrameworkListener
    implements AtmosphereFrameworkListener {
        private MetricsFrameworkListener() {
        }

        @Override
        public void onPreInit(AtmosphereFramework f) {
        }

        @Override
        public void onPostInit(AtmosphereFramework f) {
            logger.info("Atmosphere metrics active \u2014 {} handlers registered", (Object)f.getAtmosphereHandlers().size());
        }

        @Override
        public void onPreDestroy(AtmosphereFramework f) {
        }

        @Override
        public void onPostDestroy(AtmosphereFramework f) {
            logger.info("Atmosphere metrics shutdown \u2014 final counts: connections={}, messages={}", (Object)((long)AtmosphereMetrics.this.totalConnections.count()), (Object)((long)AtmosphereMetrics.this.messagesBroadcast.count()));
        }
    }

    private class MetricsResourceEventListener
    extends AtmosphereResourceEventListenerAdapter {
        private MetricsResourceEventListener() {
        }

        @Override
        public void onBroadcast(AtmosphereResourceEvent event) {
            AtmosphereMetrics.this.messagesDelivered.increment();
        }

        @Override
        public void onDisconnect(AtmosphereResourceEvent event) {
            AtmosphereMetrics.this.disconnects.increment();
        }
    }
}

