/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.metrics;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.BroadcasterFactory;
import org.atmosphere.util.Version;

public class AtmosphereHealth {
    private final AtmosphereFramework framework;

    public AtmosphereHealth(AtmosphereFramework framework) {
        this.framework = framework;
    }

    public Map<String, Object> check() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        boolean isUp = !this.framework.isDestroyed();
        result.put("status", isUp ? "UP" : "DOWN");
        result.put("version", Version.getRawVersion());
        if (isUp) {
            BroadcasterFactory factory = this.framework.getBroadcasterFactory();
            int connections = 0;
            int broadcasterCount = 0;
            if (factory != null) {
                Collection<Broadcaster> broadcasters = factory.lookupAll();
                broadcasterCount = broadcasters.size();
                for (Broadcaster b : broadcasters) {
                    connections += b.getAtmosphereResources().size();
                }
            }
            result.put("connections", connections);
            result.put("broadcasters", broadcasterCount);
            result.put("handlers", this.framework.getAtmosphereHandlers().size());
            result.put("interceptors", this.framework.interceptors().size());
        }
        return result;
    }

    public boolean isHealthy() {
        return !this.framework.isDestroyed();
    }
}

