/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.interceptor;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereInterceptorAdapter;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.atmosphere.cpr.AtmosphereResourceEventListenerAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackpressureInterceptor
extends AtmosphereInterceptorAdapter {
    private static final Logger logger = LoggerFactory.getLogger(BackpressureInterceptor.class);
    private static final String HIGH_WATER_MARK_PARAM = "org.atmosphere.backpressure.highWaterMark";
    private static final String POLICY_PARAM = "org.atmosphere.backpressure.policy";
    private int highWaterMark = 1000;
    private Policy policy = Policy.DROP_OLDEST;
    private final Map<String, AtomicInteger> pendingCounts = new ConcurrentHashMap<String, AtomicInteger>();
    private final Set<String> registeredListeners = ConcurrentHashMap.newKeySet();
    private final AtomicLong totalDrops = new AtomicLong();
    private final AtomicLong totalDisconnects = new AtomicLong();

    @Override
    public void configure(AtmosphereConfig config) {
        this.highWaterMark = Integer.parseInt(config.getInitParameter(HIGH_WATER_MARK_PARAM, "1000"));
        String policyStr = config.getInitParameter(POLICY_PARAM, "drop-oldest");
        this.policy = switch (policyStr.toLowerCase()) {
            case "drop-newest" -> Policy.DROP_NEWEST;
            case "disconnect" -> Policy.DISCONNECT;
            default -> Policy.DROP_OLDEST;
        };
        logger.info("Backpressure interceptor configured: highWaterMark={}, policy={}", (Object)this.highWaterMark, (Object)this.policy);
    }

    @Override
    public Action inspect(AtmosphereResource r) {
        super.inspect(r);
        final String uuid = r.uuid();
        this.pendingCounts.computeIfAbsent(uuid, k -> new AtomicInteger(0));
        if (this.registeredListeners.add(uuid)) {
            r.addEventListener(new AtmosphereResourceEventListenerAdapter(){

                @Override
                public void onBroadcast(AtmosphereResourceEvent event) {
                    AtomicInteger count = BackpressureInterceptor.this.pendingCounts.get(uuid);
                    if (count != null && count.get() > 0) {
                        count.decrementAndGet();
                    }
                }

                @Override
                public void onDisconnect(AtmosphereResourceEvent event) {
                    BackpressureInterceptor.this.pendingCounts.remove(uuid);
                    BackpressureInterceptor.this.registeredListeners.remove(uuid);
                }

                @Override
                public void onClose(AtmosphereResourceEvent event) {
                    BackpressureInterceptor.this.pendingCounts.remove(uuid);
                    BackpressureInterceptor.this.registeredListeners.remove(uuid);
                }
            });
        }
        return Action.CONTINUE;
    }

    public boolean allowMessage(String uuid) {
        AtomicInteger count = this.pendingCounts.computeIfAbsent(uuid, k -> new AtomicInteger(0));
        int pending = count.incrementAndGet();
        if (pending <= this.highWaterMark) {
            return true;
        }
        return switch (this.policy.ordinal()) {
            default -> throw new MatchException(null, null);
            case 1 -> {
                count.decrementAndGet();
                this.totalDrops.incrementAndGet();
                logger.debug("Backpressure DROP_NEWEST for client {} (pending={})", (Object)uuid, (Object)pending);
                yield false;
            }
            case 0 -> {
                this.totalDrops.incrementAndGet();
                logger.debug("Backpressure DROP_OLDEST for client {} (pending={})", (Object)uuid, (Object)pending);
                yield true;
            }
            case 2 -> {
                this.totalDisconnects.incrementAndGet();
                logger.warn("Backpressure DISCONNECT for slow client {} (pending={})", (Object)uuid, (Object)pending);
                yield false;
            }
        };
    }

    public int pendingCount(String uuid) {
        AtomicInteger count = this.pendingCounts.get(uuid);
        return count != null ? count.get() : 0;
    }

    public long totalDrops() {
        return this.totalDrops.get();
    }

    public long totalDisconnects() {
        return this.totalDisconnects.get();
    }

    public int highWaterMark() {
        return this.highWaterMark;
    }

    public Policy policy() {
        return this.policy;
    }

    @Override
    public String toString() {
        return "BackpressureInterceptor{highWaterMark=" + this.highWaterMark + ", policy=" + String.valueOf((Object)this.policy) + "}";
    }

    public static enum Policy {
        DROP_OLDEST,
        DROP_NEWEST,
        DISCONNECT;

    }
}

