/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.interceptor;

import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.AsyncIOInterceptorAdapter;
import org.atmosphere.cpr.AsyncIOWriter;
import org.atmosphere.cpr.AtmosphereInterceptorAdapter;
import org.atmosphere.cpr.AtmosphereInterceptorWriter;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.AtmosphereResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AndroidAtmosphereInterceptor
extends AtmosphereInterceptorAdapter {
    private static final Logger logger = LoggerFactory.getLogger(AndroidAtmosphereInterceptor.class);
    private static final byte[] padding;
    private static final String paddingText;

    @Override
    public Action inspect(AtmosphereResource r) {
        if (!r.transport().equals((Object)AtmosphereResource.TRANSPORT.STREAMING)) {
            return Action.CONTINUE;
        }
        AtmosphereResponse response = ((AtmosphereResourceImpl)r).getResponse(false);
        String userAgent = ((AtmosphereResourceImpl)r).getRequest(false).getHeader("User-Agent");
        if (userAgent != null && (userAgent.contains("Android 2.") || userAgent.contains("Android 3."))) {
            super.inspect(r);
            AsyncIOWriter writer = response.getAsyncIOWriter();
            if (writer instanceof AtmosphereInterceptorWriter) {
                AtmosphereInterceptorWriter interceptorWriter = (AtmosphereInterceptorWriter)writer;
                interceptorWriter.interceptor(new AsyncIOInterceptorAdapter(this){

                    @Override
                    public void prePayload(AtmosphereResponse response, byte[] data, int offset, int length) {
                        response.write(padding, true);
                    }

                    @Override
                    public void postPayload(AtmosphereResponse response, byte[] data, int offset, int length) {
                        response.write(padding, true);
                    }
                });
            } else {
                logger.warn("Unable to apply {}. Your AsyncIOWriter must implement {}", (Object)this.getClass().getName(), (Object)AtmosphereInterceptorWriter.class.getName());
            }
        }
        return Action.CONTINUE;
    }

    @Override
    public String toString() {
        return "Android Interceptor Support";
    }

    static {
        paddingText = " ".repeat(4096) + "\n";
        padding = paddingText.getBytes();
    }
}

