/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.util.IOUtils;
import org.atmosphere.websocket.DefaultWebSocketProcessor;
import org.atmosphere.websocket.WebSocketProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketProcessorFactory {
    private static final Logger logger = LoggerFactory.getLogger(WebSocketProcessorFactory.class);
    private static final ReentrantLock factoryLock = new ReentrantLock();
    private static WebSocketProcessorFactory factory;
    private final ReentrantLock processorsLock = new ReentrantLock();
    private final Map<AtmosphereFramework, WebSocketProcessor> processors = new WeakHashMap<AtmosphereFramework, WebSocketProcessor>();

    public static WebSocketProcessorFactory getDefault() {
        factoryLock.lock();
        try {
            if (factory == null) {
                factory = new WebSocketProcessorFactory();
            }
            WebSocketProcessorFactory webSocketProcessorFactory = factory;
            return webSocketProcessorFactory;
        }
        finally {
            factoryLock.unlock();
        }
    }

    public Map<AtmosphereFramework, WebSocketProcessor> processors() {
        return this.processors;
    }

    public WebSocketProcessor getWebSocketProcessor(AtmosphereFramework framework) {
        WebSocketProcessor processor = this.processors.get(framework);
        if (processor == null) {
            this.processorsLock.lock();
            try {
                processor = this.createProcessor(framework);
                this.processors.put(framework, processor);
            }
            finally {
                this.processorsLock.unlock();
            }
        }
        return processor;
    }

    public void destroy() {
        this.processorsLock.lock();
        try {
            for (WebSocketProcessor processor : this.processors.values()) {
                processor.destroy();
            }
            this.processors.clear();
        }
        finally {
            this.processorsLock.unlock();
        }
    }

    private WebSocketProcessor createProcessor(AtmosphereFramework framework) {
        WebSocketProcessor processor = null;
        String webSocketProcessorName = framework.getWebSocketProcessorClassName();
        if (!webSocketProcessorName.equalsIgnoreCase(DefaultWebSocketProcessor.class.getName())) {
            try {
                processor = framework.newClassInstance(WebSocketProcessor.class, IOUtils.loadClass(this.getClass(), webSocketProcessorName));
            }
            catch (Exception ex) {
                logger.error("Unable to create {}", (Object)webSocketProcessorName);
                processor = new DefaultWebSocketProcessor();
            }
        }
        if (processor == null) {
            processor = new DefaultWebSocketProcessor();
        }
        processor.configure(framework.getAtmosphereConfig());
        return processor;
    }
}

