/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import jakarta.servlet.ServletConfig;
import java.util.concurrent.locks.ReentrantLock;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.util.IOUtils;
import org.atmosphere.websocket.DefaultWebSocketFactory;
import org.atmosphere.websocket.DefaultWebSocketProcessor;
import org.atmosphere.websocket.WebSocketFactory;
import org.atmosphere.websocket.WebSocketProtocol;
import org.atmosphere.websocket.protocol.SimpleHttpProtocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketConfig {
    private static final Logger logger = LoggerFactory.getLogger(WebSocketConfig.class);
    private final AtmosphereConfig config;
    private boolean webSocketEnabled = true;
    private boolean useServlet30 = true;
    private String webSocketProtocolClassName = SimpleHttpProtocol.class.getName();
    private WebSocketProtocol webSocketProtocol;
    private boolean webSocketProtocolInitialized;
    private boolean hasNewWebSocketProtocol;
    private String webSocketProcessorClassName = DefaultWebSocketProcessor.class.getName();
    private WebSocketFactory webSocketFactory;
    private final ReentrantLock webSocketFactoryLock = new ReentrantLock();

    public WebSocketConfig(AtmosphereConfig config) {
        this.config = config;
    }

    public void doInitParams(ServletConfig sc) {
        String s = sc.getInitParameter("org.atmosphere.useWebSocket");
        if (s != null) {
            this.webSocketEnabled = Boolean.parseBoolean(s);
            this.config.framework().sessionSupport(false);
        }
        if ((s = sc.getInitParameter("org.atmosphere.websocket.WebSocketProtocol")) != null) {
            this.webSocketProtocolClassName = s;
            this.hasNewWebSocketProtocol = true;
        }
        if ((s = sc.getInitParameter("org.atmosphere.websocket.WebSocketProcessor")) != null) {
            this.webSocketProcessorClassName = s;
        }
        if ((s = this.config.getInitParameter("org.atmosphere.useWebSocketAndServlet3")) != null) {
            this.useServlet30 = Boolean.parseBoolean(s);
        }
    }

    public void initWebSocket() {
        if (this.webSocketProtocolInitialized) {
            return;
        }
        if (this.webSocketProtocol == null) {
            try {
                this.webSocketProtocol = this.config.framework().newClassInstance(WebSocketProtocol.class, IOUtils.loadClass(this.config.framework().getClass(), this.webSocketProtocolClassName));
                logger.info("Installed WebSocketProtocol {} ", (Object)this.webSocketProtocolClassName);
            }
            catch (Exception ex) {
                logger.error("Cannot load the WebSocketProtocol {}", (Object)this.webSocketProtocolClassName, (Object)ex);
                try {
                    this.webSocketProtocol = this.config.framework().newClassInstance(WebSocketProtocol.class, SimpleHttpProtocol.class);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.webSocketProtocolInitialized = true;
        this.webSocketProtocol.configure(this.config);
    }

    public void configureWebSocketFactory() {
        if (this.webSocketFactory != null) {
            return;
        }
        this.webSocketFactoryLock.lock();
        try {
            if (this.webSocketFactory != null) {
                return;
            }
            try {
                this.webSocketFactory = this.config.framework().newClassInstance(WebSocketFactory.class, DefaultWebSocketFactory.class);
            }
            catch (IllegalAccessException | InstantiationException e) {
                logger.error("", (Throwable)e);
            }
        }
        finally {
            this.webSocketFactoryLock.unlock();
        }
    }

    public boolean isEnabled() {
        return this.webSocketEnabled;
    }

    public void setEnabled(boolean enabled) {
        this.webSocketEnabled = enabled;
    }

    public boolean isUseServlet30() {
        return this.useServlet30;
    }

    public void setUseServlet30(boolean useServlet30) {
        this.useServlet30 = useServlet30;
    }

    public String getProtocolClassName() {
        return this.webSocketProtocolClassName;
    }

    public void setProtocolClassName(String className) {
        this.hasNewWebSocketProtocol = true;
        this.webSocketProtocolClassName = className;
    }

    public WebSocketProtocol getProtocol() {
        this.initWebSocket();
        return this.webSocketProtocol;
    }

    public boolean hasNewProtocol() {
        return this.hasNewWebSocketProtocol;
    }

    public String getProcessorClassName() {
        return this.webSocketProcessorClassName;
    }

    public void setProcessorClassName(String className) {
        this.webSocketProcessorClassName = className;
    }

    public WebSocketFactory getFactory() {
        if (this.webSocketFactory == null) {
            this.configureWebSocketFactory();
        }
        return this.webSocketFactory;
    }

    public void setFactory(WebSocketFactory factory) {
        this.webSocketFactory = factory;
    }
}

