/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import org.atmosphere.cache.BroadcasterCacheInspector;
import org.atmosphere.cpr.AsyncSupport;
import org.atmosphere.cpr.AsyncSupportListener;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereFrameworkListener;
import org.atmosphere.cpr.AtmosphereInterceptor;
import org.atmosphere.cpr.AtmosphereResourceFactory;
import org.atmosphere.cpr.BroadcastFilter;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.BroadcasterCache;
import org.atmosphere.cpr.BroadcasterCacheListener;
import org.atmosphere.cpr.BroadcasterConfig;
import org.atmosphere.cpr.BroadcasterListener;
import org.atmosphere.util.EndpointMapper;
import org.atmosphere.websocket.WebSocketFactory;
import org.atmosphere.websocket.WebSocketProcessor;
import org.atmosphere.websocket.WebSocketProtocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum MetaServiceAction {
    INSTALL(new InstallMetaServiceProcedure()),
    EXCLUDE(new ExcludeMetaServiceProcedure());

    private static final Logger logger;
    private MetaServiceProcedure procedure;

    private MetaServiceAction(MetaServiceProcedure p) {
        this.procedure = p;
    }

    public void apply(AtmosphereFramework fwk, Class<?> clazz) throws Exception {
        this.procedure.apply(fwk, clazz);
    }

    static {
        logger = LoggerFactory.getLogger(MetaServiceAction.class);
    }

    private static interface MetaServiceProcedure {
        public void apply(AtmosphereFramework var1, Class<?> var2) throws Exception;
    }

    private static class InstallMetaServiceProcedure
    implements MetaServiceProcedure {
        private InstallMetaServiceProcedure() {
        }

        @Override
        public void apply(AtmosphereFramework fwk, Class<?> c) throws Exception {
            if (AtmosphereInterceptor.class.isAssignableFrom(c)) {
                fwk.interceptor(fwk.newClassInstance(AtmosphereInterceptor.class, c));
            } else if (Broadcaster.class.isAssignableFrom(c)) {
                fwk.setDefaultBroadcasterClassName(c.getName());
            } else if (BroadcasterListener.class.isAssignableFrom(c)) {
                fwk.addBroadcasterListener(fwk.newClassInstance(BroadcasterListener.class, c));
            } else if (BroadcasterCache.class.isAssignableFrom(c)) {
                fwk.setBroadcasterCacheClassName(c.getName());
            } else if (BroadcastFilter.class.isAssignableFrom(c)) {
                fwk.broadcasterFilters().add(c.getName());
            } else if (BroadcasterCacheInspector.class.isAssignableFrom(c)) {
                fwk.inspectors().add(fwk.newClassInstance(BroadcasterCacheInspector.class, c));
            } else if (AsyncSupportListener.class.isAssignableFrom(c)) {
                fwk.asyncSupportListener(fwk.newClassInstance(AsyncSupportListener.class, c));
            } else if (AsyncSupport.class.isAssignableFrom(c)) {
                fwk.setAsyncSupport(fwk.newClassInstance(AsyncSupport.class, c));
            } else if (BroadcasterCacheListener.class.isAssignableFrom(c)) {
                fwk.broadcasterCacheListeners().add(fwk.newClassInstance(BroadcasterCacheListener.class, c));
            } else if (BroadcasterConfig.FilterManipulator.class.isAssignableFrom(c)) {
                fwk.filterManipulators().add(fwk.newClassInstance(BroadcasterConfig.FilterManipulator.class, c));
            } else if (WebSocketProtocol.class.isAssignableFrom(c)) {
                fwk.setWebSocketProtocolClassName(c.getName());
            } else if (WebSocketProcessor.class.isAssignableFrom(c)) {
                fwk.setWebsocketProcessorClassName(c.getName());
            } else if (AtmosphereResourceFactory.class.isAssignableFrom(c)) {
                fwk.setAndConfigureAtmosphereResourceFactory(fwk.newClassInstance(AtmosphereResourceFactory.class, c));
            } else if (AtmosphereFrameworkListener.class.isAssignableFrom(c)) {
                fwk.frameworkListener(fwk.newClassInstance(AtmosphereFrameworkListener.class, c));
            } else if (WebSocketFactory.class.isAssignableFrom(c)) {
                fwk.webSocketFactory(fwk.newClassInstance(WebSocketFactory.class, c));
            } else if (!AtmosphereFramework.class.isAssignableFrom(c)) {
                if (EndpointMapper.class.isAssignableFrom(c)) {
                    fwk.endPointMapper(fwk.newClassInstance(EndpointMapper.class, c));
                } else {
                    logger.warn("{} is not a framework service that could be installed", (Object)c.getName());
                }
            }
        }
    }

    private static class ExcludeMetaServiceProcedure
    implements MetaServiceProcedure {
        private ExcludeMetaServiceProcedure() {
        }

        @Override
        public void apply(AtmosphereFramework fwk, Class<?> c) {
            if (AtmosphereInterceptor.class.isAssignableFrom(c)) {
                fwk.excludeInterceptor(c.getName());
            } else {
                logger.warn("{} is not a framework service that could be excluded, pull request is welcome ;-)", (Object)c.getName());
            }
        }
    }
}

