/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.AsyncSupportListener;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereFrameworkListener;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResourceListener;
import org.atmosphere.cpr.AtmosphereResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FrameworkEventDispatcher {
    private static final Logger logger = LoggerFactory.getLogger(FrameworkEventDispatcher.class);
    private final List<AsyncSupportListener> asyncSupportListeners = new ArrayList<AsyncSupportListener>();
    private final List<AtmosphereResourceListener> atmosphereResourceListeners = new ArrayList<AtmosphereResourceListener>();
    private final List<AtmosphereFrameworkListener> frameworkListeners = new LinkedList<AtmosphereFrameworkListener>();

    public void addAsyncSupportListener(AsyncSupportListener listener) {
        this.asyncSupportListeners.add(listener);
    }

    public List<AsyncSupportListener> asyncSupportListeners() {
        return this.asyncSupportListeners;
    }

    public void addAtmosphereResourceListener(AtmosphereResourceListener listener) {
        this.atmosphereResourceListeners.add(listener);
    }

    public List<AtmosphereResourceListener> atmosphereResourceListeners() {
        return this.atmosphereResourceListeners;
    }

    public void addFrameworkListener(AtmosphereFrameworkListener listener) {
        this.frameworkListeners.add(listener);
    }

    public List<AtmosphereFrameworkListener> frameworkListeners() {
        return this.frameworkListeners;
    }

    public void notify(Action.TYPE type, AtmosphereRequest request, AtmosphereResponse response) {
        for (AsyncSupportListener l : this.asyncSupportListeners) {
            try {
                switch (type) {
                    case TIMEOUT: {
                        l.onTimeout(request, response);
                        break;
                    }
                    case CANCELLED: {
                        l.onClose(request, response);
                        break;
                    }
                    case SUSPEND: {
                        l.onSuspend(request, response);
                        break;
                    }
                    case RESUME: {
                        l.onResume(request, response);
                        break;
                    }
                    case DESTROYED: {
                        l.onDestroyed(request, response);
                        break;
                    }
                }
            }
            catch (Throwable t) {
                logger.warn("", t);
            }
        }
    }

    public void notifyDestroyed(String uuid) {
        this.atmosphereResourceListeners.forEach(l -> l.onDisconnect(uuid));
    }

    public void notifySuspended(String uuid) {
        this.atmosphereResourceListeners.forEach(l -> l.onSuspended(uuid));
    }

    public void onPreInit(AtmosphereFramework framework) {
        this.forEachFrameworkListener(l -> l.onPreInit(framework));
    }

    public void onPostInit(AtmosphereFramework framework) {
        this.forEachFrameworkListener(l -> l.onPostInit(framework));
    }

    public void onPreDestroy(AtmosphereFramework framework) {
        this.forEachFrameworkListener(l -> l.onPreDestroy(framework));
    }

    public void onPostDestroy(AtmosphereFramework framework) {
        this.forEachFrameworkListener(l -> l.onPostDestroy(framework));
    }

    private void forEachFrameworkListener(Consumer<AtmosphereFrameworkListener> action) {
        for (AtmosphereFrameworkListener l : this.frameworkListeners) {
            try {
                action.accept(l);
            }
            catch (Exception e) {
                logger.error("", (Throwable)e);
            }
        }
    }

    public void clear() {
        this.asyncSupportListeners.clear();
        this.atmosphereResourceListeners.clear();
    }
}

