/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import jakarta.servlet.ServletConfig;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.util.Enumeration;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import org.atmosphere.cache.DefaultBroadcasterCache;
import org.atmosphere.cache.UUIDBroadcasterCache;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereHandlerWrapper;
import org.atmosphere.cpr.BroadcasterSetup;
import org.atmosphere.cpr.HandlerRegistry;
import org.atmosphere.cpr.WebSocketConfig;
import org.atmosphere.cpr.WebSocketProcessorFactory;
import org.atmosphere.util.ExecutorsFactory;
import org.atmosphere.util.Version;
import org.atmosphere.websocket.DefaultWebSocketProcessor;
import org.atmosphere.websocket.WebSocketProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class FrameworkDiagnostics {
    private static final Logger logger = LoggerFactory.getLogger(AtmosphereFramework.class);

    private FrameworkDiagnostics() {
    }

    static void info(AtmosphereFramework fwk) {
        ThreadPoolExecutor tpe;
        AtmosphereConfig config = fwk.getAtmosphereConfig();
        ServletConfig servletConfig = config.getServletConfig();
        BroadcasterSetup broadcasterSetup = fwk.broadcasterSetup;
        HandlerRegistry handlerRegistry = fwk.getHandlerRegistry();
        WebSocketConfig webSocketConfig = fwk.getWebSocketConfig();
        if (logger.isTraceEnabled()) {
            Enumeration e = servletConfig.getInitParameterNames();
            logger.trace("Configured init-params");
            while (e.hasMoreElements()) {
                String n = (String)e.nextElement();
                logger.trace("\t{} = {}", (Object)n, (Object)servletConfig.getInitParameter(n));
            }
        }
        logger.info("Using EndpointMapper {}", handlerRegistry.endPointMapper().getClass());
        for (String i : broadcasterSetup.broadcasterFilters()) {
            logger.info("Using BroadcastFilter: {}", (Object)i);
        }
        if (broadcasterSetup.broadcasterCacheClassName() == null || DefaultBroadcasterCache.class.getName().equals(broadcasterSetup.broadcasterCacheClassName())) {
            logger.warn("No BroadcasterCache configured. Broadcasted message between client reconnection will be LOST. It is recommended to configure the {}", (Object)UUIDBroadcasterCache.class.getName());
        } else {
            logger.info("Using BroadcasterCache: {}", (Object)broadcasterSetup.broadcasterCacheClassName());
        }
        String s = config.getInitParameter("org.atmosphere.cpr.Broadcaster.threadWaitTime");
        logger.info("Default Broadcaster Class: {}", (Object)broadcasterSetup.broadcasterClassName());
        logger.info("Broadcaster Shared List Resources: {}", (Object)config.getInitParameter("org.atmosphere.cpr.Broadcaster.sharedListenersList", false));
        logger.info("Broadcaster Polling Wait Time {}", s == null ? Integer.valueOf(100) : s);
        logger.info("Shared ExecutorService supported: {}", (Object)fwk.isShareExecutorServices());
        ExecutorService executorService = ExecutorsFactory.getMessageDispatcher(config, "/*");
        if (executorService != null) {
            if (executorService instanceof ThreadPoolExecutor) {
                tpe = (ThreadPoolExecutor)executorService;
                long max = tpe.getMaximumPoolSize();
                logger.info("Messaging Thread Pool Size: {}", tpe.getMaximumPoolSize() == Integer.MAX_VALUE ? "Unlimited" : Long.valueOf(max));
            } else {
                logger.info("Messaging ExecutorService Pool Size unavailable - Not instance of ThreadPoolExecutor");
            }
        }
        if ((executorService = ExecutorsFactory.getAsyncOperationExecutor(config, "/*")) != null) {
            if (executorService instanceof ThreadPoolExecutor) {
                tpe = (ThreadPoolExecutor)executorService;
                logger.info("Async I/O Thread Pool Size: {}", (Object)tpe.getMaximumPoolSize());
            } else {
                logger.info("Async I/O ExecutorService Pool Size unavailable - Not instance of ThreadPoolExecutor");
            }
        }
        logger.info("Using BroadcasterFactory: {}", (Object)broadcasterSetup.broadcasterFactory().getClass().getName());
        logger.info("Using AtmosphereResurceFactory: {}", (Object)broadcasterSetup.arFactory().getClass().getName());
        logger.info("Using WebSocketProcessor: {}", (Object)webSocketConfig.getProcessorClassName());
        if (broadcasterSetup.defaultSerializerClassName() != null && !broadcasterSetup.defaultSerializerClassName().isEmpty()) {
            logger.info("Using Serializer: {}", (Object)broadcasterSetup.defaultSerializerClassName());
        }
        WebSocketProcessor wp = WebSocketProcessorFactory.getDefault().getWebSocketProcessor(fwk);
        boolean b = false;
        if (wp instanceof DefaultWebSocketProcessor) {
            DefaultWebSocketProcessor dwp = (DefaultWebSocketProcessor)wp;
            b = dwp.invokeInterceptors();
        }
        logger.info("Invoke AtmosphereInterceptor on WebSocket message {}", (Object)b);
        logger.info("HttpSession supported: {}", (Object)config.isSupportSession());
        logger.info("Atmosphere is using {} for dependency injection and object creation", fwk.objectFactory());
        logger.info("Atmosphere is using async support: {} running under container: {}", (Object)fwk.getAsyncSupport().getClass().getName(), (Object)fwk.getAsyncSupport().getContainerName());
        logger.info("Atmosphere Framework {} started.", (Object)Version.getRawVersion());
        logger.info("\n\n\tFor Atmosphere Framework Commercial Support, visit \n\t{} or send an email to {}\n", (Object)"http://www.async-io.org/", (Object)"support@async-io.org");
        if (logger.isTraceEnabled()) {
            for (Map.Entry<String, AtmosphereHandlerWrapper> e : handlerRegistry.handlers().entrySet()) {
                logger.trace("\nConfigured AtmosphereHandler {}\n", (Object)e.getKey());
                logger.trace("{}", (Object)e.getValue());
            }
        }
    }

    static void analytics(AtmosphereConfig config) {
        if (!config.getInitParameter("org.atmosphere.cpr.AtmosphereFramework.analytics", true)) {
            return;
        }
        Thread t = new Thread(() -> {
            try {
                String currentVersion = Version.getRawVersion();
                if (currentVersion.contains("SNAPSHOT")) {
                    return;
                }
                logger.debug("Checking for Atmosphere updates via GitHub API");
                URL url = URI.create("https://api.github.com/repos/Atmosphere/atmosphere/releases/latest").toURL();
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestProperty("Accept", "application/vnd.github+json");
                conn.setRequestProperty("User-Agent", "Atmosphere/" + currentVersion);
                conn.setConnectTimeout(5000);
                conn.setReadTimeout(5000);
                conn.setInstanceFollowRedirects(true);
                try {
                    String latestVersion;
                    int end;
                    if (conn.getResponseCode() != 200) {
                        return;
                    }
                    String body = new String(conn.getInputStream().readAllBytes());
                    int idx = body.indexOf("\"tag_name\"");
                    if (idx < 0) {
                        return;
                    }
                    int start = body.indexOf(34, idx + 10) + 1;
                    String tag = body.substring(start, end = body.indexOf(34, start));
                    String string = latestVersion = tag.startsWith("atmosphere-") ? tag.substring(11) : tag;
                    if (latestVersion.compareTo(currentVersion) > 0 && !latestVersion.toLowerCase().contains("rc") && !latestVersion.toLowerCase().contains("beta")) {
                        logger.info("\n\n\tAtmosphere {} is available (you are running {})\n\thttps://github.com/Atmosphere/atmosphere/releases/tag/{}", new Object[]{latestVersion, currentVersion, tag});
                    }
                }
                finally {
                    conn.disconnect();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        });
        t.setDaemon(true);
        t.start();
    }
}

