/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.atmosphere.annotation.Processor;
import org.atmosphere.cpr.AnnotationProcessor;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereHandlerWrapper;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.BroadcasterFactory;
import org.atmosphere.cpr.BroadcasterListener;
import org.atmosphere.cpr.BroadcasterSetup;
import org.atmosphere.cpr.DefaultBroadcasterFactory;
import org.atmosphere.cpr.HandlerRegistry;
import org.atmosphere.handler.ReflectorServletProcessor;
import org.atmosphere.util.IOUtils;
import org.atmosphere.websocket.WebSocketProtocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClasspathScanner {
    private static final Logger logger = LoggerFactory.getLogger(ClasspathScanner.class);
    private String annotationProcessorClassName = "org.atmosphere.cpr.DefaultAnnotationProcessor";
    AnnotationProcessor annotationProcessor;
    private boolean annotationFound;
    boolean scanDone;
    private final List<String> packages = new ArrayList<String>();
    private final LinkedList<String> annotationPackages = new LinkedList();
    final ArrayList<String> possibleComponentsCandidate = new ArrayList();
    private boolean allowAllClassesScan = true;
    private String handlersPath = "/WEB-INF/classes/";
    private String libPath = "/WEB-INF/lib/";
    private final AtmosphereConfig config;

    ClasspathScanner(AtmosphereConfig config) {
        this.config = config;
    }

    String handlersPath() {
        return this.handlersPath;
    }

    void setHandlersPath(String handlersPath) {
        this.handlersPath = handlersPath;
    }

    String libPath() {
        return this.libPath;
    }

    void setLibPath(String libPath) {
        this.libPath = libPath;
    }

    void setAnnotationProcessorClassName(String className) {
        this.annotationProcessorClassName = className;
    }

    void setAnnotationFound(boolean annotationFound) {
        this.annotationFound = annotationFound;
    }

    boolean allowAllClassesScan() {
        return this.allowAllClassesScan;
    }

    void setAllowAllClassesScan(boolean allowAllClassesScan) {
        this.allowAllClassesScan = allowAllClassesScan;
    }

    List<String> packages() {
        return this.packages;
    }

    LinkedList<String> annotationPackages() {
        return this.annotationPackages;
    }

    AnnotationProcessor annotationProcessor() {
        return this.annotationProcessor;
    }

    void parseInitParams(ServletConfig sc) {
        String s = sc.getInitParameter("org.atmosphere.cpr.atmosphereHandlerPath");
        if (s != null) {
            this.handlersPath = s;
        }
        if ((s = sc.getInitParameter("com.sun.jersey.config.property.packages")) != null) {
            this.packages.add(s);
        }
    }

    void clear() {
        this.possibleComponentsCandidate.clear();
        this.packages.clear();
        this.annotationPackages.clear();
        this.annotationFound = false;
        this.scanDone = false;
    }

    void preventOOM() {
        String s = this.config.getInitParameter("org.atmosphere.cpr.scanClassPath");
        if (s != null) {
            this.allowAllClassesScan = Boolean.parseBoolean(s);
        }
        try {
            Class.forName("org.testng.Assert");
            this.allowAllClassesScan = false;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    void configureScanningPackage(ServletConfig sc, String value) {
        String packageName = sc.getInitParameter(value);
        if (packageName != null) {
            String[] list = packageName.split(",");
            Collections.addAll(this.packages, list);
        }
    }

    void defaultPackagesToScan() {
        this.packages.add("io.async.control");
        this.packages.add("io.async.satellite");
        this.packages.add("io.async.postman");
    }

    void configureAnnotationPackages() {
        this.annotationPackages.add(Processor.class.getPackage().getName());
        String s = this.config.getInitParameter("org.atmosphere.annotation.packages");
        if (s != null) {
            String[] l;
            for (String p : l = s.split(",")) {
                this.annotationPackages.addLast(p);
            }
        }
    }

    void installAnnotationProcessor(ServletConfig sc) {
        String s = sc.getInitParameter("org.atmosphere.cpr.AnnotationProcessor");
        if (s != null) {
            this.annotationProcessorClassName = s;
        }
    }

    void getFiles(File f) {
        if (this.scanDone) {
            return;
        }
        File[] files = f.listFiles();
        if (files != null) {
            for (File test : files) {
                if (test.isDirectory()) {
                    this.getFiles(test);
                    continue;
                }
                String clazz = test.getAbsolutePath();
                if (!clazz.endsWith(".class")) continue;
                this.possibleComponentsCandidate.add(clazz);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void autoConfigureService(ServletContext sc) throws IOException {
        AtmosphereFramework fwk = this.config.framework();
        String path = this.handlersPath != "/WEB-INF/classes/" ? this.handlersPath : IOUtils.realPath(sc, this.handlersPath);
        try {
            this.annotationProcessor = fwk.newClassInstance(AnnotationProcessor.class, IOUtils.loadClass(fwk.getClass(), this.annotationProcessorClassName));
            logger.info("Atmosphere is using {} for processing annotation", (Object)this.annotationProcessorClassName);
            this.annotationProcessor.configure(this.config);
            if (!this.packages.isEmpty()) {
                for (String s : this.packages) {
                    this.annotationProcessor.scan(s);
                }
            }
            if (!this.annotationFound) {
                File libFolder;
                File[] jars;
                String pathLibs;
                if (path != null) {
                    this.annotationProcessor.scan(new File(path));
                }
                String string = pathLibs = !this.libPath.equals("/WEB-INF/lib/") ? this.libPath : IOUtils.realPath(sc, "/WEB-INF/lib/");
                if (pathLibs != null && (jars = (libFolder = new File(pathLibs)).listFiles((arg0, arg1) -> arg1.endsWith(".jar"))) != null) {
                    for (File file : jars) {
                        this.annotationProcessor.scan(file);
                    }
                }
            }
            if (!this.annotationFound && this.allowAllClassesScan) {
                logger.debug("Scanning all classes on the classpath");
                this.annotationProcessor.scanAll();
            }
        }
        catch (Throwable e) {
            logger.error("", e);
        }
        finally {
            if (this.annotationProcessor != null) {
                this.annotationProcessor.destroy();
            }
        }
    }

    void autoDetectAtmosphereHandlers(ServletContext servletContext, ClassLoader classloader) throws MalformedURLException {
        AtmosphereFramework fwk = this.config.framework();
        if (!fwk.getHandlerRegistry().handlers().isEmpty()) {
            return;
        }
        logger.info("Auto detecting atmosphere handlers {}", (Object)this.handlersPath);
        String rp = servletContext.getRealPath(this.handlersPath);
        if (rp == null) {
            URL u = servletContext.getResource(this.handlersPath);
            if (u == null) {
                return;
            }
            rp = u.getPath();
        }
        this.loadAtmosphereHandlersFromPath(classloader, rp);
    }

    void loadAtmosphereHandlersFromPath(ClassLoader classloader, String realPath) {
        AtmosphereFramework fwk = this.config.framework();
        File file = new File(realPath);
        if (file.exists() && file.isDirectory()) {
            this.getFiles(file);
            this.scanDone = true;
            for (String className : this.possibleComponentsCandidate) {
                try {
                    className = className.replace('\\', '/');
                    Class<?> clazz = classloader.loadClass(className = className.replaceFirst("^.*/(WEB-INF|target)(?:/scala-[^/]+)?/(test-)?classes/(.*)\\.class", "$3").replace("/", "."));
                    if (!AtmosphereHandler.class.isAssignableFrom(clazz)) continue;
                    AtmosphereHandler handler = fwk.newClassInstance(AtmosphereHandler.class, clazz);
                    String path = "/" + handler.getClass().getSimpleName();
                    HandlerRegistry handlerRegistry = fwk.getHandlerRegistry();
                    handlerRegistry.handlers().put(handlerRegistry.normalizePath(path), new AtmosphereHandlerWrapper(fwk.getBroadcasterFactory(), handler, path, this.config));
                    logger.info("Installed AtmosphereHandler {} mapped to context-path: {}", (Object)handler, (Object)handler.getClass().getName());
                }
                catch (Throwable t) {
                    logger.trace("failed to load class as an AtmosphereHandler: " + className, t);
                }
            }
        }
    }

    void autoDetectWebSocketHandler(ServletContext servletContext, ClassLoader classloader) throws MalformedURLException {
        AtmosphereFramework fwk = this.config.framework();
        if (fwk.getWebSocketConfig().hasNewProtocol()) {
            return;
        }
        logger.info("Auto detecting WebSocketHandler in {}", (Object)this.handlersPath);
        this.loadWebSocketFromPath(classloader, IOUtils.realPath(servletContext, this.handlersPath));
    }

    void loadWebSocketFromPath(ClassLoader classloader, String realPath) {
        if (realPath == null || realPath.isEmpty()) {
            return;
        }
        AtmosphereFramework fwk = this.config.framework();
        File file = new File(realPath);
        if (file.exists() && file.isDirectory()) {
            this.getFiles(file);
            this.scanDone = true;
            for (String className : this.possibleComponentsCandidate) {
                try {
                    className = className.replace('\\', '/');
                    Class<?> clazz = classloader.loadClass(className = className.replaceFirst("^.*/(WEB-INF|target)(?:/scala-[^/]+)?/(test-)?classes/(.*)\\.class", "$3").replace("/", "."));
                    if (!WebSocketProtocol.class.isAssignableFrom(clazz)) continue;
                    fwk.getWebSocketConfig().setProtocolClassName(clazz.getName());
                    logger.info("Auto-detected WebSocketProtocol {}", (Object)fwk.getWebSocketConfig().getProtocolClassName());
                }
                catch (Throwable t) {
                    logger.trace("failed to load class as an WebSocketProtocol: " + className, t);
                }
            }
        }
    }

    void loadConfiguration(ServletConfig sc) throws Exception {
        AtmosphereFramework fwk = this.config.framework();
        if (!fwk.isAutoDetectHandlers()) {
            return;
        }
        URL url = sc.getServletContext().getResource(this.handlersPath);
        ClassLoader urlC = url == null ? fwk.getClass().getClassLoader() : new URLClassLoader(new URL[]{url}, Thread.currentThread().getContextClassLoader());
        fwk.loadAtmosphereDotXml(sc.getServletContext().getResourceAsStream(fwk.getAtmosphereDotXmlPath()), urlC);
        if (fwk.getHandlerRegistry().handlers().isEmpty()) {
            this.autoDetectAtmosphereHandlers(sc.getServletContext(), urlC);
            if (fwk.getHandlerRegistry().handlers().isEmpty()) {
                this.detectSupportedFramework(sc);
            }
        }
        this.autoDetectWebSocketHandler(sc.getServletContext(), urlC);
    }

    boolean detectSupportedFramework(ServletConfig sc) throws Exception {
        Object b;
        boolean isJersey;
        AtmosphereFramework fwk = this.config.framework();
        BroadcasterSetup broadcasterSetup = fwk.broadcasterSetup;
        String broadcasterClassNameTmp = null;
        try {
            IOUtils.loadClass(fwk.getClass(), "com.sun.jersey.spi.container.servlet.ServletContainer");
            isJersey = true;
            if (!broadcasterSetup.isBroadcasterSpecified()) {
                broadcasterClassNameTmp = fwk.lookupDefaultBroadcasterType("org.atmosphere.jersey.JerseyBroadcaster");
                IOUtils.loadClass(fwk.getClass(), broadcasterClassNameTmp);
            }
            fwk.useStreamForFlushingComments = true;
            StringBuilder packagesInit = new StringBuilder();
            for (String s : this.packages) {
                packagesInit.append(s).append(",");
            }
            fwk.initParams.put("com.sun.jersey.config.property.packages", packagesInit.toString());
        }
        catch (Throwable t) {
            logger.trace("", t);
            return false;
        }
        logger.debug("Missing META-INF/atmosphere.xml but found the Jersey runtime. Starting Jersey");
        ReflectorServletProcessor rsp = fwk.newClassInstance(ReflectorServletProcessor.class, ReflectorServletProcessor.class);
        if (broadcasterClassNameTmp != null) {
            broadcasterSetup.setBroadcasterClassName(broadcasterClassNameTmp);
        }
        this.configureDetectedFramework(rsp, isJersey);
        fwk.sessionSupport(false);
        fwk.initParams.put("org.atmosphere.disableOnStateEvent", "true");
        String mapping = sc.getInitParameter("org.atmosphere.jersey.servlet-mapping");
        if (mapping == null && (mapping = sc.getInitParameter("org.atmosphere.cpr.AtmosphereHandler.contextRoot")) == null) {
            mapping = "/*";
        }
        Class<?> bc = IOUtils.loadClass(fwk.getClass(), broadcasterSetup.broadcasterClassName());
        broadcasterSetup.broadcasterFactory().destroy();
        broadcasterSetup.setBroadcasterFactory(fwk.newClassInstance(BroadcasterFactory.class, DefaultBroadcasterFactory.class));
        broadcasterSetup.broadcasterFactory().configure(bc, broadcasterSetup.broadcasterLifeCyclePolicy(), this.config);
        for (BroadcasterListener b2 : broadcasterSetup.broadcasterListeners()) {
            broadcasterSetup.broadcasterFactory().addBroadcasterListener(b2);
        }
        try {
            b = broadcasterSetup.broadcasterFactory().get(bc, mapping);
        }
        catch (IllegalStateException ex) {
            logger.warn("Two Broadcaster's named {}. Renaming the second one to {}", (Object)mapping, (Object)(sc.getServletName() + mapping));
            b = broadcasterSetup.broadcasterFactory().get(bc, sc.getServletName() + mapping);
        }
        fwk.addAtmosphereHandler(mapping, (AtmosphereHandler)rsp, (Broadcaster)b);
        return true;
    }

    void configureDetectedFramework(ReflectorServletProcessor rsp, boolean isJersey) {
        rsp.setServletClassName("com.sun.jersey.spi.container.servlet.ServletContainer");
    }
}

