/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import java.util.LinkedList;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereInterceptor;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.BroadcasterFactory;
import org.atmosphere.util.Utils;

public final class AtmosphereHandlerWrapper {
    private final AtmosphereHandler atmosphereHandler;
    private Broadcaster broadcaster;
    private String mapping;
    private final LinkedList<AtmosphereInterceptor> interceptors = new LinkedList();
    private boolean needRequestScopedInjection;
    private final boolean wilcardMapping;

    public AtmosphereHandlerWrapper(BroadcasterFactory broadcasterFactory, AtmosphereHandler atmosphereHandler, String mapping, AtmosphereConfig config) {
        this.atmosphereHandler = atmosphereHandler;
        try {
            if (broadcasterFactory != null) {
                this.broadcaster = broadcasterFactory.lookup(mapping, true);
            } else {
                this.mapping = mapping;
            }
        }
        catch (Exception t) {
            throw new RuntimeException(t);
        }
        this.wilcardMapping = mapping.contains("{") && mapping.contains("}");
        this.hookInjection(config);
    }

    void hookInjection(AtmosphereConfig config) {
        config.startupHook(framework -> {
            this.needRequestScopedInjection = Utils.requestScopedInjection(config, this.atmosphereHandler);
        });
    }

    public AtmosphereHandlerWrapper(AtmosphereHandler atmosphereHandler, Broadcaster broadcaster, AtmosphereConfig config) {
        this.atmosphereHandler = atmosphereHandler;
        this.broadcaster = broadcaster;
        this.hookInjection(config);
        this.wilcardMapping = false;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < this.interceptors.size(); ++i) {
            b.append("\n\t").append(i).append(": ").append(this.interceptors.get(i).getClass().getName());
        }
        return "\n atmosphereHandler\n\t" + String.valueOf(this.atmosphereHandler) + "\n interceptors" + b.toString() + "\n broadcaster\t" + String.valueOf(this.broadcaster);
    }

    public AtmosphereHandler atmosphereHandler() {
        return this.atmosphereHandler;
    }

    public Broadcaster broadcaster() {
        return this.broadcaster;
    }

    public void setBroadcaster(Broadcaster broadcaster) {
        this.broadcaster = broadcaster;
    }

    public String mapping() {
        return this.mapping;
    }

    public LinkedList<AtmosphereInterceptor> interceptors() {
        return this.interceptors;
    }

    public boolean needRequestScopedInjection() {
        return this.needRequestScopedInjection;
    }

    public boolean wildcardMapping() {
        return this.wilcardMapping;
    }
}

