/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.atmosphere.cache.BroadcasterCacheInspector;
import org.atmosphere.config.ApplicationConfiguration;
import org.atmosphere.config.AtmosphereHandlerConfig;
import org.atmosphere.config.AtmosphereHandlerProperty;
import org.atmosphere.config.FrameworkConfiguration;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.AnnotationProcessor;
import org.atmosphere.cpr.AsyncSupport;
import org.atmosphere.cpr.AsyncSupportListener;
import org.atmosphere.cpr.AsyncSupportListenerAdapter;
import org.atmosphere.cpr.AsyncSupportResolver;
import org.atmosphere.cpr.AsynchronousProcessor;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereFrameworkListener;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereHandlerWrapper;
import org.atmosphere.cpr.AtmosphereInterceptor;
import org.atmosphere.cpr.AtmosphereObjectFactory;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceFactory;
import org.atmosphere.cpr.AtmosphereResourceListener;
import org.atmosphere.cpr.AtmosphereResourceSessionFactory;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.cpr.BroadcastFilter;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.BroadcasterCacheListener;
import org.atmosphere.cpr.BroadcasterConfig;
import org.atmosphere.cpr.BroadcasterFactory;
import org.atmosphere.cpr.BroadcasterListener;
import org.atmosphere.cpr.BroadcasterSetup;
import org.atmosphere.cpr.ClasspathScanner;
import org.atmosphere.cpr.DefaultAsyncSupportResolver;
import org.atmosphere.cpr.DefaultAtmosphereObjectFactory;
import org.atmosphere.cpr.DefaultBroadcasterFactory;
import org.atmosphere.cpr.FrameworkConfig;
import org.atmosphere.cpr.FrameworkDiagnostics;
import org.atmosphere.cpr.FrameworkEventDispatcher;
import org.atmosphere.cpr.HandlerRegistry;
import org.atmosphere.cpr.InterceptorRegistry;
import org.atmosphere.cpr.MetaBroadcaster;
import org.atmosphere.cpr.MetaServiceAction;
import org.atmosphere.cpr.Serializer;
import org.atmosphere.cpr.SessionSupport;
import org.atmosphere.cpr.Universe;
import org.atmosphere.cpr.WebSocketConfig;
import org.atmosphere.cpr.WebSocketProcessorFactory;
import org.atmosphere.handler.AbstractReflectorAtmosphereHandler;
import org.atmosphere.handler.ReflectorServletProcessor;
import org.atmosphere.inject.InjectableObjectFactory;
import org.atmosphere.util.AtmosphereConfigReader;
import org.atmosphere.util.DefaultUUIDProvider;
import org.atmosphere.util.EndpointMapper;
import org.atmosphere.util.ExecutorsFactory;
import org.atmosphere.util.IOUtils;
import org.atmosphere.util.IntrospectionUtils;
import org.atmosphere.util.ServletContextFactory;
import org.atmosphere.util.UUIDProvider;
import org.atmosphere.util.VoidServletConfig;
import org.atmosphere.websocket.WebSocket;
import org.atmosphere.websocket.WebSocketFactory;
import org.atmosphere.websocket.WebSocketHandler;
import org.atmosphere.websocket.WebSocketProtocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtmosphereFramework {
    public static final String DEFAULT_ATMOSPHERE_CONFIG_PATH = "/META-INF/atmosphere.xml";
    public static final String DEFAULT_LIB_PATH = "/WEB-INF/lib/";
    public static final String DEFAULT_HANDLER_PATH = "/WEB-INF/classes/";
    public static final String META_SERVICE = "META-INF/services/";
    public static final String MAPPING_REGEX = "[a-zA-Z0-9-&.*_~=@;\\?]+";
    public static final String ASYNC_IO = "io.async";
    protected static final Logger logger = LoggerFactory.getLogger(AtmosphereFramework.class);
    protected final FrameworkEventDispatcher eventDispatcher = new FrameworkEventDispatcher();
    protected final HashMap<String, String> initParams = new HashMap();
    protected final AtmosphereConfig config;
    protected final AtomicBoolean isCometSupportConfigured = new AtomicBoolean(false);
    protected final boolean isFilter;
    protected final ConcurrentLinkedQueue<String> objectFactoryType = new ConcurrentLinkedQueue();
    protected boolean useNativeImplementation;
    protected boolean useBlockingImplementation;
    protected boolean useStreamForFlushingComments = true;
    protected AsyncSupport<?> asyncSupport;
    protected boolean isCometSupportSpecified;
    protected boolean isSessionSupportSpecified;
    protected boolean isThrowExceptionOnClonedRequestSpecified;
    protected ServletConfig servletConfig;
    protected boolean autoDetectHandlers = true;
    protected String atmosphereDotXmlPath = "/META-INF/atmosphere.xml";
    protected String metaServicePath = "META-INF/services/";
    protected boolean isInit;
    protected boolean sharedThreadPools = true;
    protected boolean executeFirstSet;
    protected AtmosphereObjectFactory<?> objectFactory = new DefaultAtmosphereObjectFactory();
    protected final AtomicBoolean isDestroyed = new AtomicBoolean();
    protected boolean externalizeDestroy;
    private UUIDProvider uuidProvider = new DefaultUUIDProvider();
    protected Thread shutdownHook;
    protected final WebSocketConfig webSocketConfig;
    protected final InterceptorRegistry interceptorRegistry;
    protected final HandlerRegistry handlerRegistry;
    protected final BroadcasterSetup broadcasterSetup;
    protected final ClasspathScanner classpathScanner;
    public static final List<Class<? extends AtmosphereInterceptor>> DEFAULT_ATMOSPHERE_INTERCEPTORS = InterceptorRegistry.DEFAULT_ATMOSPHERE_INTERCEPTORS;
    private IllegalStateException initializationError;
    public static final AtmosphereHandler REFLECTOR_ATMOSPHEREHANDLER = new AbstractReflectorAtmosphereHandler(){

        @Override
        public void onRequest(AtmosphereResource resource) {
            logger.trace("VoidHandler {}", (Object)resource.uuid());
        }

        @Override
        public void destroy() {
            logger.trace("VoidHandler");
        }
    };

    public void setAndConfigureAtmosphereResourceFactory(AtmosphereResourceFactory arFactory) {
        this.broadcasterSetup.setArFactory(arFactory);
        this.broadcasterSetup.arFactory().configure(this.config);
    }

    public AtmosphereFramework() {
        this(false, true);
    }

    public AtmosphereFramework(ServletConfig sc) throws ServletException {
        this(false, true);
        this.init(sc);
    }

    public AtmosphereFramework(boolean isFilter, boolean autoDetectHandlers) {
        this.isFilter = isFilter;
        this.autoDetectHandlers = autoDetectHandlers;
        this.config = this.newAtmosphereConfig();
        this.webSocketConfig = new WebSocketConfig(this.config);
        this.interceptorRegistry = new InterceptorRegistry(this.config);
        this.handlerRegistry = new HandlerRegistry(this.config, this.interceptorRegistry);
        this.broadcasterSetup = new BroadcasterSetup(this.config);
        this.broadcasterSetup.setHandlersSupplier(this.handlerRegistry::handlers);
        this.classpathScanner = new ClasspathScanner(this.config);
        this.interceptorRegistry.setHandlersSupplier(this.handlerRegistry::handlers);
        this.handlerRegistry.setBroadcasterFactorySupplier(() -> this.broadcasterSetup.broadcasterFactory());
    }

    protected AtmosphereConfig newAtmosphereConfig() {
        return new AtmosphereConfig(this);
    }

    private void populateBroadcasterType() {
        this.broadcasterSetup.populateBroadcasterType();
    }

    HandlerRegistry getHandlerRegistry() {
        return this.handlerRegistry;
    }

    WebSocketConfig getWebSocketConfig() {
        return this.webSocketConfig;
    }

    boolean isAutoDetectHandlers() {
        return this.autoDetectHandlers;
    }

    private void populateObjectFactoryType() {
        this.objectFactoryType.add("org.atmosphere.cdi.CDIObjectFactory");
        this.objectFactoryType.add("org.atmosphere.spring.SpringWebObjectFactory");
        this.objectFactoryType.add("org.atmosphere.guice.GuiceObjectFactory");
    }

    public AtmosphereFramework addAtmosphereHandler(String mapping, AtmosphereHandler h, List<AtmosphereInterceptor> l) {
        this.handlerRegistry.addAtmosphereHandler(mapping, h, l);
        return this;
    }

    public AtmosphereFramework addAtmosphereHandler(String mapping, AtmosphereHandler h, Broadcaster broadcaster, List<AtmosphereInterceptor> l) {
        this.handlerRegistry.addAtmosphereHandler(mapping, h, broadcaster, l);
        return this;
    }

    public AtmosphereFramework addAtmosphereHandler(String mapping, AtmosphereHandler h, String broadcasterId, List<AtmosphereInterceptor> l) {
        this.handlerRegistry.addAtmosphereHandler(mapping, h, broadcasterId, l);
        return this;
    }

    protected AtmosphereHandlerWrapper createWrapperAndConfigureHandler(AtmosphereHandler h, String mapping, List<AtmosphereInterceptor> l) {
        return this.handlerRegistry.createWrapperAndConfigureHandler(h, mapping, l);
    }

    public AtmosphereFramework addAtmosphereHandler(String mapping, AtmosphereHandler h) {
        this.handlerRegistry.addAtmosphereHandler(mapping, h);
        return this;
    }

    public String normalizePath(String path) {
        return this.handlerRegistry.normalizePath(path);
    }

    public AtmosphereFramework addAtmosphereHandler(String mapping, AtmosphereHandler h, String broadcasterId) {
        this.handlerRegistry.addAtmosphereHandler(mapping, h, broadcasterId);
        return this;
    }

    public AtmosphereFramework addAtmosphereHandler(String mapping, AtmosphereHandler h, Broadcaster broadcaster) {
        this.handlerRegistry.addAtmosphereHandler(mapping, h, broadcaster);
        return this;
    }

    public AtmosphereFramework removeAtmosphereHandler(String mapping) {
        this.handlerRegistry.removeAtmosphereHandler(mapping);
        return this;
    }

    public AtmosphereFramework removeAllAtmosphereHandler() {
        this.handlerRegistry.removeAllAtmosphereHandler();
        return this;
    }

    public AtmosphereFramework removeAllInitParams() {
        this.initParams.clear();
        return this;
    }

    public AtmosphereFramework addInitParameter(String name, String value) {
        this.initParams.put(name, value);
        return this;
    }

    protected void readSystemProperties() {
        if (System.getProperty("org.atmosphere.useNative") != null) {
            this.useNativeImplementation = Boolean.parseBoolean(System.getProperty("org.atmosphere.useNative"));
            this.isCometSupportSpecified = true;
        }
        if (System.getProperty("org.atmosphere.useBlocking") != null) {
            this.useBlockingImplementation = Boolean.parseBoolean(System.getProperty("org.atmosphere.useBlocking"));
            this.isCometSupportSpecified = true;
        }
        this.atmosphereDotXmlPath = System.getProperty("org.atmosphere.atmosphereDotXml", this.atmosphereDotXmlPath);
        if (System.getProperty("org.atmosphere.disableOnStateEvent") != null) {
            this.initParams.put("org.atmosphere.disableOnStateEvent", System.getProperty("org.atmosphere.disableOnStateEvent"));
        }
    }

    public void patchContainer() {
        System.setProperty("org.apache.catalina.STRICT_SERVLET_COMPLIANCE", "false");
    }

    public AtmosphereFramework init() {
        try {
            this.init(this.servletConfig == null ? new VoidServletConfig(this.initParams) : this.servletConfig, false);
        }
        catch (ServletException e) {
            logger.error("", (Throwable)e);
        }
        return this;
    }

    public AtmosphereFramework init(ServletConfig sc) throws ServletException {
        return this.init(sc, true);
    }

    protected void preventOOM() {
        this.classpathScanner.preventOOM();
    }

    public AtmosphereFramework init(ServletConfig sc, boolean wrap) throws ServletException {
        if (this.isInit) {
            return this;
        }
        this.servletConfig(sc, wrap);
        this.readSystemProperties();
        this.populateBroadcasterType();
        this.populateObjectFactoryType();
        this.loadMetaService();
        this.onPreInit();
        try {
            String s;
            ServletContextFactory.getDefault().init(sc.getServletContext());
            this.preventOOM();
            this.doInitParams(this.servletConfig);
            this.doInitParamsForWebSocket(this.servletConfig);
            this.lookupDefaultObjectFactoryType();
            if (logger.isTraceEnabled()) {
                this.asyncSupportListener(this.newClassInstance(AsyncSupportListener.class, AsyncSupportListenerAdapter.class));
            }
            this.configureObjectFactory();
            this.configureAnnotationPackages();
            this.configureBroadcasterFactory();
            this.configureMetaBroadcaster();
            this.configureAtmosphereResourceFactory();
            if (this.isSessionSupportSpecified) {
                this.sessionFactory();
            }
            this.configureScanningPackage(this.servletConfig, "org.atmosphere.cpr.packages");
            this.configureScanningPackage(this.servletConfig, "jersey.config.server.provider.packages");
            this.configureScanningPackage(this.servletConfig, "com.sun.jersey.config.property.packages");
            this.defaultPackagesToScan();
            this.installAnnotationProcessor(this.servletConfig);
            this.autoConfigureService(this.servletConfig.getServletContext());
            this.configureBroadcasterFactory();
            this.patchContainer();
            this.configureBroadcaster();
            this.loadConfiguration(this.servletConfig);
            this.initWebSocket();
            this.initEndpointMapper();
            this.initDefaultSerializer();
            this.autoDetectContainer();
            this.configureWebDotXmlAtmosphereHandler(this.servletConfig);
            this.asyncSupport.init(this.servletConfig);
            this.initAtmosphereHandler(this.servletConfig);
            this.configureAtmosphereInterceptor(this.servletConfig);
            this.analytics();
            if (sc.getServletContext() != null) {
                sc.getServletContext().setAttribute(BroadcasterFactory.class.getName(), (Object)this.broadcasterSetup.broadcasterFactory());
            }
            if ((s = this.config.getInitParameter("org.atmosphere.cpr.broadcaster.shareableThreadPool")) != null) {
                this.sharedThreadPools = Boolean.parseBoolean(s);
            }
            this.shutdownHook = new Thread(this::destroy);
            Runtime.getRuntime().addShutdownHook(this.shutdownHook);
            if (logger.isInfoEnabled()) {
                this.info();
            }
            if (this.initializationError != null) {
                logger.trace("ContainerInitalizer exception. May not be an issue if Atmosphere started properly ", (Throwable)this.initializationError);
            }
            this.universe();
        }
        catch (Throwable t) {
            logger.error("Failed to initialize Atmosphere Framework", t);
            if (t instanceof ServletException) {
                ServletException se = (ServletException)t;
                throw se;
            }
            throw new ServletException(t);
        }
        this.isInit = true;
        this.config.initComplete();
        this.onPostInit();
        return this;
    }

    protected void servletConfig(final ServletConfig sc, boolean wrap) {
        if (wrap) {
            String value = sc.getServletContext().getInitParameter("org.atmosphere.cpr.AtmosphereConfig.getInitParameter");
            final boolean useServletContextParameters = Boolean.parseBoolean(value);
            this.servletConfig = new ServletConfig(){
                final AtomicBoolean done = new AtomicBoolean();

                public String getServletName() {
                    return sc.getServletName();
                }

                public ServletContext getServletContext() {
                    return sc.getServletContext();
                }

                public String getInitParameter(String name) {
                    String param = AtmosphereFramework.this.initParams.get(name);
                    if (param == null && (param = sc.getInitParameter(name)) == null && useServletContextParameters) {
                        param = sc.getServletContext().getInitParameter(name);
                    }
                    return param;
                }

                public Enumeration<String> getInitParameterNames() {
                    Enumeration en;
                    if (!this.done.getAndSet(true) && (en = sc.getInitParameterNames()) != null) {
                        while (en.hasMoreElements()) {
                            String name = (String)en.nextElement();
                            if (AtmosphereFramework.this.initParams.containsKey(name)) continue;
                            AtmosphereFramework.this.initParams.put(name, sc.getInitParameter(name));
                        }
                    }
                    return Collections.enumeration(AtmosphereFramework.this.initParams.keySet());
                }
            };
        } else {
            this.servletConfig = sc;
        }
    }

    public void reconfigureInitParams(boolean reconfigureInitParams) {
        if (reconfigureInitParams) {
            this.doInitParams(this.servletConfig, reconfigureInitParams);
            this.doInitParamsForWebSocket(this.servletConfig);
        }
    }

    private void info() {
        FrameworkDiagnostics.info(this);
    }

    protected void universe() {
        Universe.broadcasterFactory(this.broadcasterSetup.broadcasterFactory());
        Universe.resourceFactory(this.broadcasterSetup.arFactory());
        Universe.sessionResourceFactory(this.broadcasterSetup.getSessionFactory());
        Universe.framework(this);
    }

    private void configureAnnotationPackages() {
        this.classpathScanner.configureAnnotationPackages();
    }

    protected void analytics() {
        FrameworkDiagnostics.analytics(this.config);
    }

    protected void configureAtmosphereInterceptor(ServletConfig sc) {
        this.interceptorRegistry.configure(sc);
    }

    protected AtmosphereInterceptor newAInterceptor(Class<? extends AtmosphereInterceptor> a) {
        return this.interceptorRegistry.newInterceptor(a);
    }

    protected void configureWebDotXmlAtmosphereHandler(ServletConfig sc) {
        this.handlerRegistry.configureWebDotXmlAtmosphereHandler(sc);
    }

    protected void configureScanningPackage(ServletConfig sc, String value) {
        this.classpathScanner.configureScanningPackage(sc, value);
    }

    protected void defaultPackagesToScan() {
        this.classpathScanner.defaultPackagesToScan();
    }

    public void configureBroadcasterFactory() {
        this.broadcasterSetup.configureBroadcasterFactory();
    }

    protected void configureBroadcaster() {
        this.broadcasterSetup.configureBroadcaster();
    }

    protected void installAnnotationProcessor(ServletConfig sc) {
        this.classpathScanner.installAnnotationProcessor(sc);
    }

    protected void doInitParamsForWebSocket(ServletConfig sc) {
        this.webSocketConfig.doInitParams(sc);
    }

    protected void doInitParams(ServletConfig sc) {
        this.doInitParams(sc, false);
    }

    protected void doInitParams(ServletConfig sc, boolean reconfigure) {
        String s = sc.getInitParameter("org.atmosphere.useNative");
        if (s != null) {
            this.useNativeImplementation = Boolean.parseBoolean(s);
            if (this.useNativeImplementation) {
                this.isCometSupportSpecified = true;
            }
        }
        if ((s = sc.getInitParameter("org.atmosphere.useBlocking")) != null) {
            this.useBlockingImplementation = Boolean.parseBoolean(s);
            if (this.useBlockingImplementation) {
                this.isCometSupportSpecified = true;
            }
        }
        if ((s = sc.getInitParameter("org.atmosphere.useStream")) != null) {
            this.useStreamForFlushingComments = Boolean.parseBoolean(s);
        }
        s = sc.getInitParameter("org.atmosphere.cpr.asyncSupport");
        if (this.asyncSupport == null && s != null && !reconfigure) {
            this.asyncSupport = new DefaultAsyncSupportResolver(this.config).newCometSupport(s);
            this.isCometSupportSpecified = true;
        }
        this.broadcasterSetup.parseInitParams(sc);
        this.classpathScanner.parseInitParams(sc);
        this.interceptorRegistry.parseInitParams(sc);
        s = sc.getInitParameter("org.atmosphere.cpr.sessionSupport");
        if (s == null) {
            s = sc.getServletContext().getInitParameter("org.atmosphere.cpr.sessionSupport");
        }
        if (s != null || SessionSupport.initializationHint) {
            boolean sessionSupport = Boolean.parseBoolean(s) || SessionSupport.initializationHint;
            this.config.setSupportSession(sessionSupport);
            if (sessionSupport && (sc.getServletContext().getMajorVersion() < 3 || !SessionSupport.initializationHint)) {
                logger.warn("SessionSupport error. Make sure you also define {} as a listener in web.xml, see https://github.com/Atmosphere/atmosphere/wiki/Enabling-HttpSession-Support", (Object)SessionSupport.class.getName());
            }
            this.isSessionSupportSpecified = true;
        }
        if ((s = sc.getInitParameter("org.atmosphere.cpr.removeSessionTimeout")) != null) {
            this.config.setSessionTimeoutRemovalAllowed(Boolean.parseBoolean(s));
        }
        if ((s = sc.getInitParameter("org.atmosphere.throwExceptionOnClonedRequest")) != null) {
            this.config.setThrowExceptionOnCloned(Boolean.parseBoolean(s));
            this.isThrowExceptionOnClonedRequestSpecified = true;
        }
        if ((s = sc.getInitParameter("org.atmosphere.disableOnStateEvent")) != null) {
            this.initParams.put("org.atmosphere.disableOnStateEvent", s);
        } else {
            this.initParams.put("org.atmosphere.disableOnStateEvent", "false");
        }
        s = sc.getInitParameter("org.atmosphere.atmosphereDotXml");
        if (s != null) {
            this.atmosphereDotXmlPath = s;
        }
        if ((s = sc.getInitParameter("org.atmosphere.cpr.metaServicePath")) != null) {
            this.metaServicePath = s;
        }
        if ((s = sc.getInitParameter("org.atmosphere.cpr.mappingRegex")) != null) {
            this.handlerRegistry.mappingRegex(s);
        }
    }

    public void loadConfiguration(ServletConfig sc) throws ServletException {
        try {
            this.classpathScanner.loadConfiguration(sc);
        }
        catch (Throwable t) {
            throw new ServletException(t);
        }
    }

    protected boolean detectSupportedFramework(ServletConfig sc) throws Exception {
        return this.classpathScanner.detectSupportedFramework(sc);
    }

    protected void configureDetectedFramework(ReflectorServletProcessor rsp, boolean isJersey) {
        this.classpathScanner.configureDetectedFramework(rsp, isJersey);
    }

    protected String lookupDefaultBroadcasterType(String defaultB) {
        return this.broadcasterSetup.lookupDefaultBroadcasterType(defaultB);
    }

    boolean autodetectBroadcaster() {
        return this.broadcasterSetup.autodetectBroadcaster();
    }

    protected AtmosphereObjectFactory<?> lookupDefaultObjectFactoryType() {
        if (this.objectFactory != null && !DefaultAtmosphereObjectFactory.class.getName().equals(this.objectFactory.getClass().getName())) {
            return this.objectFactory;
        }
        for (String b : this.objectFactoryType) {
            try {
                Class<?> c = Class.forName(b);
                this.objectFactory = (AtmosphereObjectFactory)c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                break;
            }
            catch (ClassNotFoundException e) {
                logger.trace(e.getMessage() + " not found");
            }
            catch (Exception e) {
                logger.trace("", (Throwable)e);
            }
        }
        if (this.objectFactory == null || DefaultAtmosphereObjectFactory.class.getName().equals(this.objectFactory.getClass().getName())) {
            try {
                IOUtils.loadClass(this.getClass(), "jakarta.inject.Inject");
                this.objectFactory = new InjectableObjectFactory();
            }
            catch (Exception e) {
                logger.trace("jakarta.inject.Inject nor installed. Using DefaultAtmosphereObjectFactory");
                this.objectFactory = new DefaultAtmosphereObjectFactory();
            }
        }
        this.objectFactory.configure(this.config);
        return this.objectFactory;
    }

    public void sessionSupport(boolean sessionSupport) {
        if (!this.isSessionSupportSpecified) {
            this.config.setSupportSession(sessionSupport);
        } else if (!this.config.isSupportSession()) {
            this.config.setSupportSession(sessionSupport);
        }
    }

    public void initAtmosphereHandler(ServletConfig sc) throws ServletException {
        this.initAtmosphereHandler();
    }

    public void initAtmosphereHandler() throws ServletException {
        this.handlerRegistry.initAtmosphereHandler();
    }

    public void checkWebSocketSupportState() {
        this.handlerRegistry.checkWebSocketSupportState();
    }

    public void initWebSocket() {
        this.webSocketConfig.initWebSocket();
    }

    public void initEndpointMapper() {
        this.handlerRegistry.initEndpointMapper();
    }

    protected void closeAtmosphereResource() {
        for (AtmosphereResource r : this.config.resourcesFactory().findAll()) {
            try {
                r.resume().close();
            }
            catch (Exception e) {
                logger.trace("", (Throwable)e);
            }
        }
    }

    public AtmosphereFramework destroy() {
        AsyncSupport<?> asyncSupport;
        if (this.isDestroyed.getAndSet(true)) {
            return this;
        }
        this.onPreDestroy();
        this.closeAtmosphereResource();
        this.destroyInterceptors();
        this.config.destroy();
        this.broadcasterSetup.destroyFactories();
        if (this.asyncSupport != null && (asyncSupport = this.asyncSupport) instanceof AsynchronousProcessor) {
            AsynchronousProcessor ap = (AsynchronousProcessor)asyncSupport;
            ap.shutdown();
        }
        for (Map.Entry entry : this.handlerRegistry.handlers().entrySet()) {
            AtmosphereHandlerWrapper handlerWrapper = (AtmosphereHandlerWrapper)entry.getValue();
            try {
                handlerWrapper.atmosphereHandler().destroy();
            }
            catch (Throwable t) {
                logger.warn("", t);
            }
        }
        WebSocketProcessorFactory.getDefault().destroy();
        ExecutorsFactory.reset(this.config);
        this.resetStates();
        this.onPostDestroy();
        try {
            if (this.shutdownHook != null) {
                Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
                this.shutdownHook = null;
            }
        }
        catch (IllegalStateException ex) {
            logger.trace("", (Throwable)ex);
        }
        this.config.properties().clear();
        return this;
    }

    protected void destroyInterceptors() {
        this.interceptorRegistry.destroyInterceptors(this.handlerRegistry.handlers());
    }

    public AtmosphereFramework resetStates() {
        this.isInit = false;
        this.executeFirstSet = false;
        this.broadcasterSetup.clear();
        this.eventDispatcher.clear();
        this.classpathScanner.clear();
        this.initParams.clear();
        this.handlerRegistry.clear();
        this.objectFactoryType.clear();
        this.interceptorRegistry.clear();
        return this;
    }

    protected void loadMetaService() {
        try {
            Map<String, MetaServiceAction> config = (Map<String, MetaServiceAction>)this.servletConfig.getServletContext().getAttribute(MetaServiceAction.class.getName());
            if (config == null) {
                config = IOUtils.readServiceFile(this.metaServicePath + AtmosphereFramework.class.getName());
            }
            for (Map.Entry action : config.entrySet()) {
                try {
                    Class<?> c = IOUtils.loadClass(AtmosphereFramework.class, (String)action.getKey());
                    ((MetaServiceAction)((Object)action.getValue())).apply(this, c);
                }
                catch (ClassNotFoundException ex) {
                    if (((String)action.getKey()).startsWith(ASYNC_IO)) {
                        logger.trace("Unable to load class {}", (Object)ex.getMessage());
                        continue;
                    }
                    logger.warn("", (Throwable)ex);
                }
            }
        }
        catch (Exception ex) {
            logger.warn("", (Throwable)ex);
        }
    }

    protected void loadAtmosphereDotXml(InputStream stream, ClassLoader c) throws IOException, ServletException {
        if (stream == null) {
            return;
        }
        logger.info("Found Atmosphere Configuration under {}", (Object)this.atmosphereDotXmlPath);
        AtmosphereConfigReader.getInstance().parse(this.config, stream);
        AtmosphereHandler handler = null;
        for (AtmosphereHandlerConfig atmoHandler : this.config.getAtmosphereHandlerConfig()) {
            try {
                Object bc;
                if (!atmoHandler.getClassName().startsWith("@")) {
                    handler = !ReflectorServletProcessor.class.getName().equals(atmoHandler.getClassName()) ? this.newClassInstance(AtmosphereHandler.class, IOUtils.loadClass(this.getClass(), atmoHandler.getClassName())) : this.newClassInstance(AtmosphereHandler.class, ReflectorServletProcessor.class);
                    logger.info("Installed AtmosphereHandler {} mapped to context-path: {}", (Object)handler, (Object)atmoHandler.getContextRoot());
                }
                for (ApplicationConfiguration applicationConfiguration : atmoHandler.getApplicationConfig()) {
                    this.initParams.put(applicationConfiguration.getParamName(), applicationConfiguration.getParamValue());
                }
                for (FrameworkConfiguration frameworkConfiguration : atmoHandler.getFrameworkConfig()) {
                    this.initParams.put(frameworkConfiguration.getParamName(), frameworkConfiguration.getParamValue());
                }
                for (AtmosphereHandlerProperty atmosphereHandlerProperty : atmoHandler.getProperties()) {
                    if (atmosphereHandlerProperty.getValue() != null && atmosphereHandlerProperty.getValue().contains("jersey")) {
                        this.initParams.put("org.atmosphere.disableOnStateEvent", "true");
                        this.useStreamForFlushingComments = true;
                        this.broadcasterSetup.setBroadcasterClassName(this.lookupDefaultBroadcasterType("org.atmosphere.jersey.JerseyBroadcaster"));
                        this.broadcasterSetup.broadcasterFactory().destroy();
                        this.broadcasterSetup.setBroadcasterFactory(null);
                        this.configureBroadcasterFactory();
                        this.configureBroadcaster();
                    }
                    if (handler == null) continue;
                    IntrospectionUtils.setProperty(handler, atmosphereHandlerProperty.getName(), atmosphereHandlerProperty.getValue());
                    IntrospectionUtils.addProperty(handler, atmosphereHandlerProperty.getName(), atmosphereHandlerProperty.getValue());
                }
                this.sessionSupport(Boolean.parseBoolean(atmoHandler.getSupportSession()));
                if (handler == null) continue;
                String broadcasterClass = atmoHandler.getBroadcaster();
                if (broadcasterClass != null) {
                    this.broadcasterSetup.setBroadcasterClassName(broadcasterClass);
                    ClassLoader cl = Thread.currentThread().getContextClassLoader();
                    bc = cl.loadClass(this.broadcasterSetup.broadcasterClassName());
                    this.broadcasterSetup.setBroadcasterFactory(this.newClassInstance(BroadcasterFactory.class, DefaultBroadcasterFactory.class));
                    this.broadcasterSetup.broadcasterFactory().configure((Class<? extends Broadcaster>)bc, this.broadcasterSetup.broadcasterLifeCyclePolicy(), this.config);
                }
                Object t = this.broadcasterSetup.broadcasterFactory().lookup(atmoHandler.getContextRoot(), true);
                AtmosphereHandlerWrapper wrapper = new AtmosphereHandlerWrapper(handler, (Broadcaster)t, this.config);
                this.handlerRegistry.handlers().put(this.handlerRegistry.normalizePath(atmoHandler.getContextRoot()), wrapper);
                bc = atmoHandler.getBroadcasterCache();
                if (bc != null) {
                    this.broadcasterSetup.setBroadcasterCacheClassName((String)bc);
                }
                if (atmoHandler.getAsyncSupport() != null) {
                    this.asyncSupport = (AsyncSupport)c.loadClass(atmoHandler.getAsyncSupport()).getDeclaredConstructor(AtmosphereConfig.class).newInstance(this.config);
                }
                if (atmoHandler.getBroadcastFilterClasses() != null) {
                    this.broadcasterSetup.broadcasterFilters().addAll(atmoHandler.getBroadcastFilterClasses());
                }
                LinkedList<AtmosphereInterceptor> l = new LinkedList<AtmosphereInterceptor>();
                if (atmoHandler.getAtmosphereInterceptorClasses() != null) {
                    for (String a : atmoHandler.getAtmosphereInterceptorClasses()) {
                        try {
                            AtmosphereInterceptor ai = this.newClassInstance(AtmosphereInterceptor.class, IOUtils.loadClass(this.getClass(), a));
                            l.add(ai);
                        }
                        catch (Throwable e) {
                            logger.warn("", e);
                        }
                    }
                }
                this.addInterceptorToWrapper(wrapper, l);
                if (l.isEmpty()) continue;
                logger.info("Installed AtmosphereInterceptor {} mapped to AtmosphereHandler {}", l, (Object)atmoHandler.getClassName());
            }
            catch (Throwable t) {
                logger.warn("Unable to load AtmosphereHandler class: " + atmoHandler.getClassName(), t);
                throw new ServletException(t);
            }
        }
    }

    public AtmosphereFramework setAsyncSupport(AsyncSupport<?> asyncSupport) {
        this.asyncSupport = asyncSupport;
        return this;
    }

    public AsyncSupport<?> getAsyncSupport() {
        return this.asyncSupport;
    }

    protected AsyncSupportResolver createAsyncSupportResolver() {
        return new DefaultAsyncSupportResolver(this.config);
    }

    protected void autoDetectContainer() {
        if (this.getAsyncSupport() == null) {
            this.setAsyncSupport(this.createAsyncSupportResolver().resolve(this.useNativeImplementation, this.useBlockingImplementation, this.webSocketConfig.isUseServlet30()));
        }
    }

    public void autoDetectAtmosphereHandlers(ServletContext servletContext, ClassLoader classloader) throws MalformedURLException {
        this.classpathScanner.autoDetectAtmosphereHandlers(servletContext, classloader);
    }

    public void loadAtmosphereHandlersFromPath(ClassLoader classloader, String realPath) {
        this.classpathScanner.loadAtmosphereHandlersFromPath(classloader, realPath);
    }

    protected void autoDetectWebSocketHandler(ServletContext servletContext, ClassLoader classloader) throws MalformedURLException {
        this.classpathScanner.autoDetectWebSocketHandler(servletContext, classloader);
    }

    protected void loadWebSocketFromPath(ClassLoader classloader, String realPath) {
        this.classpathScanner.loadWebSocketFromPath(classloader, realPath);
    }

    public AtmosphereFramework configureRequestResponse(AtmosphereRequest req, AtmosphereResponse res) throws UnsupportedEncodingException {
        String unique;
        req.setAttribute("org.atmosphere.useStream", this.useStreamForFlushingComments);
        req.setAttribute("org.atmosphere.cpr.broadcasterClass", this.broadcasterSetup.broadcasterClassName());
        req.setAttribute(FrameworkConfig.ATMOSPHERE_CONFIG, this.config);
        req.setAttribute(FrameworkConfig.THROW_EXCEPTION_ON_CLONED_REQUEST, "" + this.config.isThrowExceptionOnCloned());
        boolean skip = true;
        String s = this.config.getInitParameter("org.atmosphere.cpr.allowQueryStreamAsPostOrGet");
        if (s != null) {
            skip = Boolean.parseBoolean(s);
        }
        if (!skip || req.getAttribute(WebSocket.WEBSOCKET_SUSPEND) == null) {
            Map<String, String> headers = this.configureQueryStringAsRequest(req);
            String body = headers.remove("X-Atmosphere-Post-Body");
            if (body != null && body.isEmpty()) {
                body = null;
            }
            req.headers(headers).method(body != null && req.getMethod().equalsIgnoreCase("GET") ? "POST" : req.getMethod());
            if (body != null) {
                req.body(URLDecoder.decode(body, req.getCharacterEncoding() == null ? "UTF-8" : req.getCharacterEncoding()));
            }
        }
        if (((s = req.getHeader("X-Atmosphere-tracking-id")) == null || s.equals("0")) && Boolean.parseBoolean(unique = this.config.getInitParameter("org.atmosphere.cpr.AtmosphereResource.uniqueUUID"))) {
            s = (String)req.getAttribute("org.atmosphere.cpr.AtmosphereResource.suspended.uuid");
        }
        if (s == null || s.equals("0")) {
            s = this.config.uuidProvider().generateUuid();
            res.setHeader("X-Atmosphere-first-request", "true");
            res.setHeader("X-Atmosphere-tracking-id", s);
            String contentType = this.config.getInitParameter("org.atmosphere.cpr.contentTypeFirstResponse");
            if (contentType != null) {
                res.setHeader("Content-Type", contentType);
            }
        } else if (req.resource() == null) {
            res.setHeader("X-Atmosphere-tracking-id", s);
        } else if (req.getAttribute(WebSocket.WEBSOCKET_INITIATED) == null) {
            res.setHeader("X-Atmosphere-tracking-id", s);
        }
        if (req.getAttribute("org.atmosphere.cpr.AtmosphereResource.suspended.uuid") == null) {
            req.setAttribute("org.atmosphere.cpr.AtmosphereResource.suspended.uuid", s);
        }
        return this;
    }

    public Action doCometSupport(AtmosphereRequest req, AtmosphereResponse res) throws IOException, ServletException {
        if (this.isDestroyed.get()) {
            return Action.CANCELLED;
        }
        Action a = null;
        try {
            this.configureRequestResponse(req, res);
            a = this.asyncSupport.service(req, res);
        }
        catch (IllegalStateException ex) {
            logger.error("AtmosphereFramework exception", (Throwable)ex);
            throw ex;
        }
        finally {
            if (a != null) {
                this.notify(a.type(), req, res);
            }
            if (!this.externalizeDestroy && req != null && a != null && a.type() != Action.TYPE.SUSPEND) {
                req.destroy();
                res.destroy();
                this.notify(Action.TYPE.DESTROYED, req, res);
            }
        }
        return a;
    }

    public String getDefaultBroadcasterClassName() {
        return this.broadcasterSetup.broadcasterClassName();
    }

    public AtmosphereFramework setDefaultBroadcasterClassName(String bccn) {
        if (this.broadcasterSetup.isBroadcasterSpecified()) {
            logger.trace("Broadcaster {} already set in web.xml", (Object)this.broadcasterSetup.broadcasterClassName());
            return this;
        }
        this.broadcasterSetup.setBroadcasterSpecified(true);
        this.broadcasterSetup.setBroadcasterClassName(bccn);
        this.broadcasterSetup.setBroadcasterFactory(null);
        this.configureBroadcasterFactory();
        for (AtmosphereHandlerWrapper w : this.handlerRegistry.handlers().values()) {
            if (w.broadcaster() == null) continue;
            w.setBroadcaster((Broadcaster)this.broadcasterSetup.broadcasterFactory().lookup(w.broadcaster().getID(), true));
        }
        return this;
    }

    public boolean isUseStreamForFlushingComments() {
        return this.useStreamForFlushingComments;
    }

    public boolean isUseServlet30() {
        return this.webSocketConfig.isUseServlet30();
    }

    public AtmosphereFramework setUseStreamForFlushingComments(boolean useStreamForFlushingComments) {
        this.useStreamForFlushingComments = useStreamForFlushingComments;
        return this;
    }

    public BroadcasterFactory getBroadcasterFactory() {
        if (this.broadcasterSetup.broadcasterFactory() == null) {
            this.configureBroadcasterFactory();
        }
        return this.broadcasterSetup.broadcasterFactory();
    }

    public AtmosphereFramework setBroadcasterFactory(BroadcasterFactory broadcasterFactory) {
        this.broadcasterSetup.setBroadcasterFactory(broadcasterFactory);
        this.configureBroadcaster();
        return this;
    }

    public String getBroadcasterCacheClassName() {
        return this.broadcasterSetup.broadcasterCacheClassName();
    }

    public AtmosphereFramework setBroadcasterCacheClassName(String broadcasterCacheClassName) {
        this.broadcasterSetup.setBroadcasterCacheClassName(broadcasterCacheClassName);
        return this;
    }

    public AtmosphereFramework addBroadcasterType(String broadcasterTypeString) {
        this.broadcasterSetup.broadcasterTypes().add(broadcasterTypeString);
        return this;
    }

    public ConcurrentLinkedQueue<String> broadcasterTypes() {
        return this.broadcasterSetup.broadcasterTypes();
    }

    public String getWebSocketProtocolClassName() {
        return this.webSocketConfig.getProtocolClassName();
    }

    public AtmosphereFramework setWebSocketProtocolClassName(String webSocketProtocolClassName) {
        this.webSocketConfig.setProtocolClassName(webSocketProtocolClassName);
        return this;
    }

    public Map<String, AtmosphereHandlerWrapper> getAtmosphereHandlers() {
        return this.handlerRegistry.handlers();
    }

    protected Map<String, String> configureQueryStringAsRequest(AtmosphereRequest request) {
        HashMap<String, String> headers = new HashMap<String, String>();
        StringBuilder q = new StringBuilder();
        try {
            String qs = request.getQueryString();
            if (qs != null && !qs.isEmpty()) {
                String[] params;
                for (String p : params = qs.split("&")) {
                    String value;
                    String[] s = p.split("=", 2);
                    String header = s[0];
                    String string = value = s.length > 1 ? s[1] : "";
                    if (header.equalsIgnoreCase("Content-Type") && (request.getContentType() == null || !request.getContentType().equalsIgnoreCase(s.length > 1 ? value : ""))) {
                        request.contentType(s.length > 1 ? URLDecoder.decode(value, "UTF-8") : "");
                    }
                    if (!(header.isEmpty() || header.toLowerCase().startsWith("x-atmo") || header.equalsIgnoreCase("X-Heartbeat-Server") || header.equalsIgnoreCase("Content-Type") || header.equalsIgnoreCase("_"))) {
                        q.append(header).append("=").append(s.length > 1 ? value : "").append("&");
                    }
                    headers.put(header, s.length > 1 ? value : "");
                }
            }
        }
        catch (Exception ex) {
            logger.error("Unable to parse query string", (Throwable)ex);
        }
        String disallowModifyQueryString = this.config.getInitParameter("org.atmosphere.cpr.disallowModifyQueryString");
        if (disallowModifyQueryString == null || disallowModifyQueryString.isEmpty() || "false".equalsIgnoreCase(disallowModifyQueryString)) {
            if (q.length() > 0) {
                q.deleteCharAt(q.length() - 1);
            }
            request.queryString(q.toString());
        }
        logger.trace("Query String translated to headers {}", headers);
        return headers;
    }

    public WebSocketProtocol getWebSocketProtocol() {
        return this.webSocketConfig.getProtocol();
    }

    public boolean isUseNativeImplementation() {
        return this.useNativeImplementation;
    }

    public AtmosphereFramework setUseNativeImplementation(boolean useNativeImplementation) {
        this.useNativeImplementation = useNativeImplementation;
        return this;
    }

    public boolean isUseBlockingImplementation() {
        return this.useBlockingImplementation;
    }

    public AtmosphereFramework setUseBlockingImplementation(boolean useBlockingImplementation) {
        this.useBlockingImplementation = useBlockingImplementation;
        return this;
    }

    public String getAtmosphereDotXmlPath() {
        return this.atmosphereDotXmlPath;
    }

    public AtmosphereFramework setAtmosphereDotXmlPath(String atmosphereDotXmlPath) {
        this.atmosphereDotXmlPath = atmosphereDotXmlPath;
        return this;
    }

    public String getHandlersPath() {
        return this.classpathScanner.handlersPath();
    }

    public AtmosphereFramework setHandlersPath(String handlersPath) {
        this.classpathScanner.setHandlersPath(handlersPath);
        return this;
    }

    public String getLibPath() {
        return this.classpathScanner.libPath();
    }

    public AtmosphereFramework setLibPath(String libPath) {
        this.classpathScanner.setLibPath(libPath);
        return this;
    }

    public String getWebSocketProcessorClassName() {
        return this.webSocketConfig.getProcessorClassName();
    }

    public AtmosphereFramework setWebsocketProcessorClassName(String webSocketProcessorClassName) {
        this.webSocketConfig.setProcessorClassName(webSocketProcessorClassName);
        return this;
    }

    public AtmosphereFramework interceptor(AtmosphereInterceptor c) {
        this.interceptorRegistry.addInterceptor(c, this.isInit);
        return this;
    }

    protected void addDefaultOrAppInterceptors() {
        this.interceptorRegistry.addDefaultOrAppInterceptors();
    }

    protected void addInterceptorToAllWrappers(AtmosphereInterceptor c) {
        this.interceptorRegistry.addInterceptorToAllWrappers(c);
    }

    protected void addInterceptorToWrapper(AtmosphereHandlerWrapper wrapper, AtmosphereInterceptor c) {
        this.interceptorRegistry.addInterceptorToWrapper(wrapper, c);
    }

    protected void addInterceptorToWrapper(AtmosphereHandlerWrapper wrapper, List<AtmosphereInterceptor> interceptors) {
        this.interceptorRegistry.addInterceptorToWrapper(wrapper, interceptors);
    }

    public LinkedList<AtmosphereInterceptor> interceptors() {
        return this.interceptorRegistry.interceptors();
    }

    @Deprecated(since="4.0.0", forRemoval=false)
    public <T extends AtmosphereInterceptor> T interceptor(Class<T> c) {
        return this.interceptorRegistry.interceptor(c);
    }

    public <T extends AtmosphereInterceptor> Optional<T> findInterceptor(Class<T> c) {
        return this.interceptorRegistry.findInterceptor(c);
    }

    public AtmosphereFramework annotationProcessorClassName(String annotationProcessorClassName) {
        this.classpathScanner.setAnnotationProcessorClassName(annotationProcessorClassName);
        return this;
    }

    public FrameworkEventDispatcher events() {
        return this.eventDispatcher;
    }

    public WebSocketConfig webSocket() {
        return this.webSocketConfig;
    }

    public InterceptorRegistry interceptorRegistry() {
        return this.interceptorRegistry;
    }

    public HandlerRegistry handlerRegistry() {
        return this.handlerRegistry;
    }

    public AtmosphereFramework asyncSupportListener(AsyncSupportListener asyncSupportListener) {
        this.eventDispatcher.addAsyncSupportListener(asyncSupportListener);
        return this;
    }

    public List<AsyncSupportListener> asyncSupportListeners() {
        return this.eventDispatcher.asyncSupportListeners();
    }

    public AtmosphereFramework addBroadcasterListener(BroadcasterListener b) {
        this.broadcasterSetup.broadcasterFactory().addBroadcasterListener(b);
        this.broadcasterSetup.broadcasterListeners().add(b);
        return this;
    }

    public AtmosphereFramework addBroadcasterCacheListener(BroadcasterCacheListener b) {
        this.broadcasterSetup.broadcasterCacheListeners().add(b);
        return this;
    }

    public List<BroadcasterCacheListener> broadcasterCacheListeners() {
        return this.broadcasterSetup.broadcasterCacheListeners();
    }

    public AtmosphereFramework addBroadcasterCacheInjector(BroadcasterCacheInspector b) {
        this.broadcasterSetup.inspectors().add(b);
        return this;
    }

    public ConcurrentLinkedQueue<BroadcasterCacheInspector> inspectors() {
        return this.broadcasterSetup.inspectors();
    }

    public AtmosphereConfig getAtmosphereConfig() {
        return this.config;
    }

    public ServletContext getServletContext() {
        return this.servletConfig.getServletContext();
    }

    public ServletConfig getServletConfig() {
        return this.servletConfig;
    }

    public List<String> broadcasterFilters() {
        return this.broadcasterSetup.broadcasterFilters();
    }

    public AtmosphereFramework broadcasterFilters(BroadcastFilter f) {
        this.broadcasterSetup.broadcasterFilters().add(f.getClass().getName());
        for (Broadcaster b : this.config.getBroadcasterFactory().lookupAll()) {
            b.getBroadcasterConfig().addFilter(f);
        }
        return this;
    }

    public boolean isShareExecutorServices() {
        return this.sharedThreadPools;
    }

    public AtmosphereFramework shareExecutorServices(boolean sharedThreadPools) {
        this.sharedThreadPools = sharedThreadPools;
        return this;
    }

    protected void autoConfigureService(ServletContext sc) throws IOException {
        this.classpathScanner.autoConfigureService(sc);
    }

    public EndpointMapper<AtmosphereHandlerWrapper> endPointMapper() {
        return this.handlerRegistry.endPointMapper();
    }

    public AtmosphereFramework endPointMapper(EndpointMapper<?> endpointMapper) {
        this.handlerRegistry.endPointMapper(endpointMapper);
        return this;
    }

    public AtmosphereFramework addAnnotationPackage(Class<?> clazz) {
        if (clazz.getPackage() == null) {
            logger.error("Class {} must have a package defined", clazz);
        } else {
            this.classpathScanner.packages().add(clazz.getPackage().getName());
        }
        return this;
    }

    public AtmosphereFramework notify(Action.TYPE type, AtmosphereRequest request, AtmosphereResponse response) {
        this.eventDispatcher.notify(type, request, response);
        return this;
    }

    public AtmosphereFramework notifyDestroyed(String uuid) {
        this.eventDispatcher.notifyDestroyed(uuid);
        return this;
    }

    public AtmosphereFramework notifySuspended(String uuid) {
        this.eventDispatcher.notifySuspended(uuid);
        return this;
    }

    public AtmosphereFramework addWebSocketHandler(WebSocketHandler handler) {
        this.handlerRegistry.addWebSocketHandler(handler);
        return this;
    }

    public AtmosphereFramework addWebSocketHandler(String path, WebSocketHandler handler) {
        this.handlerRegistry.addWebSocketHandler(path, handler);
        return this;
    }

    public AtmosphereFramework addWebSocketHandler(String path, WebSocketHandler handler, AtmosphereHandler h) {
        this.handlerRegistry.addWebSocketHandler(path, handler, h);
        return this;
    }

    public AtmosphereFramework addWebSocketHandler(String path, WebSocketHandler handler, AtmosphereHandler h, List<AtmosphereInterceptor> l) {
        this.handlerRegistry.addWebSocketHandler(path, handler, h, l);
        return this;
    }

    public AtmosphereFramework annotationScanned(boolean b) {
        this.classpathScanner.setAnnotationFound(b);
        return this;
    }

    public boolean initialized() {
        return this.isInit;
    }

    public List<String> packages() {
        return this.classpathScanner.packages();
    }

    public List<String> customAnnotationPackages() {
        return this.classpathScanner.annotationPackages();
    }

    public AtmosphereFramework addCustomAnnotationPackage(Class<?> p) {
        this.classpathScanner.annotationPackages().addLast(p.getPackage().getName());
        return this;
    }

    public <T, U extends T> T newClassInstance(Class<T> classType, Class<U> defaultType) throws InstantiationException, IllegalAccessException {
        return this.objectFactory.newClassInstance(classType, defaultType);
    }

    public void objectFactory(AtmosphereObjectFactory<?> objectFactory) {
        this.objectFactory = objectFactory;
        this.objectFactory.configure(this.config);
    }

    public AtmosphereFramework externalizeDestroy(boolean externalizeDestroy) {
        this.externalizeDestroy = externalizeDestroy;
        return this;
    }

    public AnnotationProcessor annotationProcessor() {
        return this.classpathScanner.annotationProcessor();
    }

    public boolean isBroadcasterSpecified() {
        return this.broadcasterSetup.isBroadcasterSpecified();
    }

    protected void configureObjectFactory() {
        String s = this.config.getInitParameter("org.atmosphere.cpr.objectFactory");
        if (s != null) {
            try {
                AtmosphereObjectFactory aci = (AtmosphereObjectFactory)IOUtils.loadClass(this.getClass(), s).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                logger.debug("Found ObjectFactory {}", (Object)aci.getClass().getName());
                this.objectFactory(aci);
            }
            catch (Exception ex) {
                logger.warn("Unable to load AtmosphereClassInstantiator instance", (Throwable)ex);
            }
        }
        if (!(this.objectFactory instanceof DefaultAtmosphereObjectFactory)) {
            logger.trace("ObjectFactory already set to {}", this.objectFactory);
        }
    }

    public AtmosphereFramework excludeInterceptor(String interceptor) {
        this.interceptorRegistry.excludeInterceptor(interceptor);
        return this;
    }

    public AtmosphereFramework filterManipulator(BroadcasterConfig.FilterManipulator m) {
        this.broadcasterSetup.filterManipulators().add(m);
        return this;
    }

    public List<BroadcasterConfig.FilterManipulator> filterManipulators() {
        return this.broadcasterSetup.filterManipulators();
    }

    public boolean isAServletFilter() {
        return this.isFilter;
    }

    public ConcurrentLinkedQueue<String> objectFactoryType() {
        return this.objectFactoryType;
    }

    public String mappingRegex() {
        return this.handlerRegistry.mappingRegex();
    }

    public AtmosphereFramework mappingRegex(String mappingRegex) {
        this.handlerRegistry.mappingRegex(mappingRegex);
        return this;
    }

    public void setUseServlet30(boolean useServlet30) {
        this.webSocketConfig.setUseServlet30(useServlet30);
    }

    public boolean webSocketEnabled() {
        return this.webSocketConfig.isEnabled();
    }

    public AtmosphereFramework webSocketEnabled(boolean webSocketEnabled) {
        this.webSocketConfig.setEnabled(webSocketEnabled);
        return this;
    }

    public String broadcasterLifeCyclePolicy() {
        return this.broadcasterSetup.broadcasterLifeCyclePolicy();
    }

    public AtmosphereFramework broadcasterLifeCyclePolicy(String broadcasterLifeCyclePolicy) {
        this.broadcasterSetup.setBroadcasterLifeCyclePolicy(broadcasterLifeCyclePolicy);
        return this;
    }

    public List<BroadcasterListener> broadcasterListeners() {
        return this.broadcasterSetup.broadcasterListeners();
    }

    public boolean sharedThreadPools() {
        return this.sharedThreadPools;
    }

    public AtmosphereFramework sharedThreadPools(boolean sharedThreadPools) {
        this.sharedThreadPools = sharedThreadPools;
        return this;
    }

    public boolean allowAllClassesScan() {
        return this.classpathScanner.allowAllClassesScan();
    }

    public AtmosphereFramework allowAllClassesScan(boolean allowAllClassesScan) {
        this.classpathScanner.setAllowAllClassesScan(allowAllClassesScan);
        return this;
    }

    public AtmosphereObjectFactory<?> objectFactory() {
        return this.objectFactory;
    }

    public boolean externalizeDestroy() {
        return this.externalizeDestroy;
    }

    public List<String> excludedInterceptors() {
        return this.interceptorRegistry.excludedInterceptors();
    }

    public Class<? extends AtmosphereInterceptor>[] defaultInterceptors() {
        return this.interceptorRegistry.defaultInterceptors();
    }

    public AtmosphereResourceFactory atmosphereFactory() {
        return this.broadcasterSetup.getOrCreateAtmosphereFactory();
    }

    private AtmosphereFramework configureAtmosphereResourceFactory() {
        this.broadcasterSetup.configureAtmosphereResourceFactory();
        return this;
    }

    public MetaBroadcaster metaBroadcaster() {
        return this.broadcasterSetup.metaBroadcaster();
    }

    private AtmosphereFramework configureMetaBroadcaster() {
        this.broadcasterSetup.configureMetaBroadcaster();
        return this;
    }

    public String getDefaultSerializerClassName() {
        return this.broadcasterSetup.defaultSerializerClassName();
    }

    public Class<Serializer> getDefaultSerializerClass() {
        return this.broadcasterSetup.defaultSerializerClass();
    }

    public AtmosphereFramework setDefaultSerializerClassName(String defaultSerializerClassName) {
        this.broadcasterSetup.setDefaultSerializerClassName(defaultSerializerClassName);
        this.initDefaultSerializer();
        return this;
    }

    private void initDefaultSerializer() {
        this.broadcasterSetup.initDefaultSerializer();
    }

    public AtmosphereResourceSessionFactory sessionFactory() {
        return this.broadcasterSetup.getOrCreateSessionFactory();
    }

    public boolean isDestroyed() {
        return this.isDestroyed.get();
    }

    public AtmosphereFramework frameworkListener(AtmosphereFrameworkListener l) {
        this.eventDispatcher.addFrameworkListener(l);
        return this;
    }

    public List<AtmosphereFrameworkListener> frameworkListeners() {
        return this.eventDispatcher.frameworkListeners();
    }

    protected void onPreInit() {
        this.eventDispatcher.onPreInit(this);
    }

    protected void onPostInit() {
        this.eventDispatcher.onPostInit(this);
    }

    protected void onPreDestroy() {
        this.eventDispatcher.onPreDestroy(this);
    }

    protected void onPostDestroy() {
        this.eventDispatcher.onPostDestroy(this);
    }

    public List<AtmosphereResourceListener> atmosphereResourceListeners() {
        return this.eventDispatcher.atmosphereResourceListeners();
    }

    public AtmosphereFramework atmosphereResourceListener(AtmosphereResourceListener atmosphereResourceListener) {
        this.eventDispatcher.addAtmosphereResourceListener(atmosphereResourceListener);
        return this;
    }

    public AtmosphereFramework uuidProvider(UUIDProvider uuidProvider) {
        this.uuidProvider = uuidProvider;
        return this;
    }

    public UUIDProvider uuidProvider() {
        return this.uuidProvider;
    }

    public WebSocketFactory webSocketFactory() {
        return this.webSocketConfig.getFactory();
    }

    public AtmosphereFramework webSocketFactory(WebSocketFactory webSocketFactory) {
        this.webSocketConfig.setFactory(webSocketFactory);
        return this;
    }

    public void initializationError(IllegalStateException initializationError) {
        this.initializationError = initializationError;
    }
}

