/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.atmosphere.annotation.Processor;
import org.atmosphere.config.AtmosphereAnnotation;
import org.atmosphere.cpr.AtmosphereFramework;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotationHandler {
    private static final Logger logger = LoggerFactory.getLogger(AnnotationHandler.class);
    private final Map<Class<? extends Annotation>, Class<? extends Processor<?>>> annotations = new HashMap();
    private final Map<Class<? extends Processor<?>>, Processor<?>> processors = new HashMap();

    public AnnotationHandler flushCoreAnnotations(Set<Class<?>> classes) {
        ArrayList<Class<? extends Annotation>> l = new ArrayList<Class<? extends Annotation>>();
        for (Map.Entry<Class<Annotation>, Class<Processor<?>>> entry : this.annotations.entrySet()) {
            if (!entry.getValue().getPackage().getName().equals("org.atmosphere.annotation") || !classes.contains(entry.getValue())) continue;
            l.add(entry.getKey());
        }
        for (Class clazz : l) {
            this.annotations.remove(clazz);
        }
        return this;
    }

    public Class<? extends Processor<?>> handleProcessor(Class<?> clazz) {
        if (Processor.class.isAssignableFrom(clazz)) {
            Class<?> p = clazz;
            if (logger.isTraceEnabled()) {
                logger.trace("Processor {} associated with {}", p, p.getAnnotation(AtmosphereAnnotation.class).value());
            }
            this.annotations.put(p.getAnnotation(AtmosphereAnnotation.class).value(), p);
            return p;
        }
        return null;
    }

    public Class<? extends Annotation>[] handledClass() {
        Set<Class<? extends Annotation>> c = this.annotations.keySet();
        return c.toArray(new Class[0]);
    }

    public AnnotationHandler handleAnnotation(AtmosphereFramework framework, Class<? extends Annotation> annotation, Class<?> discoveredClass) {
        logger.info("Found Annotation in {} being scanned: {}", discoveredClass, annotation);
        framework.annotationScanned(true);
        Class<? extends Processor<?>> a = this.annotations.get(annotation);
        if (a != null) {
            Processor p = this.processors.get(a);
            if (p == null) {
                try {
                    p = framework.newClassInstance(Processor.class, a);
                }
                catch (Exception e) {
                    logger.warn("Unable to create Processor {}", (Object)p);
                }
                this.processors.put(a, p);
            }
            p.handle(framework, discoveredClass);
            logger.trace("Annotation {} handled by {}", annotation, (Object)p.getClass().getName());
        } else {
            logger.trace("Annotation {} unhandled", annotation);
        }
        return this;
    }

    public void destroy() {
        this.annotations.clear();
        this.processors.clear();
    }
}

