/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.container;

import jakarta.servlet.AsyncContext;
import jakarta.servlet.AsyncEvent;
import jakarta.servlet.AsyncListener;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.AsyncSupport;
import org.atmosphere.cpr.AsynchronousProcessor;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Servlet30CometSupport
extends AsynchronousProcessor {
    private static final Logger logger = LoggerFactory.getLogger(Servlet30CometSupport.class);

    public Servlet30CometSupport(AtmosphereConfig config) {
        super(config);
    }

    @Override
    public String getContainerName() {
        return super.getContainerName() + " using jakarta.servlet/3.0";
    }

    @Override
    public Action service(AtmosphereRequest request, AtmosphereResponse response) throws IOException, ServletException {
        Action nextAction;
        Action action = this.suspended(request, response);
        if (action.type() == Action.TYPE.SUSPEND) {
            this.suspend(action, request, response);
        } else if (action.type() == Action.TYPE.RESUME && (nextAction = this.resumed(request, response)).type() == Action.TYPE.SUSPEND) {
            this.suspend(action, request, response);
        }
        return action;
    }

    private void suspend(Action action, AtmosphereRequest req, AtmosphereResponse res) {
        if (!req.isAsyncStarted() && !Utils.webSocketEnabled(req)) {
            AsyncContext asyncContext = req.startAsync((ServletRequest)req, (ServletResponse)res);
            asyncContext.addListener((AsyncListener)new CometListener(this, res.uuid()));
            if (action.timeout() != -1L) {
                asyncContext.setTimeout(action.timeout());
            } else {
                asyncContext.setTimeout(Integer.MAX_VALUE);
            }
            req.setAttribute("org.atmosphere.container.asyncContext", asyncContext);
        }
    }

    @Override
    public void action(AtmosphereResourceImpl r) {
        super.action(r);
        if (r.action().type() == Action.TYPE.RESUME && r.isInScope()) {
            this.endAsyncContext(r.getRequest(false));
        }
    }

    @Override
    public AsyncSupport<AtmosphereResourceImpl> complete(AtmosphereResourceImpl r) {
        this.endAsyncContext(r.getRequest(false));
        return null;
    }

    public void endAsyncContext(AtmosphereRequest request) {
        Object attribute = null;
        try {
            attribute = request.getAttribute("org.atmosphere.container.asyncContext");
        }
        catch (Exception e) {
            logger.warn("Exception occurred in getting attribute from request object", (Throwable)e);
        }
        if (attribute instanceof AsyncContext) {
            AsyncContext asyncContext = (AsyncContext)attribute;
            try {
                asyncContext.complete();
            }
            catch (IllegalStateException ex) {
                try {
                    logger.trace("Already resumed!", (Throwable)ex);
                }
                catch (Exception ex2) {
                    logger.trace("", (Throwable)ex2);
                }
            }
        }
    }

    @Override
    public Action cancelled(AtmosphereRequest req, AtmosphereResponse res) throws IOException, ServletException {
        Action action = super.cancelled(req, res);
        if (req.getAttribute("org.atmosphere.cpr.CometSupport.maxInactiveActivity") != null && (Long)req.getAttribute("org.atmosphere.cpr.CometSupport.maxInactiveActivity") == -1L) {
            this.endAsyncContext(req);
        }
        return action;
    }

    private static final class CometListener
    implements AsyncListener {
        private final AsynchronousProcessor p;
        private final String uuid;

        public CometListener() {
            this.uuid = "-1";
            this.p = null;
        }

        public CometListener(AsynchronousProcessor processor, String uuid) {
            this.p = processor;
            this.uuid = uuid;
        }

        public void onComplete(AsyncEvent event) {
            logger.trace("Resumed (completed): event: {}", (Object)this.uuid);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onTimeout(AsyncEvent event) throws IOException {
            logger.trace("onTimeout(): event: {}", (Object)event.getAsyncContext().getRequest());
            if (this.p == null) {
                logger.error("Invalid state - CometListener");
                return;
            }
            AsyncContext asyncContext = event.getAsyncContext();
            try {
                this.p.timedout((AtmosphereRequest)asyncContext.getRequest(), (AtmosphereResponse)asyncContext.getResponse());
            }
            catch (ServletException ex) {
                logger.warn("onTimeout(): failed timing out comet response: " + String.valueOf(event.getAsyncContext().getResponse()), (Throwable)ex);
            }
            finally {
                try {
                    asyncContext.complete();
                }
                catch (IllegalStateException ex) {
                    logger.trace("", (Throwable)ex);
                }
            }
        }

        public void onError(AsyncEvent event) {
            logger.trace("onError(): event: {}", (Object)event.getAsyncContext().getResponse());
            if (this.p == null) {
                logger.error("Invalid state - CometListener");
                return;
            }
            try {
                this.p.cancelled((AtmosphereRequest)event.getAsyncContext().getRequest(), (AtmosphereResponse)event.getAsyncContext().getResponse());
            }
            catch (Throwable ex) {
                logger.warn("failed cancelling comet response: " + String.valueOf(event.getAsyncContext().getResponse()), ex);
            }
        }

        public void onStartAsync(AsyncEvent event) {
            logger.trace("onStartAsync(): event: {}", (Object)event.getAsyncContext().getResponse());
        }
    }
}

