/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.config.managed;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;

public final class TypeResolver {
    private static final Map<Class<?>, Reference<Map<TypeVariable<?>, Type>>> typeVariableCache = Collections.synchronizedMap(new WeakHashMap());
    private static boolean cacheEnabled = true;

    private TypeResolver() {
    }

    public static void enableCache() {
        cacheEnabled = true;
    }

    public static void disableCache() {
        typeVariableCache.clear();
        cacheEnabled = false;
    }

    public static <T, I extends T> Class<?> resolveArgument(Class<I> initialType, Class<T> targetType) {
        return TypeResolver.resolveArgument(TypeResolver.resolveGenericType(initialType, targetType), initialType);
    }

    public static Class<?> resolveArgument(Type genericType, Class<?> targetType) {
        Class<?>[] arguments = TypeResolver.resolveArguments(genericType, targetType);
        if (arguments == null) {
            return Unknown.class;
        }
        if (arguments.length != 1) {
            throw new IllegalArgumentException("Expected 1 type argument on generic type " + targetType.getName() + " but found " + arguments.length);
        }
        return arguments[0];
    }

    public static <T, I extends T> Class<?>[] resolveArguments(Class<I> initialType, Class<T> targetType) {
        return TypeResolver.resolveArguments(TypeResolver.resolveGenericType(initialType, targetType), initialType);
    }

    public static Class<?>[] resolveArguments(Type genericType, Class<?> targetType) {
        Class[] result = null;
        if (genericType instanceof ParameterizedType) {
            ParameterizedType paramType = (ParameterizedType)genericType;
            Type[] arguments = paramType.getActualTypeArguments();
            result = new Class[arguments.length];
            for (int i = 0; i < arguments.length; ++i) {
                result[i] = TypeResolver.resolveClass(arguments[i], targetType);
            }
        } else if (genericType instanceof TypeVariable) {
            result = new Class[]{TypeResolver.resolveClass(genericType, targetType)};
        }
        return result;
    }

    public static Type resolveGenericType(Type initialType, Class<?> targetType) {
        Type superType;
        Type result;
        Class rawType;
        if (initialType instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)initialType;
            rawType = (Class)pt.getRawType();
        } else {
            rawType = (Class)initialType;
        }
        if (targetType.equals(rawType)) {
            return initialType;
        }
        if (targetType.isInterface()) {
            for (Type superInterface : rawType.getGenericInterfaces()) {
                if (superInterface == null || superInterface.equals(Object.class) || (result = TypeResolver.resolveGenericType(superInterface, targetType)) == null) continue;
                return result;
            }
        }
        if ((superType = rawType.getGenericSuperclass()) != null && !superType.equals(Object.class) && (result = TypeResolver.resolveGenericType(superType, targetType)) != null) {
            return result;
        }
        return null;
    }

    public static Class<?> resolveClass(Type genericType, Class<?> targetType) {
        Class c;
        if (genericType instanceof Class) {
            Class c2 = genericType;
            return c2;
        }
        if (genericType instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)genericType;
            return TypeResolver.resolveClass(pt.getRawType(), targetType);
        }
        if (genericType instanceof GenericArrayType) {
            GenericArrayType arrayType = (GenericArrayType)genericType;
            Class<?> compoment = TypeResolver.resolveClass(arrayType.getGenericComponentType(), targetType);
            return Array.newInstance(compoment, 0).getClass();
        }
        if (genericType instanceof TypeVariable) {
            TypeVariable variable = (TypeVariable)genericType;
            genericType = TypeResolver.getTypeVariableMap(targetType).get(variable);
            genericType = genericType == null ? TypeResolver.resolveBound(variable) : TypeResolver.resolveClass(genericType, targetType);
        }
        return genericType instanceof Class ? (c = (Class)genericType) : Unknown.class;
    }

    private static Map<TypeVariable<?>, Type> getTypeVariableMap(Class<?> targetType) {
        Map<TypeVariable<?>, Type> map;
        Reference<Map<TypeVariable<?>, Type>> ref = typeVariableCache.get(targetType);
        Map<TypeVariable<?>, Type> map2 = map = ref != null ? ref.get() : null;
        if (map == null) {
            ParameterizedType parameterized;
            Class<?> type;
            map = new HashMap();
            TypeResolver.buildTypeVariableMap(targetType.getGenericInterfaces(), map);
            Type genericType = targetType.getGenericSuperclass();
            for (type = targetType.getSuperclass(); type != null && !Object.class.equals(type); type = type.getSuperclass()) {
                if (genericType instanceof ParameterizedType) {
                    parameterized = (ParameterizedType)genericType;
                    TypeResolver.buildTypeVariableMap(parameterized, map);
                }
                TypeResolver.buildTypeVariableMap(type.getGenericInterfaces(), map);
                genericType = type.getGenericSuperclass();
            }
            type = targetType;
            while (type.isMemberClass()) {
                genericType = type.getGenericSuperclass();
                if (genericType instanceof ParameterizedType) {
                    parameterized = (ParameterizedType)genericType;
                    TypeResolver.buildTypeVariableMap(parameterized, map);
                }
                type = type.getEnclosingClass();
            }
            if (cacheEnabled) {
                typeVariableCache.put(targetType, new WeakReference(map));
            }
        }
        return map;
    }

    static void buildTypeVariableMap(Type[] types, Map<TypeVariable<?>, Type> map) {
        for (Type type : types) {
            if (type instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)type;
                TypeResolver.buildTypeVariableMap(parameterizedType, map);
                Type rawType = parameterizedType.getRawType();
                if (!(rawType instanceof Class)) continue;
                Class c = (Class)rawType;
                TypeResolver.buildTypeVariableMap(c.getGenericInterfaces(), map);
                continue;
            }
            if (!(type instanceof Class)) continue;
            Class c = (Class)type;
            TypeResolver.buildTypeVariableMap(c.getGenericInterfaces(), map);
        }
    }

    private static void buildTypeVariableMap(ParameterizedType type, Map<TypeVariable<?>, Type> typeVariableMap) {
        Type type2 = type.getRawType();
        if (type2 instanceof Class) {
            Class rawClass = (Class)type2;
            TypeVariable<Class<T>>[] typeVariables = rawClass.getTypeParameters();
            Type[] typeArguments = type.getActualTypeArguments();
            for (int i = 0; i < typeArguments.length; ++i) {
                TypeVariable variable = typeVariables[i];
                Type typeArgument = typeArguments[i];
                if (typeArgument instanceof Class) {
                    typeVariableMap.put(variable, typeArgument);
                    continue;
                }
                if (typeArgument instanceof GenericArrayType) {
                    typeVariableMap.put(variable, typeArgument);
                    continue;
                }
                if (typeArgument instanceof ParameterizedType) {
                    typeVariableMap.put(variable, typeArgument);
                    continue;
                }
                if (!(typeArgument instanceof TypeVariable)) continue;
                TypeVariable typeVariableArgument = (TypeVariable)typeArgument;
                Type resolvedType = typeVariableMap.get(typeVariableArgument);
                if (resolvedType == null) {
                    resolvedType = TypeResolver.resolveBound(typeVariableArgument);
                }
                typeVariableMap.put(variable, resolvedType);
            }
        }
    }

    public static Type resolveBound(TypeVariable<?> typeVariable) {
        Type[] bounds = typeVariable.getBounds();
        if (bounds.length == 0) {
            return Unknown.class;
        }
        Type bound = bounds[0];
        if (bound instanceof TypeVariable) {
            TypeVariable tv = (TypeVariable)bound;
            bound = TypeResolver.resolveBound(tv);
        }
        return bound == Object.class ? Unknown.class : bound;
    }

    public static final class Unknown {
        private Unknown() {
        }
    }
}

