/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.annotation;

import java.util.LinkedList;
import java.util.List;
import org.atmosphere.annotation.AnnotationUtil;
import org.atmosphere.annotation.Processor;
import org.atmosphere.config.AtmosphereAnnotation;
import org.atmosphere.config.service.WebSocketHandlerService;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereInterceptor;
import org.atmosphere.cpr.WebSocketProcessorFactory;
import org.atmosphere.websocket.WebSocketHandler;
import org.atmosphere.websocket.WebSocketProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AtmosphereAnnotation(value=WebSocketHandlerService.class)
public class WebSocketHandlerServiceProcessor
implements Processor<WebSocketHandler> {
    private static final Logger logger = LoggerFactory.getLogger(WebSocketHandlerServiceProcessor.class);

    @Override
    public void handle(AtmosphereFramework framework, Class<WebSocketHandler> annotatedClass) {
        try {
            WebSocketHandlerService m = annotatedClass.getAnnotation(WebSocketHandlerService.class);
            AnnotationUtil.atmosphereConfig(m.atmosphereConfig(), framework);
            framework.addAtmosphereHandler(m.path(), AtmosphereFramework.REFLECTOR_ATMOSPHEREHANDLER).initWebSocket();
            framework.setDefaultBroadcasterClassName(m.broadcaster().getName());
            AnnotationUtil.filters(m.broadcastFilters(), framework);
            LinkedList<AtmosphereInterceptor> l = new LinkedList<AtmosphereInterceptor>();
            AtmosphereInterceptor aa = AnnotationUtil.listeners(m.listeners(), framework);
            if (aa != null) {
                l.add(aa);
            }
            AnnotationUtil.interceptorsForHandler(framework, List.of(m.interceptors()), l);
            framework.setBroadcasterCacheClassName(m.broadcasterCache().getName());
            WebSocketProcessor p = WebSocketProcessorFactory.getDefault().getWebSocketProcessor(framework);
            framework.addAtmosphereHandler(m.path(), AtmosphereFramework.REFLECTOR_ATMOSPHEREHANDLER, l);
            p.registerWebSocketHandler(m.path(), new WebSocketProcessor.WebSocketHandlerProxy(AnnotationUtil.broadcasterClass(framework, m.broadcaster()), framework.newClassInstance(WebSocketHandler.class, annotatedClass)));
        }
        catch (Throwable e) {
            logger.warn("", e);
        }
    }
}

