/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.annotation;

import java.util.LinkedList;
import org.atmosphere.annotation.AnnotationUtil;
import org.atmosphere.annotation.Processor;
import org.atmosphere.config.AtmosphereAnnotation;
import org.atmosphere.config.managed.ManagedAtmosphereHandler;
import org.atmosphere.config.service.RoomService;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereInterceptor;
import org.atmosphere.cpr.DefaultBroadcaster;
import org.atmosphere.handler.AnnotatedProxy;
import org.atmosphere.room.Room;
import org.atmosphere.room.RoomManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AtmosphereAnnotation(value=RoomService.class)
public class RoomServiceProcessor
implements Processor<Object> {
    private static final Logger logger = LoggerFactory.getLogger(RoomServiceProcessor.class);

    @Override
    public void handle(AtmosphereFramework framework, Class<Object> annotatedClass) {
        try {
            RoomService a = annotatedClass.getAnnotation(RoomService.class);
            String path = a.path();
            int maxHistory = a.maxHistory();
            LinkedList<AtmosphereInterceptor> interceptors = new LinkedList<AtmosphereInterceptor>();
            AnnotationUtil.defaultManagedServiceInterceptors(framework, interceptors);
            Object instance = framework.newClassInstance(Object.class, annotatedClass);
            AnnotatedProxy handler = framework.newClassInstance(ManagedAtmosphereHandler.class, ManagedAtmosphereHandler.class).configure(framework.getAtmosphereConfig(), instance);
            framework.addAtmosphereHandler(path, (AtmosphereHandler)handler, AnnotationUtil.broadcaster(framework, DefaultBroadcaster.class, path), interceptors);
            RoomManager roomManager = RoomManager.getOrCreate(framework);
            Room room = roomManager.room(path);
            if (maxHistory > 0) {
                room.enableHistory(maxHistory);
            }
            logger.info("@RoomService mapped {} to path '{}' (history={})", new Object[]{annotatedClass.getName(), path, maxHistory});
        }
        catch (Throwable e) {
            logger.warn("Failed to process @RoomService on " + annotatedClass.getName(), e);
        }
    }
}

