/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.annotation;

import java.util.LinkedList;
import java.util.List;
import org.atmosphere.annotation.AnnotationUtil;
import org.atmosphere.annotation.Processor;
import org.atmosphere.config.AtmosphereAnnotation;
import org.atmosphere.config.managed.AtmosphereHandlerServiceInterceptor;
import org.atmosphere.config.service.AtmosphereHandlerService;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereInterceptor;
import org.atmosphere.util.IntrospectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AtmosphereAnnotation(value=AtmosphereHandlerService.class)
public class AtmosphereHandlerServiceProcessor
implements Processor<AtmosphereHandler> {
    private static final Logger logger = LoggerFactory.getLogger(AtmosphereHandlerServiceProcessor.class);

    @Override
    public void handle(AtmosphereFramework framework, Class<AtmosphereHandler> annotatedClass) {
        try {
            AtmosphereHandlerService a = annotatedClass.getAnnotation(AtmosphereHandlerService.class);
            AnnotationUtil.atmosphereConfig(a.atmosphereConfig(), framework);
            AnnotationUtil.filters(a.broadcastFilters(), framework);
            Class<? extends AtmosphereInterceptor>[] interceptors = a.interceptors();
            LinkedList<AtmosphereInterceptor> l = new LinkedList<AtmosphereInterceptor>();
            for (Class<? extends AtmosphereInterceptor> i : interceptors) {
                try {
                    AtmosphereInterceptor ai = framework.newClassInstance(AtmosphereInterceptor.class, i);
                    l.add(ai);
                }
                catch (Throwable e) {
                    logger.warn("", e);
                }
            }
            AtmosphereInterceptor aa = AnnotationUtil.listeners(a.listeners(), framework);
            if (aa != null) {
                l.add(aa);
            }
            if (a.path().contains("{")) {
                l.addFirst(framework.newClassInstance(AtmosphereInterceptor.class, AtmosphereHandlerServiceInterceptor.class));
            }
            framework.sessionSupport(a.supportSession());
            AtmosphereHandler handler = framework.newClassInstance(AtmosphereHandler.class, annotatedClass);
            for (String s : a.properties()) {
                String[] nv = s.split("=");
                IntrospectionUtils.setProperty(handler, nv[0], nv[1]);
                IntrospectionUtils.addProperty(handler, nv[0], nv[1]);
            }
            AnnotationUtil.interceptorsForHandler(framework, List.of(a.interceptors()), l);
            framework.addAtmosphereHandler(a.path(), handler, AnnotationUtil.broadcaster(framework, a.broadcaster(), a.path()), l);
            framework.setBroadcasterCacheClassName(a.broadcasterCache().getName());
        }
        catch (Throwable e) {
            logger.warn("", e);
        }
    }
}

