/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.annotation;

import java.util.List;
import org.atmosphere.client.TrackMessageSizeInterceptor;
import org.atmosphere.config.managed.ManagedServiceInterceptor;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereInterceptor;
import org.atmosphere.cpr.AtmosphereInterceptorAdapter;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEventListener;
import org.atmosphere.cpr.BroadcastFilter;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.interceptor.AtmosphereResourceLifecycleInterceptor;
import org.atmosphere.interceptor.SuspendTrackerInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotationUtil {
    public static final Logger logger = LoggerFactory.getLogger(AnnotationUtil.class);
    private static final List<Class<? extends AtmosphereInterceptor>> MANAGED_ATMOSPHERE_INTERCEPTORS = List.of(AtmosphereResourceLifecycleInterceptor.class, TrackMessageSizeInterceptor.class, SuspendTrackerInterceptor.class, ManagedServiceInterceptor.class);

    public static void interceptors(Class<? extends AtmosphereInterceptor>[] interceptors, AtmosphereFramework framework) {
        for (Class<? extends AtmosphereInterceptor> i : interceptors) {
            try {
                framework.interceptor(framework.newClassInstance(AtmosphereInterceptor.class, i));
            }
            catch (Throwable e) {
                logger.warn("", e);
            }
        }
    }

    public static void filters(Class<? extends BroadcastFilter>[] bf, AtmosphereFramework framework) throws IllegalAccessException, InstantiationException {
        for (Class<? extends BroadcastFilter> b : bf) {
            framework.broadcasterFilters(framework.newClassInstance(BroadcastFilter.class, b));
        }
    }

    public static void atmosphereConfig(String[] m, AtmosphereFramework framework) {
        for (String s : m) {
            String[] nv = s.split("=");
            framework.addInitParameter(nv[0], nv[1]);
            framework.reconfigureInitParams(true);
        }
    }

    public static void defaultManagedServiceInterceptors(AtmosphereFramework framework, List<AtmosphereInterceptor> l) {
        AnnotationUtil.interceptorsForManagedService(framework, MANAGED_ATMOSPHERE_INTERCEPTORS, l, false);
    }

    public static void interceptorsForManagedService(AtmosphereFramework framework, List<Class<? extends AtmosphereInterceptor>> interceptors, List<AtmosphereInterceptor> l) {
        AnnotationUtil.interceptorsForManagedService(framework, interceptors, l, true);
    }

    public static void interceptorsForManagedService(AtmosphereFramework framework, List<Class<? extends AtmosphereInterceptor>> interceptors, List<AtmosphereInterceptor> l, boolean checkDuplicate) {
        for (Class<? extends AtmosphereInterceptor> i : interceptors) {
            if (framework.excludedInterceptors().contains(i.getName()) || checkDuplicate && !AnnotationUtil.checkDefault(i)) continue;
            try {
                logger.info("Adding {}", i);
                l.add(framework.newClassInstance(AtmosphereInterceptor.class, i));
            }
            catch (Throwable e) {
                logger.warn("", e);
            }
        }
    }

    public static void interceptorsForHandler(AtmosphereFramework framework, List<Class<? extends AtmosphereInterceptor>> interceptors, List<AtmosphereInterceptor> l) {
        for (Class<? extends AtmosphereInterceptor> i : interceptors) {
            if (framework.excludedInterceptors().contains(i.getName()) || AtmosphereFramework.DEFAULT_ATMOSPHERE_INTERCEPTORS.contains(i)) continue;
            try {
                logger.info("Adding {}", i);
                l.add(framework.newClassInstance(AtmosphereInterceptor.class, i));
            }
            catch (Throwable e) {
                logger.warn("", e);
            }
        }
    }

    public static boolean checkDefault(Class<? extends AtmosphereInterceptor> i) {
        return !MANAGED_ATMOSPHERE_INTERCEPTORS.contains(i) && !AtmosphereFramework.DEFAULT_ATMOSPHERE_INTERCEPTORS.contains(i);
    }

    public static AtmosphereInterceptor listeners(final Class<? extends AtmosphereResourceEventListener>[] listeners, final AtmosphereFramework framework) {
        if (listeners.length > 0) {
            try {
                return new AtmosphereInterceptorAdapter(){

                    @Override
                    public Action inspect(AtmosphereResource r) {
                        if (!r.isSuspended()) {
                            for (Class l : listeners) {
                                try {
                                    r.addEventListener(framework.newClassInstance(AtmosphereResourceEventListener.class, l));
                                }
                                catch (Throwable e) {
                                    logger.warn("", e);
                                }
                            }
                        }
                        return Action.CONTINUE;
                    }

                    @Override
                    public String toString() {
                        return "@Service Event Listeners";
                    }
                };
            }
            catch (Throwable e) {
                logger.warn("", e);
            }
        }
        return null;
    }

    public static Broadcaster broadcaster(AtmosphereFramework framework, Class<? extends Broadcaster> broadcaster, String path) throws Exception {
        return framework.getBroadcasterFactory().lookup(AnnotationUtil.broadcasterClass(framework, broadcaster), path, true);
    }

    public static Class<? extends Broadcaster> broadcasterClass(AtmosphereFramework framework, Class<? extends Broadcaster> broadcaster) throws Exception {
        if (framework.isBroadcasterSpecified()) {
            try {
                broadcaster = framework.getClass().getClassLoader().loadClass(framework.getDefaultBroadcasterClassName());
            }
            catch (ClassNotFoundException ex) {
                broadcaster = Thread.currentThread().getContextClassLoader().loadClass(framework.getDefaultBroadcasterClassName());
            }
        }
        return broadcaster;
    }
}

