/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.interceptor;

import java.io.IOException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.atmosphere.client.TrackMessageSizeFilter;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereInterceptor;
import org.atmosphere.cpr.AtmosphereInterceptorAdapter;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.atmosphere.cpr.AtmosphereResourceEventListenerAdapter;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.cpr.BroadcastFilter;
import org.atmosphere.cpr.FrameworkConfig;
import org.atmosphere.interceptor.HeartbeatInterceptor;
import org.atmosphere.util.ExecutorsFactory;
import org.atmosphere.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaScriptProtocol
extends AtmosphereInterceptorAdapter {
    private static final Logger logger = LoggerFactory.getLogger(JavaScriptProtocol.class);
    private String wsDelimiter = "|";
    private final TrackMessageSizeFilter f = new TrackMessageSizeFilter();
    private AtmosphereFramework framework;
    private boolean enforceAtmosphereVersion = true;
    private ScheduledExecutorService executorService;
    private int delayProtocolInMilliseconds;

    @Override
    public void configure(AtmosphereConfig config) {
        String s = config.getInitParameter("org.atmosphere.client.TrackMessageSizeInterceptor.delimiter");
        if (s != null) {
            this.wsDelimiter = s;
        }
        this.enforceAtmosphereVersion = Boolean.parseBoolean(config.getInitParameter("org.atmosphere.interceptor.JavaScriptProtocol.enforceAtmosphereProtocol", "true"));
        this.delayProtocolInMilliseconds = config.getInitParameter("org.atmosphere.interceptor.JavaScriptProtocol.delayProtocolInMilliseconds", 0);
        this.framework = config.framework();
        this.executorService = ExecutorsFactory.getScheduler(config);
    }

    @Override
    public Action inspect(AtmosphereResource ar) {
        if (Utils.webSocketMessage(ar)) {
            return Action.CONTINUE;
        }
        final AtmosphereResourceImpl r = (AtmosphereResourceImpl)ar;
        AtmosphereRequest request = r.getRequest(false);
        final AtmosphereResponse response = r.getResponse(false);
        String uuid = request.getHeader("X-Atmosphere-tracking-id");
        String handshakeUUID = request.getHeader("X-atmo-protocol");
        if (uuid != null && uuid.equals("0") && handshakeUUID != null) {
            if (this.enforceAtmosphereVersion) {
                String javascriptVersion = request.getHeader("X-Atmosphere-Framework");
                int version = 0;
                if (javascriptVersion != null) {
                    version = JavaScriptProtocol.parseVersion(javascriptVersion.split("-")[0]);
                }
                if (version < 221) {
                    logger.error("Invalid Atmosphere Version {}", (Object)javascriptVersion);
                    response.setStatus(501);
                    response.addHeader("X-Atmosphere-error", "Atmosphere Protocol version not supported.");
                    try {
                        response.flushBuffer();
                    }
                    catch (IOException e) {
                        logger.trace("response.flushBuffer()", (Throwable)e);
                    }
                    return Action.CANCELLED;
                }
            }
            request.header("X-atmo-protocol", null);
            int heartbeatInterval = 0;
            String heartbeatData = "";
            for (AtmosphereInterceptor interceptor : this.framework.interceptors()) {
                if (!HeartbeatInterceptor.class.isAssignableFrom(interceptor.getClass())) continue;
                HeartbeatInterceptor heartbeatInterceptor = (HeartbeatInterceptor)interceptor;
                heartbeatInterval = heartbeatInterceptor.clientHeartbeatFrequencyInSeconds() * 1000;
                heartbeatData = new String(heartbeatInterceptor.getPaddingBytes());
                break;
            }
            String message = this.enforceAtmosphereVersion ? r.uuid() + this.wsDelimiter + heartbeatInterval + this.wsDelimiter + heartbeatData + this.wsDelimiter : r.uuid();
            final AtomicReference<String> protocolMessage = new AtomicReference<String>(message);
            if (r.getBroadcaster().getBroadcasterConfig().hasFilters()) {
                for (BroadcastFilter bf : r.getBroadcaster().getBroadcasterConfig().filters()) {
                    if (!TrackMessageSizeFilter.class.isAssignableFrom(bf.getClass())) continue;
                    protocolMessage.set((String)this.f.filter(r.getBroadcaster().getID(), r, protocolMessage.get(), protocolMessage.get()).message());
                    break;
                }
            }
            if (!Utils.resumableTransport(r.transport())) {
                AtmosphereResourceEventListenerAdapter.OnSuspend a = new AtmosphereResourceEventListenerAdapter.OnSuspend(){

                    @Override
                    public void onSuspend(AtmosphereResourceEvent event) {
                        if (JavaScriptProtocol.this.delayProtocolInMilliseconds > 0) {
                            JavaScriptProtocol.this.executorService.schedule(() -> response.write((String)protocolMessage.get()), (long)JavaScriptProtocol.this.delayProtocolInMilliseconds, TimeUnit.MILLISECONDS);
                        } else {
                            response.write((String)protocolMessage.get());
                            try {
                                response.flushBuffer();
                            }
                            catch (IOException e) {
                                logger.trace("", (Throwable)e);
                            }
                        }
                        r.removeEventListener(this);
                    }
                };
                request.setAttribute(FrameworkConfig.CALLBACK_JAVASCRIPT_PROTOCOL, a);
                r.addEventListener(a);
            } else {
                response.setContentType("text/plain");
                response.write(protocolMessage.get());
            }
            if (r.transport() == AtmosphereResource.TRANSPORT.WEBSOCKET || r.transport() == AtmosphereResource.TRANSPORT.STREAMING || r.transport() == AtmosphereResource.TRANSPORT.SSE) {
                return Action.CONTINUE;
            }
            return Action.CANCELLED;
        }
        return Action.CONTINUE;
    }

    private static int parseVersion(String version) {
        String[] parts = version.split("\\.");
        return Integer.parseInt(parts[0] + parts[1] + parts[2]);
    }

    public String wsDelimiter() {
        return this.wsDelimiter;
    }

    public JavaScriptProtocol wsDelimiter(String wsDelimiter) {
        this.wsDelimiter = wsDelimiter;
        return this;
    }

    public boolean enforceAtmosphereVersion() {
        return this.enforceAtmosphereVersion;
    }

    public JavaScriptProtocol enforceAtmosphereVersion(boolean enforceAtmosphereVersion) {
        this.enforceAtmosphereVersion = enforceAtmosphereVersion;
        return this;
    }

    @Override
    public String toString() {
        return "Atmosphere JavaScript Protocol";
    }
}

