/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.BroadcasterListener;
import org.atmosphere.inject.AtmosphereConfigAware;
import org.atmosphere.util.ExecutorsFactory;

public interface MetaBroadcaster
extends AtmosphereConfigAware {
    public Future<List<Broadcaster>> broadcastTo(String var1, Object var2);

    public Future<List<Broadcaster>> broadcastTo(String var1, Object var2, boolean var3);

    public Future<List<Broadcaster>> scheduleTo(String var1, Object var2, int var3, TimeUnit var4);

    public Future<List<Broadcaster>> delayTo(String var1, Object var2, int var3, TimeUnit var4);

    public MetaBroadcaster addBroadcasterListener(BroadcasterListener var1);

    public MetaBroadcaster removeBroadcasterListener(BroadcasterListener var1);

    public MetaBroadcaster cache(MetaBroadcasterCache var1);

    public void destroy();

    public static final class ThirtySecondsCache
    implements MetaBroadcasterCache,
    Runnable {
        private final MetaBroadcaster metaBroadcaster;
        private final ConcurrentHashMap<String, Object> cache = new ConcurrentHashMap();

        public ThirtySecondsCache(MetaBroadcaster metaBroadcaster, AtmosphereConfig config) {
            this.metaBroadcaster = metaBroadcaster;
            ExecutorsFactory.getScheduler(config).scheduleAtFixedRate(this, 0L, 30L, TimeUnit.SECONDS);
        }

        @Override
        public MetaBroadcasterCache cache(String path, Object o) {
            this.cache.put(path, o);
            return this;
        }

        @Override
        public MetaBroadcasterCache flushCache() {
            for (Map.Entry<String, Object> e : this.cache.entrySet()) {
                this.metaBroadcaster.broadcastTo(e.getKey(), e.getValue(), false);
            }
            return this;
        }

        @Override
        public void run() {
            this.flushCache();
            this.cache.clear();
        }
    }

    public static final class NoCache
    implements MetaBroadcasterCache {
        @Override
        public MetaBroadcasterCache cache(String path, Object o) {
            return this;
        }

        @Override
        public MetaBroadcasterCache flushCache() {
            return this;
        }
    }

    public static interface MetaBroadcasterCache {
        public MetaBroadcasterCache cache(String var1, Object var2);

        public MetaBroadcasterCache flushCache();
    }
}

