/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.interceptor;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.atmosphere.interceptor.AllowInterceptor;
import org.atmosphere.runtime.Action;
import org.atmosphere.runtime.AtmosphereConfig;
import org.atmosphere.runtime.AtmosphereInterceptor;
import org.atmosphere.runtime.AtmosphereResource;
import org.atmosphere.runtime.AtmosphereResourceEvent;
import org.atmosphere.runtime.AtmosphereResourceEventImpl;
import org.atmosphere.runtime.AtmosphereResourceEventListenerAdapter;
import org.atmosphere.runtime.AtmosphereResourceImpl;
import org.atmosphere.runtime.Broadcaster;
import org.atmosphere.runtime.BroadcasterCache;
import org.atmosphere.runtime.BroadcasterFactory;
import org.atmosphere.runtime.BroadcasterListenerAdapter;
import org.atmosphere.util.ExecutorsFactory;
import org.atmosphere.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtmosphereResourceStateRecovery
implements AtmosphereInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(AtmosphereResourceStateRecovery.class);
    private final ConcurrentHashMap<String, BroadcasterTracker> states = new ConcurrentHashMap();
    private BroadcasterFactory factory;
    private ScheduledExecutorService stateTracker;
    private long timeout = 300000L;
    private Future<?> trackerFuture;

    @Override
    public void configure(AtmosphereConfig config) {
        this.factory = config.getBroadcasterFactory();
        this.factory.addBroadcasterListener(new B());
        this.stateTracker = ExecutorsFactory.getScheduler(config);
        String s = config.getInitParameter("org.atmosphere.interceptor.AtmosphereResourceStateRecovery.timeout");
        if (s != null) {
            this.timeout = Long.parseLong(s);
        }
        this.startStateTracker();
        logger.trace("{} started.", (Object)AtmosphereResourceStateRecovery.class.getName());
    }

    public AtmosphereResourceStateRecovery timeout(long timeout) {
        this.timeout = timeout;
        this.trackerFuture.cancel(false);
        this.startStateTracker();
        return this;
    }

    public long timeout() {
        return this.timeout;
    }

    protected void startStateTracker() {
        this.trackerFuture = this.stateTracker.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                long now = System.currentTimeMillis();
                for (Map.Entry t : AtmosphereResourceStateRecovery.this.states.entrySet()) {
                    if (now - ((BroadcasterTracker)t.getValue()).lastTick() <= AtmosphereResourceStateRecovery.this.timeout) continue;
                    logger.trace("AtmosphereResource {} state destroyed.", t.getKey());
                    AtmosphereResourceStateRecovery.this.states.remove(t.getKey());
                }
            }
        }, this.timeout, this.timeout, TimeUnit.MILLISECONDS);
    }

    @Override
    public Action inspect(final AtmosphereResource r) {
        if (!Utils.pollableTransport(r.transport()) && !Utils.webSocketMessage(r)) {
            final BroadcasterTracker tracker = this.track(r).tick();
            List<Object> cachedMessages = this.retrieveCache(r, tracker, false);
            if (!cachedMessages.isEmpty()) {
                logger.trace("cached messages");
                this.writeCache(r, cachedMessages);
                return Action.CANCELLED;
            }
            r.addEventListener(new OnAlwaysSuspend(){

                @Override
                public void onSuspend(AtmosphereResourceEvent event) {
                    r.removeEventListener(this);
                    logger.trace("onSuspend first");
                    final AtomicBoolean doNotSuspend = new AtomicBoolean(false);
                    r.addEventListener(new AtmosphereResourceEventListenerAdapter.OnBroadcast(){

                        @Override
                        public void onBroadcast(AtmosphereResourceEvent event) {
                            r.removeEventListener(this);
                            doNotSuspend.set(true);
                            logger.trace("onBroadcast");
                        }
                    });
                    for (String broadcasterID : tracker.ids()) {
                        Object b = AtmosphereResourceStateRecovery.this.factory.lookup(broadcasterID, false);
                        logger.trace("About to associate resource {} with Broadcaster {}", (Object)r.uuid(), (Object)broadcasterID);
                        if (b != null && !b.getID().equalsIgnoreCase(r.getBroadcaster().getID())) {
                            logger.trace("Associate AtmosphereResource {} with Broadcaster {}", (Object)r.uuid(), (Object)broadcasterID);
                            b.addAtmosphereResource(r);
                            continue;
                        }
                        if (b == null) {
                            logger.trace("Broadcaster {} is no longer available for {}", (Object)broadcasterID, (Object)r);
                            continue;
                        }
                        logger.trace("AtmosphereResource {} already associated with {}", (Object)r.uuid(), (Object)broadcasterID);
                    }
                    List<Object> cachedMessages = AtmosphereResourceStateRecovery.this.retrieveCache(r, tracker, true);
                    if (logger.isTraceEnabled()) {
                        logger.trace("message size {}", (Object)cachedMessages.size());
                    }
                    if (!cachedMessages.isEmpty()) {
                        logger.trace("About to write to the cache {}", (Object)r.uuid());
                        AtmosphereResourceStateRecovery.this.writeCache(r, cachedMessages);
                        doNotSuspend.set(true);
                    }
                    if (doNotSuspend.get()) {
                        ((AtmosphereResourceImpl)AtmosphereResourceImpl.class.cast(r)).action().type(Action.TYPE.CONTINUE);
                    }
                    if (logger.isTraceEnabled()) {
                        logger.trace("doNotSuspend {}", (Object)doNotSuspend.get());
                    }
                }
            });
        }
        return Action.CONTINUE;
    }

    private BroadcasterTracker track(AtmosphereResource r) {
        BroadcasterTracker tracker = this.states.get(r.uuid());
        if (tracker == null) {
            tracker = new BroadcasterTracker();
            this.states.put(r.uuid(), tracker);
            logger.trace("AtmosphereResource {} state now tracked", (Object)r.uuid());
        }
        return tracker;
    }

    @Override
    public void postInspect(AtmosphereResource r) {
    }

    @Override
    public void destroy() {
        this.trackerFuture.cancel(true);
    }

    public ConcurrentHashMap<String, BroadcasterTracker> states() {
        return this.states;
    }

    public String toString() {
        return "AtmosphereResource state recovery";
    }

    public List<Object> retrieveCache(AtmosphereResource r, BroadcasterTracker tracker, boolean force) {
        LinkedList<Object> cachedMessages = new LinkedList<Object>();
        for (String broadcasterID : tracker.ids()) {
            Object b = this.factory.lookup(broadcasterID, false);
            logger.trace("About to retrieve cached messages for resource {} with Broadcaster {}, tracked by " + b, (Object)r.uuid(), (Object)r.getBroadcaster());
            if (b != null && (force || !b.getID().equalsIgnoreCase(r.getBroadcaster().getID()))) {
                BroadcasterCache cache = b.getBroadcasterConfig().getBroadcasterCache();
                List<Object> t = cache.retrieveFromCache(b.getID(), r.uuid());
                t = b.getBroadcasterConfig().applyFilters(r, t);
                if (t.isEmpty()) continue;
                logger.trace("Found Cached Messages For AtmosphereResource {} with Broadcaster {}", (Object)r.uuid(), (Object)broadcasterID);
                cachedMessages.addAll(t);
                continue;
            }
            logger.trace("Broadcaster {} is no longer available for {}", (Object)broadcasterID, (Object)r);
        }
        return cachedMessages;
    }

    private void writeCache(AtmosphereResource r, List<Object> cachedMessages) {
        try {
            logger.trace("Writing cached messages {} for {}", cachedMessages, (Object)r.uuid());
            r.getAtmosphereHandler().onStateChange(new AtmosphereResourceEventImpl((AtmosphereResourceImpl)AtmosphereResourceImpl.class.cast(r), false, false, null).setMessage(cachedMessages));
        }
        catch (IOException e) {
            logger.warn("Unable to recover from state recovery {}", (Object)r.uuid(), (Object)e);
        }
    }

    public static abstract class OnAlwaysSuspend
    extends AtmosphereResourceEventListenerAdapter.OnSuspend
    implements AllowInterceptor {
        @Override
        public abstract void onSuspend(AtmosphereResourceEvent var1);
    }

    public static final class BroadcasterTracker {
        private final ConcurrentLinkedQueue<String> broadcasterIds = new ConcurrentLinkedQueue();
        private long tick = System.currentTimeMillis();

        public BroadcasterTracker add(Broadcaster b) {
            logger.trace("Adding {}", (Object)b.getID());
            if (!this.broadcasterIds.contains(b.getID())) {
                this.broadcasterIds.add(b.getID());
            }
            return this;
        }

        public BroadcasterTracker remove(Broadcaster b) {
            logger.trace("Removing {}", (Object)b.getID());
            this.broadcasterIds.remove(b.getID());
            return this;
        }

        public ConcurrentLinkedQueue<String> ids() {
            return this.broadcasterIds;
        }

        public BroadcasterTracker tick() {
            this.tick = System.currentTimeMillis();
            return this;
        }

        public long lastTick() {
            return this.tick;
        }
    }

    public final class B
    extends BroadcasterListenerAdapter {
        @Override
        public void onAddAtmosphereResource(Broadcaster b, AtmosphereResource r) {
            BroadcasterTracker t = (BroadcasterTracker)AtmosphereResourceStateRecovery.this.states.get(r.uuid());
            if (t == null) {
                t = AtmosphereResourceStateRecovery.this.track(r);
            }
            logger.trace("Starting tracking the state of {} with broadcaster {}", (Object)r.uuid(), (Object)b.getID());
            t.add(b);
        }

        @Override
        public void onRemoveAtmosphereResource(Broadcaster b, AtmosphereResource r) {
            BroadcasterTracker t = (BroadcasterTracker)AtmosphereResourceStateRecovery.this.states.get(r.uuid());
            AtmosphereResourceEvent e = r.getAtmosphereResourceEvent();
            if (e.isClosedByClient() || !r.isResumed() && !e.isResumedOnTimeout()) {
                logger.trace("Deleting the state of {} with broadcaster {}", (Object)r.uuid(), (Object)b.getID());
                if (t != null) {
                    t.remove(b);
                }
            } else {
                this.onAddAtmosphereResource(b, r);
                logger.trace("Keeping the state of {} with broadcaster {}", (Object)r.uuid(), (Object)b.getID());
                logger.trace("State for {} with broadcaster {}", (Object)r.uuid(), t != null ? t.ids() : "null");
            }
        }
    }
}

