/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.runtime;

import java.util.LinkedList;
import java.util.List;
import org.atmosphere.container.JSR356AsyncSupport;
import org.atmosphere.container.NettyCometSupport;
import org.atmosphere.runtime.AsyncSupport;
import org.atmosphere.runtime.AsyncSupportResolver;
import org.atmosphere.runtime.AtmosphereConfig;
import org.atmosphere.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAsyncSupportResolver
implements AsyncSupportResolver {
    private static final Logger logger = LoggerFactory.getLogger(DefaultAsyncSupportResolver.class);
    public static final String SERVLET_30 = "javax.servlet.AsyncListener";
    public static final String NETTY = "org.jboss.netty.channel.Channel";
    public static final String JSR356_WEBSOCKET = "javax.websocket.Endpoint";
    private final AtmosphereConfig config;

    public DefaultAsyncSupportResolver(AtmosphereConfig config) {
        this.config = config;
    }

    protected boolean testClassExists(String testClass) {
        try {
            boolean exists = testClass != null && testClass.length() > 0 && IOUtils.loadClass(null, testClass) != null;
            logger.debug(exists ? "Found {}" : "Not found {}", (Object)testClass);
            return exists;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public List<Class<? extends AsyncSupport>> detectContainersPresent() {
        return new LinkedList<Class<? extends AsyncSupport>>(){
            {
                if (DefaultAsyncSupportResolver.this.testClassExists(DefaultAsyncSupportResolver.NETTY)) {
                    this.add(NettyCometSupport.class);
                }
            }
        };
    }

    public List<Class<? extends AsyncSupport>> detectWebSocketPresent(boolean useNativeIfPossible, boolean useServlet30Async) {
        return new LinkedList<Class<? extends AsyncSupport>>(){
            {
                this.add(JSR356AsyncSupport.class);
            }
        };
    }

    public AsyncSupport newCometSupport(Class<? extends AsyncSupport> targetClass) {
        try {
            return targetClass.getDeclaredConstructor(AtmosphereConfig.class).newInstance(this.config);
        }
        catch (Exception e) {
            logger.warn("Failed to create AsyncSupport class: {}, error: {}", targetClass, (Object)e);
            Throwable cause = e.getCause();
            if (cause != null) {
                logger.error("Real error: {}", (Object)cause.getMessage(), (Object)cause);
            }
            return null;
        }
    }

    public AsyncSupport newCometSupport(String targetClassFQN) {
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            return (AsyncSupport)cl.loadClass(targetClassFQN).getDeclaredConstructor(AtmosphereConfig.class).newInstance(this.config);
        }
        catch (Exception e) {
            logger.error("Failed to create AsyncSupport class: {}, error: {}", (Object)targetClassFQN, (Object)e);
            Throwable cause = e.getCause();
            if (cause != null) {
                logger.error("Real error: {}", (Object)cause.getMessage(), (Object)cause);
            }
            throw new IllegalArgumentException("Unable to create " + targetClassFQN, e);
        }
    }

    @Override
    public AsyncSupport resolve(boolean useNativeIfPossible, boolean defaultToBlocking, boolean useServlet30Async) {
        List<Class<? extends AsyncSupport>> l;
        AsyncSupport cs = null;
        useServlet30Async = this.testClassExists(SERVLET_30);
        if (!defaultToBlocking && !(l = this.detectWebSocketPresent(useNativeIfPossible, useServlet30Async)).isEmpty()) {
            cs = this.resolveWebSocket(l);
        }
        if (cs == null) {
            return this.resolveNativeCometSupport(this.detectContainersPresent());
        }
        return cs;
    }

    public AsyncSupport resolveWebSocket(List<Class<? extends AsyncSupport>> available) {
        if (available == null || available.isEmpty()) {
            return null;
        }
        return this.newCometSupport(available.get(0));
    }

    protected AsyncSupport resolveNativeCometSupport(List<Class<? extends AsyncSupport>> available) {
        if (available == null || available.isEmpty()) {
            return null;
        }
        if (available.size() == 1) {
            return this.newCometSupport(available.get(0));
        }
        return this.resolveMultipleNativeSupportConflict(available);
    }

    protected AsyncSupport resolveMultipleNativeSupportConflict(List<Class<? extends AsyncSupport>> available) {
        StringBuilder b = new StringBuilder("Found multiple containers, please specify which one to use: ");
        for (Class<? extends AsyncSupport> cs : available) {
            b.append(cs != null ? cs.getCanonicalName() : "null").append(", ");
        }
        b.append(" until you do, Atmosphere will use:" + available.get(0));
        logger.warn("{}", (Object)b.toString());
        return this.newCometSupport(available.get(0));
    }
}

