/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cache;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.atmosphere.cache.BroadcastMessage;
import org.atmosphere.cache.BroadcasterCacheInspector;
import org.atmosphere.cache.CacheMessage;
import org.atmosphere.runtime.AtmosphereConfig;
import org.atmosphere.runtime.AtmosphereResource;
import org.atmosphere.runtime.BroadcasterCache;
import org.atmosphere.runtime.BroadcasterCacheListener;
import org.atmosphere.util.ExecutorsFactory;
import org.atmosphere.util.UUIDProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UUIDBroadcasterCache
implements BroadcasterCache {
    private static final Logger logger = LoggerFactory.getLogger(UUIDBroadcasterCache.class);
    private final ConcurrentHashMap<String, ConcurrentLinkedQueue<CacheMessage>> messages = new ConcurrentHashMap();
    private final Map<String, Long> activeClients = new ConcurrentHashMap<String, Long>();
    protected final List<BroadcasterCacheInspector> inspectors = new LinkedList<BroadcasterCacheInspector>();
    private ScheduledFuture scheduledFuture;
    protected ScheduledExecutorService taskScheduler;
    private long clientIdleTime = TimeUnit.SECONDS.toMillis(60L);
    private long invalidateCacheInterval = TimeUnit.SECONDS.toMillis(30L);
    private boolean shared = true;
    protected final List<BroadcasterCacheListener> listeners = new LinkedList<BroadcasterCacheListener>();
    private UUIDProvider uuidProvider;

    @Override
    public void configure(AtmosphereConfig config) {
        Object o = config.properties().get("shared");
        if (o != null) {
            this.shared = Boolean.parseBoolean(o.toString());
        }
        this.taskScheduler = this.shared ? ExecutorsFactory.getScheduler(config) : Executors.newSingleThreadScheduledExecutor();
        this.clientIdleTime = TimeUnit.SECONDS.toMillis(Long.valueOf(config.getInitParameter("org.atmosphere.cache.UUIDBroadcasterCache.clientIdleTime", "60")));
        this.invalidateCacheInterval = TimeUnit.SECONDS.toMillis(Long.valueOf(config.getInitParameter("org.atmosphere.cache.UUIDBroadcasterCache.invalidateCacheInterval", "30")));
        this.uuidProvider = config.uuidProvider();
    }

    @Override
    public void start() {
        this.scheduledFuture = this.taskScheduler.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                UUIDBroadcasterCache.this.invalidateExpiredEntries();
            }
        }, 0L, this.invalidateCacheInterval, TimeUnit.MILLISECONDS);
    }

    @Override
    public void stop() {
        this.cleanup();
        if (this.taskScheduler != null) {
            this.taskScheduler.shutdown();
        }
    }

    @Override
    public void cleanup() {
        this.messages.clear();
        this.activeClients.clear();
        this.inspectors.clear();
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(false);
            this.scheduledFuture = null;
        }
    }

    @Override
    public CacheMessage addToCache(String broadcasterId, String uuid, BroadcastMessage message) {
        if (logger.isTraceEnabled()) {
            logger.trace("Adding for AtmosphereResource {} cached messages {}", (Object)uuid, message.message());
            logger.trace("Active clients {}", this.activeClients());
        }
        String messageId = this.uuidProvider.generateUuid();
        boolean cache = true;
        if (!this.inspect(message)) {
            cache = false;
        }
        CacheMessage cacheMessage = new CacheMessage(messageId, message.message(), uuid, broadcasterId);
        if (cache) {
            if (uuid.equals("null")) {
                for (Map.Entry<String, Long> entry : this.activeClients.entrySet()) {
                    this.addMessage(broadcasterId, entry.getKey(), cacheMessage);
                }
            } else {
                this.cacheCandidate(broadcasterId, uuid);
                this.addMessage(broadcasterId, uuid, cacheMessage);
            }
        }
        return cacheMessage;
    }

    @Override
    public List<Object> retrieveFromCache(String broadcasterId, String uuid) {
        CacheMessage message;
        this.cacheCandidate(broadcasterId, uuid);
        ConcurrentLinkedQueue<CacheMessage> clientQueue = this.messages.get(uuid);
        ArrayList<Object> result = new ArrayList<Object>();
        if (clientQueue == null) {
            logger.trace("client queue is null (not yet created), hence returning back for broadcaster {} and uuid {}", (Object)broadcasterId, (Object)uuid);
            return result;
        }
        while ((message = clientQueue.poll()) != null) {
            result.add(message);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("Retrieved for AtmosphereResource {} cached messages {}", (Object)uuid, result);
            logger.trace("Available cached message {}", this.messages);
        }
        return result;
    }

    @Override
    public BroadcasterCache clearCache(String broadcasterId, String uuid, CacheMessage message) {
        ConcurrentLinkedQueue<CacheMessage> clientQueue = this.messages.get(uuid);
        if (clientQueue != null) {
            logger.trace("Removing for broadcaster {} AtmosphereResource {} cached message {}", new Object[]{broadcasterId, uuid, message.getMessage()});
            this.notifyRemoveCache(broadcasterId, message);
            clientQueue.remove(message);
        }
        return this;
    }

    @Override
    public BroadcasterCache inspector(BroadcasterCacheInspector b) {
        this.inspectors.add(b);
        return this;
    }

    @Override
    public BroadcasterCache addBroadcasterCacheListener(BroadcasterCacheListener l) {
        this.listeners.add(l);
        return this;
    }

    @Override
    public BroadcasterCache removeBroadcasterCacheListener(BroadcasterCacheListener l) {
        this.listeners.remove(l);
        return this;
    }

    protected String uuid(AtmosphereResource r) {
        return r.uuid();
    }

    private void addMessage(String broadcasterId, String clientId, CacheMessage message) {
        ConcurrentLinkedQueue<CacheMessage> clientQueue = this.messages.get(clientId);
        if (clientQueue == null) {
            if (this.activeClients.get(clientId) != null) {
                clientQueue = new ConcurrentLinkedQueue();
                if (this.messages.putIfAbsent(clientId, clientQueue) == null) {
                    logger.debug("new queue created for message {}, broadcaster {} for resource {} ", new Object[]{message.getMessage(), broadcasterId, clientId});
                }
            } else {
                logger.debug("Client {} is no longer active. Not caching message {} for broadcaster {}", new Object[]{clientId, message, broadcasterId});
                return;
            }
        }
        this.notifyAddCache(broadcasterId, message);
        if (logger.isDebugEnabled()) {
            logger.debug("offering message {}, broadcaster {} for resource {}", new Object[]{message.getMessage(), broadcasterId, clientId});
        }
        this.messages.get(clientId).offer(message);
    }

    private void notifyAddCache(String broadcasterId, CacheMessage message) {
        for (BroadcasterCacheListener l : this.listeners) {
            try {
                l.onAddCache(broadcasterId, message);
            }
            catch (Exception ex) {
                logger.warn("Listener exception", (Throwable)ex);
            }
        }
    }

    private void notifyRemoveCache(String broadcasterId, CacheMessage message) {
        for (BroadcasterCacheListener l : this.listeners) {
            try {
                l.onRemoveCache(broadcasterId, message);
            }
            catch (Exception ex) {
                logger.warn("Listener exception", (Throwable)ex);
            }
        }
    }

    public Map<String, ConcurrentLinkedQueue<CacheMessage>> messages() {
        return this.messages;
    }

    public Map<String, Long> activeClients() {
        return this.activeClients;
    }

    protected boolean inspect(BroadcastMessage m) {
        for (BroadcasterCacheInspector b : this.inspectors) {
            if (b.inspect(m)) continue;
            return false;
        }
        return true;
    }

    public void setInvalidateCacheInterval(long invalidateCacheInterval) {
        this.invalidateCacheInterval = invalidateCacheInterval;
        this.scheduledFuture.cancel(true);
        this.start();
    }

    public void setClientIdleTime(long clientIdleTime) {
        this.clientIdleTime = clientIdleTime;
    }

    protected void invalidateExpiredEntries() {
        long now = System.currentTimeMillis();
        HashSet<String> inactiveClients = new HashSet<String>();
        for (Map.Entry<String, Long> entry : this.activeClients.entrySet()) {
            if (now - entry.getValue() <= this.clientIdleTime) continue;
            logger.trace("Invalidate client {}", (Object)entry.getKey());
            inactiveClients.add(entry.getKey());
        }
        for (String clientId : inactiveClients) {
            this.activeClients.remove(clientId);
            ConcurrentLinkedQueue<CacheMessage> queue = this.messages.remove(clientId);
            if (queue != null) {
                logger.debug("removed  client queue of size: {} for client uuid {}", (Object)queue.size(), (Object)clientId);
                this.notifyRemoveCache(queue);
                continue;
            }
            logger.trace("queue is already null for client: {}", (Object)clientId);
        }
        for (String clientId : this.messages().keySet()) {
            if (this.activeClients().containsKey(clientId)) continue;
            this.messages().get(clientId).clear();
        }
    }

    private void notifyRemoveCache(ConcurrentLinkedQueue<CacheMessage> messageQueue) {
        for (CacheMessage message : messageQueue) {
            this.notifyRemoveCache(message.getBroadcasterId(), message);
        }
    }

    @Override
    public BroadcasterCache excludeFromCache(String broadcasterId, AtmosphereResource r) {
        this.activeClients.remove(r.uuid());
        return this;
    }

    @Override
    public BroadcasterCache cacheCandidate(String broadcasterId, String uuid) {
        long now = System.currentTimeMillis();
        this.activeClients.put(uuid, now);
        return this;
    }

    public String toString() {
        return this.getClass().getName();
    }

    public List<BroadcasterCacheListener> listeners() {
        return this.listeners;
    }

    public List<BroadcasterCacheInspector> inspectors() {
        return this.inspectors;
    }
}

