/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.util;

import java.nio.CharBuffer;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.BitSet;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;
import javax.servlet.http.Cookie;

public class CookieUtil {
    private static final String OLD_COOKIE_PATTERN = "EEE, dd-MMM-yyyy HH:mm:ss z";
    private static final ThreadLocal<DateFormat> OLD_COOKIE_FORMAT = ThreadLocal.withInitial(() -> {
        SimpleDateFormat df = new SimpleDateFormat(OLD_COOKIE_PATTERN, Locale.US);
        df.setTimeZone(TimeZone.getTimeZone("GMT"));
        return df;
    });
    private static final String tspecials = ",; ";
    private static final String ancientDate;
    private static final BitSet VALID_COOKIE_NAME_OCTETS;
    private static final BitSet VALID_COOKIE_VALUE_OCTETS;
    private static final BitSet VALID_COOKIE_ATTRIBUTE_VALUE_OCTETS;

    public static boolean isToken(String value) {
        if (value == null) {
            return true;
        }
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            if (c >= ' ' && c < '\u007f' && tspecials.indexOf(c) == -1) continue;
            return false;
        }
        return true;
    }

    private static String escapeDoubleQuotes(String s) {
        if (s == null || s.length() == 0 || s.indexOf(34) == -1) {
            return s;
        }
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\"') {
                b.append('\\').append('\"');
                continue;
            }
            b.append(c);
        }
        return b.toString();
    }

    public static String toString(Cookie c) {
        StringBuffer buf = new StringBuffer();
        buf.append(c.getName());
        buf.append("=");
        int newVersion = c.getVersion();
        CookieUtil.maybeQuote(buf, c.getValue());
        if (newVersion == 1) {
            buf.append("; Version=1");
            if (c.getComment() != null) {
                buf.append("; Comment=");
                CookieUtil.maybeQuote(buf, c.getComment());
            }
        }
        if (c.getDomain() != null) {
            buf.append("; Domain=");
            CookieUtil.maybeQuote(buf, c.getDomain());
        }
        if (c.getMaxAge() >= 0) {
            if (newVersion > 0) {
                buf.append("; Max-Age=");
                buf.append(c.getMaxAge());
            }
            if (newVersion == 0) {
                buf.append("; Expires=");
                if (c.getMaxAge() == 0) {
                    buf.append(ancientDate);
                } else {
                    OLD_COOKIE_FORMAT.get().format(new Date(System.currentTimeMillis() + (long)c.getMaxAge() * 1000L), buf, new FieldPosition(0));
                }
            }
        }
        if (c.getPath() != null) {
            buf.append("; Path=");
            CookieUtil.maybeQuote(buf, c.getPath());
        }
        if (c.getSecure()) {
            buf.append("; Secure");
        }
        if (c.isHttpOnly()) {
            buf.append("; HttpOnly");
        }
        return buf.toString();
    }

    private static void maybeQuote(StringBuffer buf, String value) {
        if (value == null || value.length() == 0) {
            buf.append("\"\"");
        } else if (CookieUtil.alreadyQuoted(value)) {
            buf.append('\"');
            buf.append(CookieUtil.escapeDoubleQuotes(value, value.length() - 1));
            buf.append('\"');
        } else {
            buf.append(value);
        }
    }

    public static boolean alreadyQuoted(String value) {
        if (value == null || value.length() < 2) {
            return false;
        }
        return value.charAt(0) == '\"' && value.charAt(value.length() - 1) == '\"';
    }

    private static String escapeDoubleQuotes(String s, int endIndex) {
        if (s == null || s.length() == 0 || s.indexOf(34) == -1) {
            return s;
        }
        StringBuilder b = new StringBuilder();
        for (int i = 1; i < endIndex; ++i) {
            char c = s.charAt(i);
            if (c == '\\') {
                b.append(c);
                if (++i >= endIndex) {
                    throw new IllegalArgumentException("Invalid escape character in cookie value.");
                }
                b.append(s.charAt(i));
                continue;
            }
            if (c == '\"') {
                b.append('\\').append('\"');
                continue;
            }
            b.append(c);
        }
        return b.toString();
    }

    private static BitSet validCookieNameOctets() {
        int[] separators;
        BitSet bits = new BitSet();
        for (int i = 32; i < 127; ++i) {
            bits.set(i);
        }
        for (int separator : separators = new int[]{40, 41, 60, 62, 64, 44, 59, 58, 92, 34, 47, 91, 93, 63, 61, 123, 125, 32, 9}) {
            bits.set(separator, false);
        }
        return bits;
    }

    private static BitSet validCookieValueOctets() {
        int i;
        BitSet bits = new BitSet();
        bits.set(33);
        for (i = 35; i <= 43; ++i) {
            bits.set(i);
        }
        for (i = 45; i <= 58; ++i) {
            bits.set(i);
        }
        for (i = 60; i <= 91; ++i) {
            bits.set(i);
        }
        for (i = 93; i <= 126; ++i) {
            bits.set(i);
        }
        return bits;
    }

    private static BitSet validCookieAttributeValueOctets() {
        BitSet bits = new BitSet();
        for (int i = 32; i < 127; ++i) {
            bits.set(i);
        }
        bits.set(59, false);
        return bits;
    }

    static int firstInvalidCookieNameOctet(CharSequence cs) {
        return CookieUtil.firstInvalidOctet(cs, VALID_COOKIE_NAME_OCTETS);
    }

    static int firstInvalidCookieValueOctet(CharSequence cs) {
        return CookieUtil.firstInvalidOctet(cs, VALID_COOKIE_VALUE_OCTETS);
    }

    static int firstInvalidOctet(CharSequence cs, BitSet bits) {
        for (int i = 0; i < cs.length(); ++i) {
            char c = cs.charAt(i);
            if (bits.get(c)) continue;
            return i;
        }
        return -1;
    }

    static CharSequence unwrapValue(CharSequence cs) {
        int len = cs.length();
        if (len > 0 && cs.charAt(0) == '\"') {
            if (len >= 2 && cs.charAt(len - 1) == '\"') {
                return len == 2 ? "" : cs.subSequence(1, len - 1);
            }
            return null;
        }
        return cs;
    }

    static String validateAttributeValue(String name, String value) {
        if (value == null) {
            return null;
        }
        if ((value = value.trim()).isEmpty()) {
            return null;
        }
        int i = CookieUtil.firstInvalidOctet(value, VALID_COOKIE_ATTRIBUTE_VALUE_OCTETS);
        if (i != -1) {
            throw new IllegalArgumentException(name + " contains the prohibited characters: " + value.charAt(i));
        }
        return value;
    }

    static {
        VALID_COOKIE_NAME_OCTETS = CookieUtil.validCookieNameOctets();
        VALID_COOKIE_VALUE_OCTETS = CookieUtil.validCookieValueOctets();
        VALID_COOKIE_ATTRIBUTE_VALUE_OCTETS = CookieUtil.validCookieAttributeValueOctets();
        ancientDate = OLD_COOKIE_FORMAT.get().format(new Date(10000L));
    }

    public static final class ServerCookieDecoder
    extends CookieDecoder {
        private static final String RFC2965_VERSION = "$Version";
        private static final String RFC2965_PATH = "$Path";
        private static final String RFC2965_DOMAIN = "$Domain";
        private static final String RFC2965_PORT = "$Port";
        public static final ServerCookieDecoder STRICT = new ServerCookieDecoder(true);

        private ServerCookieDecoder(boolean strict) {
            super(strict);
        }

        public Set<Cookie> decode(String header) {
            HashSet<Cookie> cookies = new HashSet<Cookie>();
            this.decode(header, cookies);
            return cookies;
        }

        public void decode(String header, Set<Cookie> cookies) {
            int headerLen = header.length();
            if (headerLen == 0) {
                return;
            }
            int i = 0;
            boolean rfc2965Style = false;
            if (header.regionMatches(true, 0, RFC2965_VERSION, 0, RFC2965_VERSION.length())) {
                i = header.indexOf(59) + 1;
                rfc2965Style = true;
            }
            while (i != headerLen) {
                Cookie cookie;
                int valueEnd;
                int valueBegin;
                int nameEnd;
                int nameBegin;
                block10: {
                    char c = header.charAt(i);
                    if (c == '\t' || c == '\n' || c == '\u000b' || c == '\f' || c == '\r' || c == ' ' || c == ',' || c == ';') {
                        ++i;
                        continue;
                    }
                    nameBegin = i;
                    nameEnd = i;
                    valueBegin = -1;
                    valueEnd = -1;
                    if (i != headerLen) {
                        do {
                            char curChar;
                            if ((curChar = header.charAt(i)) == ';') {
                                nameEnd = i;
                                valueEnd = -1;
                                valueBegin = -1;
                            } else {
                                if (curChar != '=') continue;
                                nameEnd = i++;
                                if (i == headerLen) {
                                    valueEnd = 0;
                                    valueBegin = 0;
                                } else {
                                    valueBegin = i;
                                    int semiPos = header.indexOf(59, i);
                                    i = semiPos > 0 ? semiPos : headerLen;
                                    valueEnd = i;
                                }
                            }
                            break block10;
                        } while (++i != headerLen);
                        nameEnd = headerLen;
                        valueEnd = -1;
                        valueBegin = -1;
                    }
                }
                if (rfc2965Style && (header.regionMatches(nameBegin, RFC2965_PATH, 0, RFC2965_PATH.length()) || header.regionMatches(nameBegin, RFC2965_DOMAIN, 0, RFC2965_DOMAIN.length()) || header.regionMatches(nameBegin, RFC2965_PORT, 0, RFC2965_PORT.length())) || (cookie = this.initCookie(header, nameBegin, nameEnd, valueBegin, valueEnd)) == null) continue;
                cookies.add(cookie);
            }
        }
    }

    static abstract class CookieDecoder {
        private final boolean strict;

        protected CookieDecoder(boolean strict) {
            this.strict = strict;
        }

        protected Cookie initCookie(String header, int nameBegin, int nameEnd, int valueBegin, int valueEnd) {
            if (nameBegin == -1 || nameBegin == nameEnd) {
                return null;
            }
            if (valueBegin == -1) {
                return null;
            }
            CharBuffer wrappedValue = CharBuffer.wrap(header, valueBegin, valueEnd);
            CharSequence unwrappedValue = CookieUtil.unwrapValue(wrappedValue);
            if (unwrappedValue == null) {
                return null;
            }
            String name = header.substring(nameBegin, nameEnd);
            if (this.strict && CookieUtil.firstInvalidCookieNameOctet(name) >= 0) {
                return null;
            }
            if (this.strict && CookieUtil.firstInvalidCookieValueOctet(unwrappedValue) >= 0) {
                return null;
            }
            return new Cookie(name, unwrappedValue.toString());
        }
    }
}

