/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.inject;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import javax.inject.Named;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.inject.InjectIntrospectorAdapter;
import org.atmosphere.inject.annotation.RequestScoped;
import org.atmosphere.util.ThreadLocalInvoker;

@RequestScoped
public class BroadcasterIntrospector
extends InjectIntrospectorAdapter<Broadcaster> {
    private final ThreadLocal<String> nameLocal = new ThreadLocal();

    @Override
    public boolean supportedType(Type t) {
        return t instanceof Class && Broadcaster.class.isAssignableFrom((Class)t);
    }

    @Override
    public Broadcaster injectable(AtmosphereResource r) {
        String named = this.nameLocal.get();
        if (named == null) {
            named = "/*";
        }
        String s = (String)r.getRequest().getAttribute(Named.class.getName());
        int indx = named.indexOf("{");
        if (s != null && indx != -1) {
            named = named.substring(0, indx) + s;
        }
        final Object broadcaster = r.getAtmosphereConfig().getBroadcasterFactory().lookup(named, true);
        return (Broadcaster)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{Broadcaster.class}, (InvocationHandler)new ThreadLocalInvoker<Broadcaster>(){
            {
                this.set(broadcaster);
            }

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                return method.invoke((Object)broadcaster, args);
            }
        });
    }

    @Override
    public void introspectField(Class clazz, Field f) {
        if (f.isAnnotationPresent(Named.class)) {
            String name = f.getAnnotation(Named.class).value();
            if (name.isEmpty()) {
                name = f.getName();
            }
            this.nameLocal.set(name);
        }
    }
}

