/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.client;

import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.MalformedInputException;
import java.util.Arrays;
import java.util.HashSet;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.AsyncIOInterceptorAdapter;
import org.atmosphere.cpr.AsyncIOWriter;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereInterceptorAdapter;
import org.atmosphere.cpr.AtmosphereInterceptorWriter;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.interceptor.InvokationOrder;
import org.atmosphere.util.IOUtils;
import org.atmosphere.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrackMessageSizeInterceptor
extends AtmosphereInterceptorAdapter {
    private static final Logger logger = LoggerFactory.getLogger(TrackMessageSizeInterceptor.class);
    private static final byte[] END = "|".getBytes();
    private static final String IN_ENCODING = "UTF-8";
    private static final String OUT_ENCODING = "UTF-8";
    public static final String SKIP_INTERCEPTOR = TrackMessageSizeInterceptor.class.getName() + ".skip";
    private String endString = "|";
    private final Charset inCharset = Charset.forName("UTF-8");
    private final Charset outCharset = Charset.forName("UTF-8");
    private final HashSet<String> excludedContentTypes = new HashSet();
    private final Interceptor interceptor = new Interceptor();

    @Override
    public void configure(AtmosphereConfig config) {
        String s = config.getInitParameter("org.atmosphere.client.TrackMessageSizeInterceptor.delimiter");
        if (s != null) {
            this.messageDelimiter(s);
        }
        if ((s = config.getInitParameter("org.atmosphere.client.TrackMessageSizeInterceptor.excludedContentType")) != null) {
            this.excludedContentTypes.addAll(Arrays.asList(s.split(",")));
        }
    }

    public TrackMessageSizeInterceptor messageDelimiter(String endString) {
        this.endString = endString;
        return this;
    }

    public TrackMessageSizeInterceptor excludedContentType(String excludedContentType) {
        this.excludedContentTypes.add(excludedContentType.toLowerCase());
        return this;
    }

    public HashSet<String> excludedContentTypes() {
        return this.excludedContentTypes;
    }

    @Override
    public Action inspect(AtmosphereResource r) {
        if (AtmosphereResource.TRANSPORT.UNDEFINED == r.transport() || Utils.webSocketMessage(r)) {
            return Action.CONTINUE;
        }
        AtmosphereResponse response = r.getResponse();
        super.inspect(r);
        AsyncIOWriter writer = response.getAsyncIOWriter();
        if (AtmosphereInterceptorWriter.class.isAssignableFrom(writer.getClass())) {
            ((AtmosphereInterceptorWriter)writer).interceptor(this.interceptor);
        } else {
            logger.warn("Unable to apply {}. Your AsyncIOWriter must implement {}", (Object)this.getClass().getName(), (Object)AtmosphereInterceptorWriter.class.getName());
        }
        return Action.CONTINUE;
    }

    @Override
    public String toString() {
        return " Track Message Size Interceptor using " + this.endString;
    }

    @Override
    public InvokationOrder.PRIORITY priority() {
        return InvokationOrder.BEFORE_DEFAULT;
    }

    private final class Interceptor
    extends AsyncIOInterceptorAdapter {
        private Interceptor() {
        }

        @Override
        public byte[] transformPayload(AtmosphereResponse response, byte[] responseDraft, byte[] data) throws IOException {
            boolean writeAsBytes = IOUtils.isBodyBinary(response.request());
            if (writeAsBytes) {
                logger.warn("Cannot use TrackMessageSizeInterceptor with binary write. Writing the message as it is.");
                return responseDraft;
            }
            if (response.request().getAttribute(SKIP_INTERCEPTOR) == null && Boolean.parseBoolean(response.request().getHeader("X-Atmosphere-TrackMessageSize")) && (response.getContentType() == null || !TrackMessageSizeInterceptor.this.excludedContentTypes.contains(response.getContentType().toLowerCase()))) {
                try {
                    response.setCharacterEncoding("UTF-8");
                    CharBuffer cb = TrackMessageSizeInterceptor.this.inCharset.newDecoder().decode(ByteBuffer.wrap(responseDraft, 0, responseDraft.length));
                    if (cb.length() == 0) {
                        return responseDraft;
                    }
                    AtmosphereResource r = response.resource();
                    if (r == null) {
                        throw new IOException("Connection Closed by the Client " + response.uuid());
                    }
                    int size = cb.length();
                    String csq = size + TrackMessageSizeInterceptor.this.endString;
                    ByteBuffer bb = ByteBuffer.allocate(csq.getBytes().length + responseDraft.length);
                    CharBuffer cb2 = CharBuffer.wrap(csq);
                    CharsetEncoder encoder = TrackMessageSizeInterceptor.this.outCharset.newEncoder();
                    encoder.encode(cb2, bb, false);
                    encoder.encode(cb, bb, false);
                    ((Buffer)bb).flip();
                    byte[] b = new byte[bb.limit()];
                    bb.get(b);
                    return b;
                }
                catch (MalformedInputException ex) {
                    logger.warn("Cannot decode the response bytes for {}. Writing the message as it is", (Object)response.uuid(), (Object)ex);
                    return responseDraft;
                }
            }
            return responseDraft;
        }
    }
}

