/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.pool;

import java.util.Collection;
import java.util.Collections;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.DefaultBroadcasterFactory;
import org.atmosphere.pool.PoolableProvider;
import org.atmosphere.pool.UnboundedApachePoolableProvider;
import org.atmosphere.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PoolableBroadcasterFactory
extends DefaultBroadcasterFactory {
    private static final Logger logger = LoggerFactory.getLogger(PoolableBroadcasterFactory.class);
    private PoolableProvider<? extends Broadcaster, ?> poolableProvider;
    private static final String POOLED_ID = "POOLED";
    private static final Collection emptyCollection = Collections.emptySet();
    private boolean trackPooledBroadcaster;

    public PoolableBroadcasterFactory() {
    }

    @Deprecated
    public PoolableBroadcasterFactory(Class<? extends Broadcaster> clazz, String broadcasterLifeCyclePolicy, AtmosphereConfig c) {
        super(clazz, broadcasterLifeCyclePolicy, c);
    }

    @Override
    protected void configure(String broadcasterLifeCyclePolicy) {
        super.configure(broadcasterLifeCyclePolicy);
        String poolableProviderClass = this.config.getInitParameter("org.atmosphere.pool.poolableProvider", UnboundedApachePoolableProvider.class.getName());
        try {
            this.poolableProvider = this.config.framework().newClassInstance(PoolableProvider.class, IOUtils.loadClass(PoolableProvider.class, poolableProviderClass));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.poolableProvider.configure(this.config);
        this.trackPooledBroadcaster = this.config.getInitParameter("org.atmosphere.pool.trackPooledBroadcaster", false);
    }

    @Override
    public Broadcaster get() {
        return this.get(POOLED_ID);
    }

    @Override
    public boolean add(Broadcaster b, Object id) {
        if (this.trackPooledBroadcaster) {
            super.add(b, id);
        }
        this.poolableProvider.returnBroadcaster(b);
        return true;
    }

    @Override
    public boolean remove(Broadcaster b, Object id) {
        if (this.trackPooledBroadcaster) {
            return this.store.remove(b) != null;
        }
        this.poolableProvider.returnBroadcaster(b);
        return false;
    }

    @Override
    public <T extends Broadcaster> T lookup(Class<T> c, Object id, boolean createIfNull, boolean unique) {
        Broadcaster broadcaster = null;
        if (this.trackPooledBroadcaster) {
            broadcaster = (Broadcaster)this.store.get(id);
        }
        if (broadcaster == null) {
            broadcaster = this.poolableProvider.borrowBroadcaster(id);
        }
        return (T)broadcaster;
    }

    @Override
    public void removeAllAtmosphereResource(AtmosphereResource r) {
        logger.debug("Operation no supported");
        if (this.trackPooledBroadcaster) {
            super.removeAllAtmosphereResource(r);
        }
    }

    @Override
    public boolean remove(Object id) {
        if (this.trackPooledBroadcaster) {
            super.remove(id);
        } else {
            logger.debug("Operation no supported");
        }
        return false;
    }

    @Override
    public Collection<Broadcaster> lookupAll() {
        if (this.trackPooledBroadcaster) {
            super.lookupAll();
        }
        return emptyCollection;
    }

    public Broadcaster createBroadcaster() {
        return this.createBroadcaster(this.clazz, POOLED_ID);
    }

    public PoolableBroadcasterFactory trackPooledBroadcaster(boolean trackPooledBroadcaster) {
        this.trackPooledBroadcaster = trackPooledBroadcaster;
        return this;
    }

    public boolean trackPooledBroadcaster() {
        return this.trackPooledBroadcaster;
    }

    public PoolableProvider<? extends Broadcaster, ?> poolableProvider() {
        return this.poolableProvider;
    }

    public PoolableBroadcasterFactory poolableProvider(PoolableProvider<? extends Broadcaster, ?> poolableProvider) {
        this.poolableProvider = poolableProvider;
        this.poolableProvider.configure(this.config);
        return this;
    }
}

