/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.config.managed;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.atmosphere.config.managed.Decoder;
import org.atmosphere.config.managed.Encoder;
import org.atmosphere.config.managed.Invoker;
import org.atmosphere.config.service.Delete;
import org.atmosphere.config.service.DeliverTo;
import org.atmosphere.config.service.Disconnect;
import org.atmosphere.config.service.Get;
import org.atmosphere.config.service.Heartbeat;
import org.atmosphere.config.service.Message;
import org.atmosphere.config.service.PathParam;
import org.atmosphere.config.service.Post;
import org.atmosphere.config.service.Put;
import org.atmosphere.config.service.Ready;
import org.atmosphere.config.service.Resume;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.atmosphere.cpr.AtmosphereResourceEventListenerAdapter;
import org.atmosphere.cpr.AtmosphereResourceFactory;
import org.atmosphere.cpr.AtmosphereResourceHeartbeatEventListener;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.handler.AbstractReflectorAtmosphereHandler;
import org.atmosphere.handler.AnnotatedProxy;
import org.atmosphere.util.IOUtils;
import org.atmosphere.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedAtmosphereHandler
extends AbstractReflectorAtmosphereHandler
implements AnnotatedProxy,
AtmosphereResourceHeartbeatEventListener {
    private static IllegalArgumentException IAE;
    private Logger logger = LoggerFactory.getLogger(ManagedAtmosphereHandler.class);
    private static final List<Decoder<?, ?>> EMPTY;
    private Object proxiedInstance;
    protected List<MethodInfo> onRuntimeMethod;
    private Method onHeartbeatMethod;
    private Method onDisconnectMethod;
    private Method onTimeoutMethod;
    private Method onGetMethod;
    private Method onPostMethod;
    private Method onPutMethod;
    private Method onDeleteMethod;
    private Method onReadyMethod;
    private Method onResumeMethod;
    private AtmosphereConfig config;
    protected boolean pathParams;
    protected AtmosphereResourceFactory resourcesFactory;
    final Map<Method, List<Encoder<?, ?>>> encoders = new HashMap();
    final Map<Method, List<Decoder<?, ?>>> decoders = new HashMap();

    @Override
    public AnnotatedProxy configure(AtmosphereConfig config, Object c) {
        this.proxiedInstance = c;
        this.onRuntimeMethod = this.populateMessage(c, Message.class);
        this.onHeartbeatMethod = this.populate(c, Heartbeat.class);
        this.onDisconnectMethod = this.populate(c, Disconnect.class);
        this.onTimeoutMethod = this.populate(c, Resume.class);
        this.onGetMethod = this.populate(c, Get.class);
        this.onPostMethod = this.populate(c, Post.class);
        this.onPutMethod = this.populate(c, Put.class);
        this.onDeleteMethod = this.populate(c, Delete.class);
        this.onReadyMethod = this.populate(c, Ready.class);
        this.onResumeMethod = this.populate(c, Resume.class);
        this.config = config;
        this.pathParams = this.pathParams(c);
        this.resourcesFactory = config.resourcesFactory();
        this.scanForReaderOrInputStream();
        this.populateEncoders();
        this.populateDecoders();
        return this;
    }

    @Override
    public void onRequest(final AtmosphereResource resource) throws IOException {
        AtmosphereRequest request = resource.getRequest();
        String method = request.getMethod();
        boolean polling = Utils.pollableTransport(resource.transport());
        boolean webSocketMessage = Utils.webSocketMessage(resource);
        if (!webSocketMessage && !polling) {
            if (this.onReadyMethod != null) {
                resource.addEventListener(new AtmosphereResourceEventListenerAdapter.OnSuspend(){

                    @Override
                    public void onSuspend(AtmosphereResourceEvent event) {
                        ManagedAtmosphereHandler.this.processReady(event.getResource());
                        resource.removeEventListener(this);
                    }
                });
            }
            if (this.onResumeMethod != null) {
                resource.addEventListener(new AtmosphereResourceEventListenerAdapter.OnResume(){

                    @Override
                    public void onResume(AtmosphereResourceEvent event) {
                        ManagedAtmosphereHandler.this.invoke(ManagedAtmosphereHandler.this.onResumeMethod, event);
                        resource.removeEventListener(this);
                    }
                });
            }
            resource.addEventListener(new AtmosphereResourceEventListenerAdapter.OnClose(){

                @Override
                public void onClose(AtmosphereResourceEvent event) {
                    ManagedAtmosphereHandler.this.invoke(ManagedAtmosphereHandler.this.onDisconnectMethod, event);
                }
            });
        }
        if (method.equalsIgnoreCase("get")) {
            this.invoke(this.onGetMethod, resource);
        } else if (method.equalsIgnoreCase("post")) {
            MethodInfo.EncoderObject e;
            Object body = null;
            if (this.onPostMethod != null) {
                body = IOUtils.readEntirely(resource);
                if (body != null && String.class.isAssignableFrom(body.getClass())) {
                    resource.getRequest().body((String)body);
                } else if (body != null) {
                    resource.getRequest().body((byte[])body);
                }
                this.invoke(this.onPostMethod, resource);
            }
            if ((e = this.message(resource, body)) != null && e.encodedObject != null) {
                AtmosphereResource r = resource;
                if (e.methodInfo.deliverTo == DeliverTo.DELIVER_TO.RESOURCE && !resource.transport().equals((Object)AtmosphereResource.TRANSPORT.WEBSOCKET)) {
                    r = this.resourcesFactory.find(resource.uuid());
                }
                IOUtils.deliver(new Managed(e.encodedObject), null, e.methodInfo.deliverTo, r);
            }
        } else if (method.equalsIgnoreCase("delete")) {
            this.invoke(this.onDeleteMethod, resource);
        } else if (method.equalsIgnoreCase("put")) {
            this.invoke(this.onPutMethod, resource);
        }
    }

    @Override
    public void onStateChange(AtmosphereResourceEvent event) throws IOException {
        Object o;
        Object msg = event.getMessage();
        AtmosphereResourceImpl r = (AtmosphereResourceImpl)AtmosphereResourceImpl.class.cast(event.getResource());
        Boolean resumeOnBroadcast = r.resumeOnBroadcast();
        if (!resumeOnBroadcast.booleanValue() && (o = r.getRequest(false).getAttribute("org.atmosphere.resumeOnBroadcast")) != null && Boolean.class.isAssignableFrom(o.getClass())) {
            resumeOnBroadcast = (Boolean)Boolean.class.cast(o);
        }
        if (resumeOnBroadcast.booleanValue()) {
            r.resumeOnBroadcast(false);
            r.getRequest(false).setAttribute("org.atmosphere.resumeOnBroadcast", false);
        }
        if (event.isCancelled() || event.isClosedByClient()) {
            this.invoke(this.onDisconnectMethod, event);
        } else if (event.isResumedOnTimeout() || event.isResuming()) {
            this.invoke(this.onTimeoutMethod, event);
        } else {
            if (msg != null) {
                if (Managed.class.isAssignableFrom(msg.getClass())) {
                    Object newMsg = ((Managed)Managed.class.cast((Object)msg)).o;
                    event.setMessage(newMsg);
                    if (r.getBroadcaster().getBroadcasterConfig().hasFilters()) {
                        for (MethodInfo m : this.onRuntimeMethod) {
                            o = Invoker.encode(this.encoders.get(m.method), newMsg);
                            if (o == null) continue;
                            event.setMessage(o);
                            break;
                        }
                    }
                } else {
                    this.logger.trace("BroadcasterFactory has been used, this may produce recursion if encoder/decoder match the broadcasted message");
                    MethodInfo.EncoderObject e = this.message(r, msg);
                    Object object = o = e == null ? null : e.encodedObject;
                    if (o != null) {
                        event.setMessage(o);
                    }
                }
            }
            super.onStateChange(event);
        }
        if (resumeOnBroadcast.booleanValue() && r.isSuspended()) {
            r.resume();
        }
    }

    @Override
    public boolean pathParams() {
        return this.pathParams;
    }

    protected boolean pathParams(Object o) {
        for (Field field : o.getClass().getDeclaredFields()) {
            if (!field.isAnnotationPresent(PathParam.class)) continue;
            return true;
        }
        return false;
    }

    protected Method populate(Object c, Class<? extends Annotation> annotation) {
        for (Method m : c.getClass().getMethods()) {
            if (!m.isAnnotationPresent(annotation)) continue;
            return m;
        }
        return null;
    }

    protected List<MethodInfo> populateMessage(Object c, Class<? extends Annotation> annotation) {
        ArrayList<MethodInfo> methods = new ArrayList<MethodInfo>();
        for (Method m : c.getClass().getMethods()) {
            if (!m.isAnnotationPresent(annotation)) continue;
            methods.add(new MethodInfo(m));
        }
        return methods;
    }

    private void scanForReaderOrInputStream() {
        for (MethodInfo m : this.onRuntimeMethod) {
            Class<?>[] classes;
            for (Class<?> c : classes = m.method.getParameterTypes()) {
                if (InputStream.class.isAssignableFrom(c)) {
                    m.useStream = true;
                    continue;
                }
                if (!Reader.class.isAssignableFrom(c)) continue;
                m.useReader = true;
            }
        }
    }

    private void populateEncoders() {
        for (MethodInfo m : this.onRuntimeMethod) {
            CopyOnWriteArrayList<Encoder> l = new CopyOnWriteArrayList<Encoder>();
            for (Class<? extends Encoder> s : m.method.getAnnotation(Message.class).encoders()) {
                try {
                    l.add(this.config.framework().newClassInstance(Encoder.class, s));
                }
                catch (Exception e) {
                    this.logger.error("Unable to load encoder {}", s);
                }
            }
            this.encoders.put(m.method, l);
        }
        if (this.onReadyMethod != null) {
            CopyOnWriteArrayList<Encoder> l = new CopyOnWriteArrayList<Encoder>();
            for (Class<? extends Encoder> s : this.onReadyMethod.getAnnotation(Ready.class).encoders()) {
                try {
                    l.add(this.config.framework().newClassInstance(Encoder.class, s));
                }
                catch (Exception e) {
                    this.logger.error("Unable to load encoder {}", s);
                }
            }
            this.encoders.put(this.onReadyMethod, l);
        }
    }

    private void populateDecoders() {
        for (MethodInfo m : this.onRuntimeMethod) {
            CopyOnWriteArrayList<Decoder> l = new CopyOnWriteArrayList<Decoder>();
            for (Class<? extends Decoder> s : m.method.getAnnotation(Message.class).decoders()) {
                try {
                    l.add(this.config.framework().newClassInstance(Decoder.class, s));
                }
                catch (Exception e) {
                    this.logger.error("Unable to load encoder {}", s);
                }
            }
            this.decoders.put(m.method, l);
        }
    }

    private Object invoke(Method m, Object o) {
        return Utils.invoke(this.proxiedInstance, m, o);
    }

    private MethodInfo.EncoderObject message(AtmosphereResource resource, Object o) {
        AtmosphereRequest request = ((AtmosphereResourceImpl)AtmosphereResourceImpl.class.cast(resource)).getRequest(false);
        try {
            for (MethodInfo m : this.onRuntimeMethod) {
                if (m.useReader) {
                    o = request.getReader();
                } else if (m.useStream) {
                    o = request.getInputStream();
                } else if (o == null && IOUtils.isBodyEmpty(o = IOUtils.readEntirely(resource))) {
                    this.logger.warn("{} received an empty body", (Object)request);
                    return null;
                }
                Object decoded = Invoker.decode(this.decoders.get(m.method), o);
                if (decoded == null) {
                    decoded = o;
                }
                Object objectToEncode = null;
                if (m.method.getParameterTypes().length > 2) {
                    this.logger.warn("Injection of more than 2 parameters not supported {}", (Object)m);
                }
                if ((objectToEncode = m.method.getParameterTypes().length == 2 ? Invoker.invokeMethod(m.method, this.proxiedInstance, resource, decoded) : Invoker.invokeMethod(m.method, this.proxiedInstance, decoded)) == null) continue;
                return m.encode(this.encoders, objectToEncode);
            }
        }
        catch (Throwable t) {
            this.logger.error("", t);
        }
        return null;
    }

    private Object message(Method m, Object o) {
        if (m != null) {
            return Invoker.all(this.encoders.get(m), EMPTY, o, this.proxiedInstance, m);
        }
        return null;
    }

    @Override
    public Object target() {
        return this.proxiedInstance;
    }

    protected void processReady(AtmosphereResource r) {
        DeliverTo deliverTo;
        final Ready ready = this.onReadyMethod.getAnnotation(Ready.class);
        if (ready.value() != Ready.DELIVER_TO.RESOURCE) {
            if (IAE == null) {
                IAE = new IllegalArgumentException();
            }
            this.logger.warn("Since 2.2, delivery strategy must be specified with @DeliverTo, not with a value in the @Ready annotation.", (Throwable)IAE);
            deliverTo = new DeliverTo(){

                @Override
                public DeliverTo.DELIVER_TO value() {
                    switch (ready.value()) {
                        case ALL: {
                            return DeliverTo.DELIVER_TO.ALL;
                        }
                        case BROADCASTER: {
                            return DeliverTo.DELIVER_TO.BROADCASTER;
                        }
                    }
                    return null;
                }

                @Override
                public Class<? extends Annotation> annotationType() {
                    return null;
                }
            };
        } else {
            deliverTo = this.onReadyMethod.getAnnotation(DeliverTo.class);
        }
        IOUtils.deliver(this.message(this.onReadyMethod, (Object)r), deliverTo, DeliverTo.DELIVER_TO.RESOURCE, r);
    }

    @Override
    public void onHeartbeat(AtmosphereResourceEvent event) {
        if (this.onHeartbeatMethod != null) {
            this.invoke(this.onHeartbeatMethod, event);
        }
    }

    public String toString() {
        return "ManagedAtmosphereHandler proxy for " + this.proxiedInstance.getClass().getName();
    }

    static {
        EMPTY = Collections.emptyList();
    }

    public static final class Managed
    implements Serializable {
        private static final long serialVersionUID = -126253550299206646L;
        final Object o;

        public Managed(Object o) {
            this.o = o;
        }

        public String toString() {
            return this.o.toString();
        }

        public Object object() {
            return this.o;
        }
    }

    public static final class MethodInfo {
        final Method method;
        final DeliverTo.DELIVER_TO deliverTo;
        boolean useStream;
        boolean useReader;

        public MethodInfo(Method method) {
            this.method = method;
            this.deliverTo = method.isAnnotationPresent(DeliverTo.class) ? method.getAnnotation(DeliverTo.class).value() : DeliverTo.DELIVER_TO.BROADCASTER;
        }

        EncoderObject encode(Map<Method, List<Encoder<?, ?>>> encoders, Object objectToEncode) {
            return new EncoderObject(encoders, objectToEncode);
        }

        class EncoderObject {
            final Object encodedObject;
            final MethodInfo methodInfo;

            public EncoderObject(Map<Method, List<Encoder<?, ?>>> encoders, Object objectToEncode) {
                this.encodedObject = Invoker.encode(encoders.get(MethodInfo.this.method), objectToEncode);
                this.methodInfo = MethodInfo.this;
            }
        }
    }
}

