/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.websocket.protocol;

import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.websocket.WebSocket;
import org.atmosphere.websocket.WebSocketProcessor;
import org.atmosphere.websocket.WebSocketProtocolStream;
import org.atmosphere.websocket.protocol.ProtocolUtil;
import org.atmosphere.websocket.protocol.SimpleHttpProtocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamingHttpProtocol
implements WebSocketProtocolStream {
    private static final Logger logger = LoggerFactory.getLogger(StreamingHttpProtocol.class);
    protected static final String TEXT = "text/plain";
    protected String contentType = "text/plain";
    protected String methodType = "POST";
    protected String delimiter = "@@";
    protected boolean destroyable;
    private final SimpleHttpProtocol delegate = new SimpleHttpProtocol();

    @Override
    public void configure(AtmosphereConfig config) {
        String contentType = config.getInitParameter("org.atmosphere.websocket.messageContentType");
        if (contentType == null) {
            contentType = TEXT;
        }
        this.contentType = contentType;
        String methodType = config.getInitParameter("org.atmosphere.websocket.messageMethod");
        if (methodType == null) {
            methodType = "POST";
        }
        this.methodType = methodType;
        String delimiter = config.getInitParameter("org.atmosphere.websocket.pathDelimiter");
        if (delimiter == null) {
            delimiter = "@@";
        }
        this.delimiter = delimiter;
        String s = config.getInitParameter("org.atmosphere.cpr.recycleAtmosphereRequestResponse");
        this.destroyable = s != null && Boolean.valueOf(s) != false;
    }

    @Override
    public List<AtmosphereRequest> onTextStream(WebSocket webSocket, Reader r) {
        AtmosphereResourceImpl resource = (AtmosphereResourceImpl)webSocket.resource();
        if (resource == null) {
            logger.trace("The WebSocket has been closed before the message was processed.");
            return null;
        }
        AtmosphereRequest request = resource.getRequest();
        ArrayList<AtmosphereRequest> list = new ArrayList<AtmosphereRequest>();
        list.add(ProtocolUtil.constructRequest(resource, request.getPathInfo(), request.getRequestURI(), this.methodType, this.contentType.equalsIgnoreCase(TEXT) ? null : this.contentType, this.destroyable).reader(r).build());
        return list;
    }

    @Override
    public List<AtmosphereRequest> onBinaryStream(WebSocket webSocket, InputStream stream) {
        AtmosphereResourceImpl resource = (AtmosphereResourceImpl)webSocket.resource();
        if (resource == null) {
            logger.trace("The WebSocket has been closed before the message was processed.");
            return null;
        }
        AtmosphereRequest request = resource.getRequest();
        ArrayList<AtmosphereRequest> list = new ArrayList<AtmosphereRequest>();
        list.add(ProtocolUtil.constructRequest(resource, request.getPathInfo(), request.getRequestURI(), this.methodType, this.contentType.equalsIgnoreCase(TEXT) ? null : this.contentType, this.destroyable).inputStream(stream).build());
        return list;
    }

    @Override
    public List<AtmosphereRequest> onMessage(WebSocket webSocket, String data) {
        return this.delegate.onMessage(webSocket, data);
    }

    @Override
    public List<AtmosphereRequest> onMessage(WebSocket webSocket, byte[] data, int offset, int length) {
        return this.delegate.onMessage(webSocket, data, offset, length);
    }

    @Override
    public void onOpen(WebSocket webSocket) {
    }

    @Override
    public void onClose(WebSocket webSocket) {
    }

    @Override
    public void onError(WebSocket webSocket, WebSocketProcessor.WebSocketException t) {
        logger.warn(t.getMessage() + " Status {} Message {}", (Object)t.response().getStatus(), (Object)t.response().getStatusMessage());
    }
}

