/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtmosphereFrameworkInitializer {
    protected static final Logger logger = LoggerFactory.getLogger(AtmosphereFrameworkInitializer.class);
    protected AtmosphereFramework framework;
    protected boolean isFilter;
    protected boolean autoDetectHandlers;

    public AtmosphereFrameworkInitializer(boolean isFilter, boolean autoDetectHandlers) {
        this.isFilter = isFilter;
        this.autoDetectHandlers = autoDetectHandlers;
    }

    public AtmosphereFrameworkInitializer configureFramework(ServletConfig sc) throws ServletException {
        return this.configureFramework(sc, true, false, AtmosphereFramework.class);
    }

    public AtmosphereFrameworkInitializer configureFramework(ServletConfig sc, boolean init, boolean useNative, Class<? extends AtmosphereFramework> frameworkClass) throws ServletException {
        if (this.framework == null) {
            if (sc.getServletContext().getMajorVersion() > 2) {
                try {
                    this.framework = (AtmosphereFramework)sc.getServletContext().getAttribute(sc.getServletContext().getServletRegistration(sc.getServletName()).getName());
                }
                catch (Exception ex) {
                    if (UnsupportedOperationException.class.isAssignableFrom(ex.getClass())) {
                        logger.warn("WebLogic 12c unable to retrieve Servlet. Please make sure your servlet-name is 'AtmosphereServlet' or set org.atmosphere.servlet to the current value");
                        String name = sc.getInitParameter("org.atmosphere.servlet");
                        if (name == null) {
                            name = AtmosphereServlet.class.getSimpleName();
                        }
                        this.framework = (AtmosphereFramework)sc.getServletContext().getAttribute(name);
                    }
                    logger.trace("", (Throwable)ex);
                }
            }
            if (this.framework == null) {
                this.framework = this.newAtmosphereFramework(frameworkClass);
            }
        }
        this.framework.setUseNativeImplementation(useNative);
        if (init) {
            this.framework.init(sc);
        }
        return this;
    }

    protected AtmosphereFramework newAtmosphereFramework(Class<? extends AtmosphereFramework> frameworkClass) {
        AtmosphereFramework framework;
        try {
            framework = frameworkClass.getDeclaredConstructor(Boolean.class, Boolean.class).newInstance(this.isFilter, this.autoDetectHandlers);
        }
        catch (Exception e) {
            framework = new AtmosphereFramework(this.isFilter, this.autoDetectHandlers);
        }
        return framework;
    }

    public AtmosphereFramework framework() {
        if (this.framework == null) {
            this.framework = this.newAtmosphereFramework(AtmosphereFramework.class);
        }
        return this.framework;
    }

    public void destroy() {
        if (this.framework != null) {
            this.framework.destroy();
            this.framework = null;
        }
    }
}

