/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cache;

import java.util.Collections;
import java.util.List;
import org.atmosphere.cache.AbstractBroadcasterCache;
import org.atmosphere.cache.BroadcastMessage;
import org.atmosphere.cache.CacheMessage;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeaderBroadcasterCache
extends AbstractBroadcasterCache {
    private final Logger logger = LoggerFactory.getLogger(HeaderBroadcasterCache.class);

    @Override
    public CacheMessage addToCache(String broadcasterId, String uuid, BroadcastMessage e) {
        AtmosphereResource r;
        long now = System.nanoTime();
        CacheMessage cacheMessage = this.put(e, now, uuid);
        if (!uuid.equals("null") && (r = AtmosphereResourceFactory.getDefault().find(uuid)) != null) {
            r.getResponse().setHeader("X-Cache-Date", String.valueOf(now));
        }
        return cacheMessage;
    }

    @Override
    public List<Object> retrieveFromCache(String broadcasterId, String uuid) {
        if (uuid == null) {
            throw new IllegalArgumentException("AtmosphereResource can't be null");
        }
        AtmosphereResource r = AtmosphereResourceFactory.getDefault().find(uuid);
        if (r == null) {
            return Collections.emptyList();
        }
        AtmosphereRequest request = r.getRequest();
        String cacheHeader = request.getHeader("X-Cache-Date");
        r.getResponse().setHeader("X-Cache-Date", String.valueOf(System.nanoTime()));
        if (cacheHeader == null || cacheHeader.isEmpty()) {
            return Collections.emptyList();
        }
        long cacheHeaderTime = 0L;
        if (!cacheHeader.isEmpty()) {
            cacheHeaderTime = Long.valueOf(cacheHeader);
        }
        return this.get(cacheHeaderTime);
    }
}

